/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.specimpl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.specimpl.ResponseBuilderImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.util.AcceptableVariant;
import org.jboss.resteasy.util.DateUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestImpl
implements Request {
    private HttpHeaders headers;
    private String varyHeader;
    private String httpMethod;
    private HttpRequest request;

    public RequestImpl(HttpRequest request) {
        this.headers = request.getHttpHeaders();
        this.httpMethod = request.getHttpMethod().toUpperCase();
        this.request = request;
    }

    public String getMethod() {
        return this.httpMethod;
    }

    public MultivaluedMap<String, String> getFormParameters() {
        return this.request.getDecodedFormParameters();
    }

    public Variant selectVariant(List<Variant> variants) throws IllegalArgumentException {
        if (variants == null || variants.size() == 0) {
            throw new IllegalArgumentException("Variant list must not be zero");
        }
        List accepts = this.headers.getAcceptableMediaTypes();
        List<String> languages = ServletUtil.extractLanguages((MultivaluedMap<String, String>)this.headers.getRequestHeaders());
        List<String> encodings = this.convertString((List)this.headers.getRequestHeaders().get((Object)"Accept-Encoding"));
        this.varyHeader = ResponseBuilderImpl.createVaryHeader(variants);
        return RequestImpl.pickVariant(variants, accepts, languages, encodings);
    }

    public static Variant pickVariant(List<Variant> has, List<MediaType> accepts, List<String> languages, List<String> encodings) {
        ArrayList<AcceptableVariant> wants = new ArrayList<AcceptableVariant>();
        int langSize = languages.size();
        int encodingSize = encodings.size();
        int typeSize = accepts.size();
        int i = 0;
        if (langSize > 0 || encodingSize > 0 || typeSize > 0) {
            do {
                MediaType type = null;
                if (i < typeSize) {
                    type = accepts.get(i);
                }
                int j = 0;
                do {
                    String encoding = null;
                    if (j < encodingSize) {
                        encoding = encodings.get(j);
                    }
                    int k = 0;
                    do {
                        String language = null;
                        if (k < langSize) {
                            language = languages.get(k);
                        }
                        wants.add(new AcceptableVariant(type, language, encoding));
                    } while (++k < langSize);
                } while (++j < encodingSize);
            } while (++i < typeSize);
        }
        return AcceptableVariant.pick(has, wants);
    }

    public List<String> convertString(List<String> tags) {
        ArrayList<String> result = new ArrayList<String>();
        if (tags == null) {
            return result;
        }
        for (String tag : tags) {
            String[] split;
            for (String etag : split = tag.split(",")) {
                result.add(etag.trim());
            }
        }
        return result;
    }

    public List<EntityTag> convertEtag(List<String> tags) {
        ArrayList<EntityTag> result = new ArrayList<EntityTag>();
        for (String tag : tags) {
            String[] split;
            for (String etag : split = tag.split(",")) {
                result.add(EntityTag.valueOf((String)etag.trim()));
            }
        }
        return result;
    }

    public Response.ResponseBuilder ifMatch(List<EntityTag> ifMatch, EntityTag eTag) {
        boolean match = false;
        for (EntityTag tag : ifMatch) {
            if (!tag.equals((Object)eTag) && !tag.getValue().equals("*")) continue;
            match = true;
            break;
        }
        if (match) {
            return null;
        }
        return Response.status((int)412).tag(eTag);
    }

    public Response.ResponseBuilder ifNoneMatch(List<EntityTag> ifMatch, EntityTag eTag) {
        boolean match = false;
        for (EntityTag tag : ifMatch) {
            if (!tag.equals((Object)eTag) && !tag.getValue().equals("*")) continue;
            match = true;
            break;
        }
        if (match) {
            if ("GET".equals(this.httpMethod) || "HEAD".equals(this.httpMethod)) {
                return Response.notModified((EntityTag)eTag);
            }
            return Response.status((int)412).tag(eTag);
        }
        return null;
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        List ifNoneMatch;
        Response.ResponseBuilder builder = null;
        List ifMatch = (List)this.headers.getRequestHeaders().get((Object)"If-Match");
        if (ifMatch != null && ifMatch.size() > 0) {
            builder = this.ifMatch(this.convertEtag(ifMatch), eTag);
        }
        if (builder == null && (ifNoneMatch = (List)this.headers.getRequestHeaders().get((Object)"If-None-Match")) != null && ifNoneMatch.size() > 0) {
            builder = this.ifNoneMatch(this.convertEtag(ifNoneMatch), eTag);
        }
        if (builder != null) {
            builder.tag(eTag);
        }
        if (builder != null && this.varyHeader != null) {
            builder.header("Vary", (Object)this.varyHeader);
        }
        return builder;
    }

    public Response.ResponseBuilder ifModifiedSince(String strDate, Date lastModified) {
        Date date = DateUtil.parseDate(strDate);
        if (date.getTime() >= lastModified.getTime()) {
            return Response.notModified();
        }
        return null;
    }

    public Response.ResponseBuilder ifUnmodifiedSince(String strDate, Date lastModified) {
        Date date = DateUtil.parseDate(strDate);
        if (date.getTime() >= lastModified.getTime()) {
            return null;
        }
        return Response.status((int)412).lastModified(lastModified);
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        String ifUnmodifiedSince;
        Response.ResponseBuilder builder = null;
        String ifModifiedSince = (String)this.headers.getRequestHeaders().getFirst((Object)"If-Modified-Since");
        if (ifModifiedSince != null) {
            builder = this.ifModifiedSince(ifModifiedSince, lastModified);
        }
        if (builder == null && (ifUnmodifiedSince = (String)this.headers.getRequestHeaders().getFirst((Object)"If-Unmodified-Since")) != null) {
            builder = this.ifUnmodifiedSince(ifUnmodifiedSince, lastModified);
        }
        if (builder != null && this.varyHeader != null) {
            builder.header("Vary", (Object)this.varyHeader);
        }
        return builder;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        Response.ResponseBuilder rtn = null;
        Response.ResponseBuilder lastModifiedBuilder = this.evaluatePreconditions(lastModified);
        Response.ResponseBuilder etagBuilder = this.evaluatePreconditions(eTag);
        if (lastModifiedBuilder == null && etagBuilder == null) {
            rtn = null;
        } else if (lastModifiedBuilder != null && etagBuilder == null) {
            rtn = lastModifiedBuilder;
        } else if (lastModifiedBuilder == null && etagBuilder != null) {
            rtn = etagBuilder;
        } else {
            rtn = lastModifiedBuilder;
            rtn.tag(eTag);
        }
        if (rtn != null && this.varyHeader != null) {
            rtn.header("Vary", (Object)this.varyHeader);
        }
        return rtn;
    }
}

