/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import org.nuxeo.opensocial.container.client.ContainerEntryPoint;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.client.view.ContainerPortal;
import org.nuxeo.opensocial.container.client.view.GadgetPortlet;
import org.nuxeo.opensocial.container.client.view.SavePreferenceAsyncCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetService {
    public static native void registerService();

    public static native void resizeIframe(int var0);

    public static void setHeight(String frameId, int height) {
        ContainerPortal portal = ContainerEntryPoint.getContainerPortal();
        GadgetPortlet p = portal.getGadgetPortletByFrameId(frameId);
        GadgetBean bean = p.getGadgetBean();
        int h = height + 30;
        if (bean.getHeight() != h) {
            p.setHeight(h);
            bean.setHeight(h);
            ContainerEntryPoint.getService().saveGadget(bean, ContainerEntryPoint.getGwtParams(), null);
        }
        portal.incrementLoading();
    }

    public static native void setPref(String var0, String var1, String var2);

    public static void saveUserPref(String frameId) {
        GadgetBean bean = ContainerEntryPoint.getContainerPortal().getGadgetPortletByFrameId(frameId).getGadgetBean();
        ContainerEntryPoint.getService().saveGadgetPreferences(bean, null, ContainerEntryPoint.getGwtParams(), new SavePreferenceAsyncCallback(bean));
    }

    public static native void setAjaxPref(String var0, String var1, String var2);

    public static void saveAjaxUserPref(String frameId) {
        GadgetBean bean = ContainerEntryPoint.getContainerPortal().getGadgetPortletByFrameId(frameId).getGadgetBean();
        ContainerEntryPoint.getService().saveGadgetPreferences(bean, null, ContainerEntryPoint.getGwtParams(), null);
    }

    public static void setUserPref(String frameId, String key, String value) {
        ContainerEntryPoint.getContainerPortal().getGadgetPortletByFrameId(frameId).getGadgetBean().setPref(key, value);
    }

    public static native void setTitle(String var0);

    public static void setTitleToGadget(String frameId, String title) {
        if (title != null) {
            GadgetPortlet p = ContainerEntryPoint.getContainerPortal().getGadgetPortletByFrameId(frameId);
            p.setTitle(title);
        }
    }

    public static native String setHtmlContent(String var0);

    public static void setHtmlContentToGadget(String frameId, String content) {
        if (content != null) {
            GadgetBean b = ContainerEntryPoint.getContainerPortal().getGadgetPortletByFrameId(frameId).getGadgetBean();
            b.setHtmlContent(content);
            ContainerEntryPoint.getService().saveGadget(b, ContainerEntryPoint.getGwtParams(), null);
        }
    }

    public static native void maximize(String var0);

    public static void maximizeGadget(String frameId, String view) {
        ContainerEntryPoint.getContainerPortal().getGadgetPortletByFrameId(frameId).getTools().maximize(view);
    }

    public static native void minimize();

    public static void minimizeGadget(String frameId) {
        ContainerPortal p = ContainerEntryPoint.getContainerPortal();
        p.getGadgetPortletByFrameId(frameId).getTools().minimize();
    }

    public static native String getHtmlContent();

    public static String getHtmlContentOfGadget(String frameId) {
        String htmlContent = ContainerEntryPoint.getContainerPortal().getGadgetPortletByFrameId(frameId).getGadgetBean().getHtmlContent();
        if (htmlContent == null) {
            return "";
        }
        return htmlContent;
    }

    public static native String getGadgetId();

    public static String getGadgetIdRef(String frameId) {
        return ContainerEntryPoint.getContainerPortal().getGadgetPortletByFrameId(frameId).getGadgetBean().getRef();
    }

    public static native void showImage(JsArray<JavaScriptObject> var0, int var1);

    public static native void setRelayRpc(String var0, String var1);

    public static native void setAuthToken(String var0, String var1);

    public static String getSpaceId() {
        ContainerPortal portal = ContainerEntryPoint.getContainerPortal();
        return portal.getContainer().getSpaceId();
    }
}

