/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.client.view;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.NodeList;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.ExtElement;
import com.gwtext.client.dd.DragData;
import com.gwtext.client.dd.DragSource;
import com.gwtext.client.dd.DropTargetConfig;
import com.gwtext.client.dd.ScrollManager;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Container;
import com.gwtext.client.widgets.portal.PanelProxy;
import com.gwtext.client.widgets.portal.Portal;
import com.gwtext.client.widgets.portal.PortalColumn;
import com.gwtext.client.widgets.portal.PortalDropZone;
import java.util.ArrayList;
import org.nuxeo.opensocial.container.client.ContainerEntryPoint;
import org.nuxeo.opensocial.container.client.JsLibrary;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.client.bean.GadgetPosition;
import org.nuxeo.opensocial.container.client.view.ComplexPosGrid;
import org.nuxeo.opensocial.container.client.view.ContainerPortal;
import org.nuxeo.opensocial.container.client.view.DefaultPosGrid;
import org.nuxeo.opensocial.container.client.view.GadgetPortlet;
import org.nuxeo.opensocial.container.client.view.PosGrid;
import org.nuxeo.opensocial.container.client.view.SaveGadgetAsyncCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropZone
extends PortalDropZone {
    private static final String DEFAULT = "default";
    private static final String ZONE_CLASS = "x-column-possible";
    private static final int GHOST_HEIGHT = 100;
    private static final int GHOST_WIDTH = 140;
    private static ContainerPortal portal;
    private int lastCW = -1;
    private PosGrid[] grid;
    private Container lastPosC;
    private int col;

    public DropZone(ContainerPortal portal, DropTargetConfig config) {
        super((Portal)portal, config);
        ScrollManager.register((com.google.gwt.user.client.Element)portal.getBody().getDOM());
        DropZone.portal = portal;
        DropZone.overrideDragDrop(140, 100, ZONE_CLASS);
    }

    private static native void overrideDragDrop(int var0, int var1, String var2);

    public String notifyOver(DragSource source, EventObject e, DragData data) {
        int[] xy = e.getXY();
        PanelProxy proxy = new PanelProxy(source.getProxy().getJsObj());
        if (this.grid == null) {
            this.grid = this.getGrid();
        }
        int cw = portal.getBody().getClientWidth();
        if (this.lastCW == -1) {
            this.lastCW = cw;
        } else if (this.lastCW != cw) {
            this.lastCW = cw;
            portal.doLayout();
            this.grid = this.getGrid();
        }
        this.col = 0;
        boolean cmatch = false;
        int len = this.grid.length;
        while (this.col < len) {
            PosGrid posGrid = this.grid[this.col];
            if (posGrid.isCol(xy)) {
                cmatch = true;
                break;
            }
            ++this.col;
        }
        if (!cmatch) {
            --this.col;
        }
        boolean match = false;
        int pos = 0;
        this.lastPosC = (Container)portal.getItems()[this.col];
        Component[] items = this.lastPosC.getItems();
        Component p = null;
        for (pos = 0; pos < items.length; ++pos) {
            p = items[pos];
            int height = p.getEl().getHeight();
            if (height == 0 || p.getEl().getY() + height / 2 <= xy[1]) continue;
            match = true;
            break;
        }
        proxy.getProxy().setWidth("auto", false);
        if (p != null) {
            proxy.moveProxy(p.getEl().getParentNode(), match ? p.getEl().getDOM() : null);
        } else {
            proxy.moveProxy(this.lastPosC.getEl().getDOM(), null);
        }
        return "x-dd-drop-ok";
    }

    public String notifyEnter(DragSource source, EventObject e, DragData data) {
        JsLibrary.showGwtContainerMask();
        return super.notifyEnter(source, e, data);
    }

    public void notifyOut(DragSource source, EventObject e, DragData data) {
        this.grid = null;
        JsLibrary.hideGwtContainerMask();
        this.notifyEnter(source, e, data);
    }

    public boolean notifyDrop(DragSource source, EventObject e, DragData data) {
        GadgetPortlet gp = portal.getGadgetPortlet(source.getId());
        gp.reloadRenderUrl();
        GadgetPosition dropPosition = portal.getDropPosition();
        GadgetBean bean = gp.getGadgetBean();
        if (dropPosition != null) {
            PortalColumn dragCol = portal.getPortalColumn(bean.getGadgetPosition().getPlaceID());
            PortalColumn dropCol = portal.getPortalColumn(dropPosition.getPlaceID());
            DropZone.saveDropZone(bean, dropPosition, dragCol, dropCol);
        }
        this.grid = null;
        PanelProxy proxy = new PanelProxy(source.getProxy().getJsObj());
        proxy.getProxy().remove();
        if (this.lastPosC != null) {
            if (dropPosition != null) {
                this.lastPosC.remove(gp.getId());
                this.lastPosC.insert(bean.getGadgetPosition().getPosition().intValue(), (Component)gp);
            }
            this.lastPosC.doLayout();
            this.lastPosC = null;
        }
        JsLibrary.hideGwtContainerMask();
        gp.renderDefaultPreferences();
        return true;
    }

    private PosGrid[] getGrid() {
        Component[] items = portal.getItems();
        if (portal.getContainer().getLayout().contains(DEFAULT)) {
            return this.getDefaultGrid(items);
        }
        return this.getComplexGrid(items);
    }

    private PosGrid[] getDefaultGrid(Component[] items) {
        PosGrid[] posGrid = new PosGrid[items.length];
        for (int i = 0; i < items.length; ++i) {
            ExtElement elem = items[i].getEl();
            posGrid[i] = new DefaultPosGrid(elem.getX(), elem.getWidth());
        }
        return posGrid;
    }

    private PosGrid[] getComplexGrid(Component[] items) {
        PosGrid[] posGrid = new PosGrid[items.length];
        for (int i = 0; i < items.length; ++i) {
            ExtElement elem = items[i].getEl();
            posGrid[i] = new ComplexPosGrid(elem.getX(), elem.getWidth(), elem.getY(), elem.getHeight());
        }
        return posGrid;
    }

    private static void saveDropZone(GadgetBean bean, GadgetPosition dropPosition, PortalColumn dragCol, PortalColumn dropCol) {
        bean.setPosition(dropPosition);
        ArrayList<GadgetBean> beans = DropZone.getOrderingAndUpdatingBeans(dragCol, bean);
        beans.addAll(DropZone.getOrderingAndUpdatingBeans(dropCol, bean));
        ContainerEntryPoint.getService().saveGadgetsCollection(beans, ContainerEntryPoint.getGwtParams(), new SaveGadgetAsyncCallback());
    }

    private static ArrayList<GadgetBean> getOrderingAndUpdatingBeans(PortalColumn col, GadgetBean bean) {
        ArrayList<GadgetBean> gadgets = new ArrayList<GadgetBean>();
        NodeList childs = col.getElement().getChildNodes();
        for (int i = 0; i < childs.getLength(); ++i) {
            GadgetPortlet p = portal.getGadgetPortlet(Element.as((Node)childs.getItem(i)).getId());
            if (p == null) continue;
            GadgetBean b = p.getGadgetBean();
            if (!bean.getRef().equals(b.getRef())) {
                b.getGadgetPosition().setPosition(i);
            }
            gadgets.add(b);
        }
        return gadgets;
    }
}

