/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.container.client.view;

import com.google.gwt.core.client.GWT;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.ButtonListenerAdapter;
import com.gwtext.client.widgets.event.WindowListener;
import com.gwtext.client.widgets.event.WindowListenerAdapter;
import com.gwtext.client.widgets.form.FormPanel;
import java.util.List;
import org.nuxeo.opensocial.container.client.ContainerConstants;
import org.nuxeo.opensocial.container.client.ContainerEntryPoint;
import org.nuxeo.opensocial.container.client.ContainerMessages;
import org.nuxeo.opensocial.container.client.JsLibrary;
import org.nuxeo.opensocial.container.client.bean.GadgetBean;
import org.nuxeo.opensocial.container.client.bean.PreferencesBean;
import org.nuxeo.opensocial.container.client.view.GadgetPortlet;
import org.nuxeo.opensocial.container.client.view.InputFactory;
import org.nuxeo.opensocial.container.client.view.SavePreferenceAsyncCallback;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetForm {
    private static final ContainerMessages MESSAGES = (ContainerMessages)GWT.create(ContainerMessages.class);
    private static final ContainerConstants CONSTANTS = (ContainerConstants)GWT.create(ContainerConstants.class);
    private String title;
    private GadgetBean gadget;
    private GadgetPortlet portlet;
    private static final Window window = new Window();

    public GadgetForm(GadgetPortlet portlet) {
        this.portlet = portlet;
        this.gadget = portlet.getGadgetBean();
        this.title = portlet.getTitle();
    }

    public void showForm() {
        FormPanel form = new FormPanel();
        form.setLabelWidth(100);
        form.setPaddings(10);
        form.setWidth("100%");
        form.setFrame(true);
        this.createFields(form);
        this.setTitle(this.title);
        window.clear();
        window.add((Component)form);
        window.setWidth(400);
        window.setModal(true);
        window.show();
        window.syncSize();
        window.addListener((WindowListener)new WindowListenerAdapter(){

            public void onClose(Panel panel) {
                JsLibrary.closeBrowserDoc();
                super.onClose(panel);
            }
        });
    }

    private FormPanel createFields(FormPanel form) {
        this.addFields((Panel)form, this.gadget.getDefaultPrefs());
        Panel p = new Panel("", "");
        p.addClass("form-separator");
        form.add((Component)p);
        this.addFields((Panel)form, this.gadget.getUserPrefs());
        return this.addButtons(form);
    }

    private void addFields(Panel p, List<PreferencesBean> prefs) {
        for (PreferencesBean b : prefs) {
            p.add((Component)InputFactory.getInstance().createField(this.portlet, b));
        }
    }

    private FormPanel addButtons(final FormPanel form) {
        Button save = new Button(CONSTANTS.save());
        save.addListener((ButtonListener)new ButtonListenerAdapter(){

            public void onClick(Button button, EventObject e) {
                GadgetForm.this.savePreferences(form);
            }
        });
        form.addButton(save);
        Button cancel = new Button(CONSTANTS.cancel());
        cancel.addListener((ButtonListener)new ButtonListenerAdapter(){

            public void onClick(Button button, EventObject e) {
                GadgetForm.this.portlet.renderDefaultPreferences();
                window.close();
            }
        });
        form.addButton(cancel);
        return form;
    }

    private void savePreferences(FormPanel form) {
        ContainerEntryPoint.getService().saveGadgetPreferences(this.gadget, form.getForm().getValues(), ContainerEntryPoint.getGwtParams(), new SavePreferenceAsyncCallback(this.gadget));
        JsLibrary.loadingShow();
        window.close();
    }

    public void setTitle(String title) {
        this.title = title;
        window.setTitle(MESSAGES.preferencesGadget(title != null ? title : ""));
    }

    public void setGadget(GadgetBean gadget) {
        this.gadget = gadget;
    }
}

