/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.InputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.common.collections.ScopedMap;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.Null;
import org.nuxeo.ecm.core.CoreService;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.AlreadyConnectedException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocsQueryProvider;
import org.nuxeo.ecm.core.api.DocsQueryProviderFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelFactory;
import org.nuxeo.ecm.core.api.DocumentModelIterator;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentModelsChunk;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.DocumentResolver;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.SerializableInputStream;
import org.nuxeo.ecm.core.api.SimplePrincipal;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.VersionModel;
import org.nuxeo.ecm.core.api.impl.DocsQueryProviderDef;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelIteratorImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.api.impl.VersionModelImpl;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.impl.DocumentPartImpl;
import org.nuxeo.ecm.core.api.operation.Operation;
import org.nuxeo.ecm.core.api.operation.OperationHandler;
import org.nuxeo.ecm.core.api.operation.ProgressMonitor;
import org.nuxeo.ecm.core.api.operation.Status;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.SecurityConstants;
import org.nuxeo.ecm.core.api.security.SecuritySummaryEntry;
import org.nuxeo.ecm.core.api.security.UserEntry;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.api.security.impl.UserEntryImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.event.impl.EventContextImpl;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleService;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.DocumentIterator;
import org.nuxeo.ecm.core.model.DocumentVersionProxy;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;
import org.nuxeo.ecm.core.model.PathComparator;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.query.FilterableQuery;
import org.nuxeo.ecm.core.query.Query;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.query.QueryParseException;
import org.nuxeo.ecm.core.query.QueryResult;
import org.nuxeo.ecm.core.repository.RepositoryInitializationHandler;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.NXSchema;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.core.utils.SIDGenerator;
import org.nuxeo.ecm.core.versioning.DocumentVersion;
import org.nuxeo.ecm.core.versioning.DocumentVersionIterator;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.streaming.InputStreamSource;
import org.nuxeo.runtime.services.streaming.StreamManager;
import org.nuxeo.runtime.services.streaming.StreamSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSession
implements CoreSession,
SecurityConstants,
OperationHandler,
Serializable {
    public static final NuxeoPrincipal ANONYMOUS = new UserPrincipal("anonymous");
    public static final NuxeoPrincipal ADMINISTRATOR = new UserPrincipal("Administrator");
    private static final Log log = LogFactory.getLog(CoreSession.class);
    private static final long serialVersionUID = 6585443198474361876L;
    private static final Comparator<? super Document> pathComparator = new PathComparator();
    protected String repositoryName;
    protected Map<String, Serializable> sessionContext;
    private transient EventService eventService;
    private transient SecurityService securityService;
    protected final DocumentResolver documentResolver = new DocumentResolver();
    private String sessionId;
    protected static final PathRef EMPTY_PATH = new PathRef("");

    protected SecurityService getSecurityService() {
        if (this.securityService == null) {
            this.securityService = NXCore.getSecurityService();
        }
        return this.securityService;
    }

    public abstract Session getSession() throws ClientException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String connect(String repositoryName, Map<String, Serializable> context) throws ClientException {
        if (null == context) {
            context = new HashMap<String, Serializable>();
        }
        if (this.sessionId != null) {
            throw new AlreadyConnectedException();
        }
        this.repositoryName = repositoryName;
        this.sessionContext = context;
        this.sessionId = this.createSessionId();
        this.sessionContext.put("SESSION_ID", (Serializable)((Object)this.sessionId));
        CoreInstance.getInstance().registerSession(this.sessionId, (CoreSession)this);
        Class<AbstractSession> clazz = AbstractSession.class;
        synchronized (AbstractSession.class) {
            RepositoryInitializationHandler handler;
            Session session = this.getSession();
            if (this.sessionContext.remove("REPOSITORY_FIRST_ACCESS") != null && (handler = RepositoryInitializationHandler.getInstance()) != null) {
                Principal ctxPrincipal = (Principal)((Object)this.sessionContext.get("principal"));
                try {
                    this.sessionContext.put("principal", (Serializable)new SimplePrincipal("system"));
                    try {
                        handler.initializeRepository(this);
                        session.save();
                    }
                    catch (ClientException e) {
                        log.error((Object)"Failed to initialize repository content", (Throwable)e);
                    }
                    catch (DocumentException e) {
                        log.error((Object)("Unable to save session after repository init : " + e.getMessage()));
                    }
                }
                finally {
                    this.sessionContext.remove("principal");
                    if (ctxPrincipal != null) {
                        this.sessionContext.put("principal", (Serializable)((Object)ctxPrincipal));
                    }
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.sessionId;
        }
    }

    protected String createSessionId() {
        return this.repositoryName + '-' + SIDGenerator.next();
    }

    public DocumentType getDocumentType(String type) {
        return NXSchema.getSchemaManager().getDocumentType(type);
    }

    public String generateVersionLabelFor(DocumentRef docRef) throws ClientException {
        int max = 0;
        for (VersionModel version : this.getVersionsForDocument(docRef)) {
            try {
                int current = Integer.parseInt(version.getLabel());
                max = current > max ? current : max;
            }
            catch (NumberFormatException e) {}
        }
        return Integer.toString(max + 1);
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Principal getPrincipal() {
        return ANONYMOUS;
    }

    protected final void checkPermission(Document doc, String permission) throws DocumentSecurityException, DocumentException {
        if (this.isAdministrator()) {
            return;
        }
        if (!this.hasPermission(doc, permission)) {
            throw new DocumentSecurityException("Privilege '" + permission + "' is not granted to '" + this.getPrincipal().getName() + "'");
        }
    }

    protected Map<String, Serializable> getContextMapEventInfo(DocumentModel doc) {
        ScopedMap ctxData;
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        if (doc != null && (ctxData = doc.getContextData()) != null) {
            options.putAll(ctxData.getDefaultScopeValues());
            options.putAll(ctxData.getScopeValues(ScopeType.REQUEST));
        }
        return options;
    }

    public DocumentEventContext newEventContext(DocumentModel source) {
        DocumentEventContext ctx = new DocumentEventContext((CoreSession)this, this.getPrincipal(), source);
        ctx.setProperty("repositoryName", (Serializable)((Object)this.repositoryName));
        ctx.setProperty("sessionId", (Serializable)((Object)this.sessionId));
        return ctx;
    }

    public EventService getEventService() {
        if (this.eventService == null) {
            try {
                this.eventService = (EventService)Framework.getLocalService(EventService.class);
            }
            catch (Exception e) {
                throw new Error("Core Event Service not found");
            }
        }
        return this.eventService;
    }

    public void afterBegin() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Transaction started");
        }
        try {
            this.getEventService().transactionStarted();
        }
        catch (Exception e) {
            log.error((Object)"Error while notifying transaction start", (Throwable)e);
        }
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(boolean committed) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Transaction " + (committed ? "committed" : "rolled back")));
        }
        try {
            if (committed) {
                this.getEventService().transactionCommitted();
            } else {
                this.getEventService().transactionRolledback();
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while notifying transaction completion", (Throwable)e);
        }
    }

    public void fireEvent(Event event) throws ClientException {
        this.getEventService().fireEvent(event);
    }

    protected void notifyEvent(String eventId, DocumentModel source, Map<String, Serializable> options, String category, String comment, boolean withLifeCycle, boolean inline) throws ClientException {
        Boolean blockJms;
        DocumentEventContext ctx = new DocumentEventContext((CoreSession)this, this.getPrincipal(), source);
        if (options != null) {
            ctx.setProperties(options);
        }
        ctx.setProperty("repositoryName", (Serializable)((Object)this.repositoryName));
        ctx.setProperty("sessionId", (Serializable)((Object)this.sessionId));
        if (source != null && withLifeCycle) {
            String currentLifeCycleState = null;
            try {
                currentLifeCycleState = source.getCurrentLifeCycleState();
            }
            catch (ClientException err) {
                // empty catch block
            }
            ctx.setProperty("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
        }
        if (comment != null) {
            ctx.setProperty("comment", (Serializable)((Object)comment));
        }
        ctx.setProperty("category", (Serializable)((Object)(category == null ? "eventDocumentCategory" : category)));
        Event event = ctx.newEvent(eventId);
        if ("sessionSaved".equals(eventId)) {
            event.setIsCommitEvent(true);
        }
        if (inline) {
            event.setInline(true);
        }
        if (source != null && (blockJms = (Boolean)source.getContextData("BLOCK_JMS_PRODUCING")) != null && blockJms.booleanValue()) {
            event.setLocal(true);
            event.setInline(true);
        }
        this.fireEvent(event);
    }

    protected void notifyVersionChange(DocumentModel oldDocument, DocumentModel newDocument, Map<String, Serializable> options) throws ClientException {
        HashMap<String, Serializable> info = new HashMap<String, Serializable>();
        if (options != null) {
            info.putAll(options);
        }
        info.put("newDoc", (Serializable)newDocument);
        info.put("oldDoc", (Serializable)oldDocument);
        this.notifyEvent("versioningChangeCoreEvent", newDocument, info, "clientCodeNotificationCategory", null, false, false);
    }

    public boolean hasPermission(DocumentRef docRef, String permission) throws ClientException {
        try {
            Session session = this.getSession();
            Document doc = DocumentResolver.resolveReference(session, docRef);
            return this.hasPermission(doc, permission);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to resolve document ref: " + docRef.toString(), (Throwable)e);
        }
    }

    protected final boolean hasPermission(Document doc, String permission) throws DocumentException {
        return this.getSecurityService().checkPermission(doc, this.getPrincipal(), permission);
    }

    protected final Document resolveReference(DocumentRef docRef) throws DocumentException, ClientException {
        return DocumentResolver.resolveReference(this.getSession(), docRef);
    }

    protected DocumentModel readModel(Document doc, String[] schemas) throws ClientException {
        try {
            return DocumentModelFactory.createDocumentModel(doc, schemas);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to create document model", (Throwable)e);
        }
    }

    protected DocumentModel writeModel(Document doc, DocumentModel docModel) throws DocumentException, ClientException {
        DocumentPart[] parts;
        boolean changed = false;
        for (DocumentPart part : parts = docModel.getParts()) {
            if (!part.isDirty()) continue;
            try {
                doc.writeDocumentPart(part);
            }
            catch (ClientException e) {
                throw e;
            }
            catch (DocumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ClientException("failed to write document part", (Throwable)e);
            }
            changed = true;
        }
        if (changed) {
            doc.setDirty(true);
        }
        DocumentModel newModel = this.readModel(doc, null);
        newModel.copyContextData(docModel);
        return newModel;
    }

    protected void writeDocumentPart(DocumentPart part) {
        part.iterator();
    }

    public DocumentModel copy(DocumentRef src, DocumentRef dst, String name) throws ClientException {
        try {
            Document srcDoc = this.resolveReference(src);
            Document dstDoc = this.resolveReference(dst);
            this.checkPermission(dstDoc, "AddChildren");
            DocumentModel srcDocModel = this.readModel(srcDoc, null);
            this.notifyEvent("aboutToCopy", srcDocModel, null, null, null, true, true);
            Document doc = this.getSession().copy(srcDoc, dstDoc, name);
            if (doc.isLocked()) {
                doc.unlock();
            }
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            DocumentModel docModel = this.readModel(doc, null);
            String comment = srcDoc.getRepository().getName() + ':' + src.toString();
            this.notifyEvent("documentCreatedByCopy", docModel, options, null, comment, true, false);
            docModel = this.writeModel(doc, docModel);
            comment = doc.getRepository().getName() + ':' + docModel.getRef().toString();
            this.notifyEvent("documentDuplicated", srcDocModel, options, null, comment, true, false);
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to copy document: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<DocumentModel> copy(List<DocumentRef> src, DocumentRef dst) throws ClientException {
        ArrayList<DocumentModel> newDocuments = new ArrayList<DocumentModel>();
        for (DocumentRef ref : src) {
            newDocuments.add(this.copy(ref, dst, null));
        }
        return newDocuments;
    }

    public DocumentModel copyProxyAsDocument(DocumentRef src, DocumentRef dst, String name) throws ClientException {
        try {
            Document srcDoc = this.resolveReference(src);
            if (!srcDoc.isProxy()) {
                return this.copy(src, dst, name);
            }
            Document dstDoc = this.resolveReference(dst);
            this.checkPermission(dstDoc, "Write");
            DocumentModel srcDocModel = this.readModel(srcDoc, null);
            String docName = name != null ? name : srcDocModel.getName();
            DocumentModel docModel = this.createDocumentModel(dstDoc.getPath(), docName, srcDocModel.getType());
            docModel.copyContent(srcDocModel);
            this.notifyEvent("aboutToCopy", srcDocModel, null, null, null, true, true);
            docModel = this.createDocument(docModel);
            Document doc = this.resolveReference(docModel.getRef());
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            String comment = srcDoc.getRepository().getName() + ':' + src.toString();
            this.notifyEvent("documentCreatedByCopy", docModel, options, null, comment, true, false);
            comment = doc.getRepository().getName() + ':' + docModel.getRef().toString();
            this.notifyEvent("documentDuplicated", srcDocModel, options, null, comment, true, false);
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to copy document: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<DocumentModel> copyProxyAsDocument(List<DocumentRef> src, DocumentRef dst) throws ClientException {
        ArrayList<DocumentModel> newDocuments = new ArrayList<DocumentModel>();
        for (DocumentRef ref : src) {
            newDocuments.add(this.copyProxyAsDocument(ref, dst, null));
        }
        return newDocuments;
    }

    public DocumentModel move(DocumentRef src, DocumentRef dst, String name) throws ClientException {
        try {
            Document srcDoc = this.resolveReference(src);
            Document dstDoc = this.resolveReference(dst);
            this.checkPermission(dstDoc, "AddChildren");
            this.checkPermission(srcDoc.getParent(), "RemoveChildren");
            this.checkPermission(srcDoc, "Remove");
            DocumentModel srcDocModel = this.readModel(srcDoc, null);
            this.notifyEvent("aboutToMove", srcDocModel, null, null, null, true, true);
            String comment = srcDoc.getRepository().getName() + ':' + srcDoc.getParent().getUUID();
            if (name == null) {
                name = srcDoc.getName();
            }
            name = this.generateDocumentName(dstDoc, name);
            Document doc = this.getSession().move(srcDoc, dstDoc, name);
            DocumentModel docModel = this.readModel(doc, null);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            options.put("parentPath", (Serializable)srcDocModel.getParentRef());
            this.notifyEvent("documentMoved", docModel, options, null, comment, true, false);
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to move document: " + e.getMessage(), (Throwable)e);
        }
    }

    public void move(List<DocumentRef> src, DocumentRef dst) throws ClientException {
        for (DocumentRef ref : src) {
            this.move(ref, dst, null);
        }
    }

    public ACP getACP(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadSecurity");
            return this.getSession().getSecurityManager().getMergedACP(doc);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get acp", (Throwable)e);
        }
    }

    public void setACP(DocumentRef docRef, ACP newAcp, boolean overwrite) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "WriteSecurity");
            DocumentModel docModel = this.readModel(doc, null);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            options.put("oldACP", (Serializable)docModel.getACP().clone());
            options.put("newACP", (Serializable)newAcp.clone());
            this.notifyEvent("beforeDocumentSecurityModification", docModel, options, null, null, true, true);
            this.getSession().getSecurityManager().setACP(doc, newAcp, overwrite);
            docModel = this.readModel(doc, null);
            this.notifyEvent("documentSecurityUpdated", docModel, options, null, null, true, false);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to set acp", (Throwable)e);
        }
    }

    public void cancel() throws ClientException {
        try {
            this.getSession().cancel();
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to cancel session", (Throwable)e);
        }
    }

    private DocumentModel createDocumentModelFromTypeName(String typeName, Map<String, Serializable> options) throws ClientException {
        try {
            DocumentType docType = this.getSession().getTypeManager().getDocumentType(typeName);
            if (docType == null) {
                throw new ClientException(typeName + " is not a registered core type");
            }
            DocumentModelImpl docModel = DocumentModelFactory.createDocumentModel(this.sessionId, docType);
            if (options == null) {
                options = new HashMap<String, Serializable>();
            }
            options.put("BLOCK_JMS_PRODUCING", Boolean.valueOf(true));
            this.notifyEvent("emptyDocumentModelCreated", (DocumentModel)docModel, options, null, null, false, true);
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to create document model", (Throwable)e);
        }
    }

    public DocumentModel createDocumentModel(String typeName) throws ClientException {
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        return this.createDocumentModelFromTypeName(typeName, options);
    }

    public DocumentModel createDocumentModel(String parentPath, String id, String typeName) throws ClientException {
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        options.put("parentPath", (Serializable)((Object)parentPath));
        options.put("documentModelId", (Serializable)((Object)id));
        DocumentModel model = this.createDocumentModelFromTypeName(typeName, options);
        model.setPathInfo(parentPath, id);
        return model;
    }

    public DocumentModel createDocumentModel(String typeName, Map<String, Object> options) throws ClientException {
        HashMap<String, Serializable> serializableOptions = new HashMap<String, Serializable>();
        for (Map.Entry<String, Object> entry : options.entrySet()) {
            serializableOptions.put(entry.getKey(), (Serializable)entry.getValue());
        }
        return this.createDocumentModelFromTypeName(typeName, serializableOptions);
    }

    public DocumentModel createDocument(DocumentModel docModel) throws ClientException {
        String name = docModel.getName();
        String typeName = docModel.getType();
        DocumentRef parentRef = docModel.getParentRef();
        if (typeName == null) {
            throw new ClientException(String.format("cannot create document '%s' with undefined type name", docModel.getTitle()));
        }
        if (parentRef == null) {
            throw new ClientException(String.format("cannot create document '%s' with undefined reference to parent document", docModel.getTitle()));
        }
        try {
            Document folder = this.resolveReference(parentRef);
            this.checkPermission(folder, "AddChildren");
            String initialLifecycleState = null;
            Serializable lifecycleStateinfo = docModel.getContextData("initialLifecycleState");
            if (lifecycleStateinfo instanceof String) {
                initialLifecycleState = (String)((Object)lifecycleStateinfo);
            }
            Map<String, Serializable> options = this.getContextMapEventInfo(docModel);
            this.notifyEvent("aboutToCreate", docModel, options, null, null, false, true);
            name = this.generateDocumentName(folder, name);
            Document doc = folder.addChild(name, typeName);
            LifeCycleService service = NXCore.getLifeCycleService();
            if (service != null) {
                try {
                    service.initialize(doc, initialLifecycleState);
                }
                catch (Exception e) {
                    throw new ClientException("Failed to initialize document lifecycle", (Throwable)e);
                }
            } else {
                log.debug((Object)"No lifecycle service registered");
            }
            docModel = this.writeModel(doc, docModel);
            this.notifyEvent("documentCreated", docModel, options, null, null, true, false);
            docModel = this.writeModel(doc, docModel);
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to create document " + name, (Throwable)e);
        }
    }

    public void importDocuments(List<DocumentModel> docModels) throws ClientException {
        try {
            for (DocumentModel docModel : docModels) {
                this.importDocument(docModel);
            }
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to import documents", (Throwable)e);
        }
    }

    protected void importDocument(DocumentModel docModel) throws DocumentException, ClientException {
        if (!this.isAdministrator()) {
            throw new DocumentSecurityException("Only Administrator can import");
        }
        String name = docModel.getName();
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Invalid empty name");
        }
        String typeName = docModel.getType();
        if (typeName == null || typeName.length() == 0) {
            throw new IllegalArgumentException("Invalid empty type");
        }
        String id = docModel.getId();
        if (id == null || id.length() == 0) {
            throw new IllegalArgumentException("Invalid empty id");
        }
        DocumentRef parentRef = docModel.getParentRef();
        Document parent = parentRef == null || EMPTY_PATH.equals((Object)parentRef) ? null : this.resolveReference(parentRef);
        Map props = docModel.getContextData().getDefaultScopeValues();
        Document doc = this.getSession().importDocument(id, parent, name, typeName, props);
        docModel = typeName.equals("ecm:proxy") ? this.readModel(doc, null) : this.writeModel(doc, docModel);
        this.notifyEvent("documentImported", docModel, null, null, null, true, false);
    }

    public String generateDocumentName(Document parent, String name) throws DocumentException {
        if (name == null || name.length() == 0) {
            name = IdUtils.generateStringId();
        }
        if (parent.hasChild(name)) {
            name = name + '.' + String.valueOf(System.currentTimeMillis());
        }
        return name;
    }

    public DocumentModel[] createDocument(DocumentModel[] docModels) throws ClientException {
        DocumentModel[] models = new DocumentModel[docModels.length];
        int i = 0;
        for (DocumentModel docModel : docModels) {
            models[i++] = this.createDocument(docModel);
        }
        return models;
    }

    public abstract boolean isSessionAlive();

    public void disconnect() throws ClientException {
        if (this.isSessionAlive()) {
            this.getSession().dispose();
        }
        if (this.sessionId != null) {
            CoreInstance.getInstance().unregisterSession(this.sessionId);
        }
        this.sessionContext = null;
        this.sessionId = null;
        this.repositoryName = null;
    }

    public boolean exists(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            return this.hasPermission(doc, "Browse");
        }
        catch (NoSuchDocumentException e) {
            return false;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check existence of " + docRef, (Throwable)e);
        }
    }

    public DocumentModel getChild(DocumentRef parent, String name) throws ClientException {
        try {
            Document doc = this.resolveReference(parent);
            this.checkPermission(doc, "ReadChildren");
            Document child = doc.getChild(name);
            this.checkPermission(child, "Read");
            return this.readModel(child, null);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get child " + name, (Throwable)e);
        }
    }

    public DocumentModelList getChildren(DocumentRef parent) throws ClientException {
        return this.getChildren(parent, null, "Read", null, null);
    }

    public DocumentModelIterator getChildrenIterator(DocumentRef parent) throws ClientException {
        DocsQueryProviderDef def = new DocsQueryProviderDef(DocsQueryProviderDef.DefType.TYPE_CHILDREN);
        def.setParent(parent);
        return new DocumentModelIteratorImpl((CoreSession)this, 15, def, null, "Read", null);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type) throws ClientException {
        return this.getChildren(parent, type, "Read", null, null);
    }

    public DocumentModelIterator getChildrenIterator(DocumentRef parent, String type) throws ClientException {
        DocsQueryProviderDef def = new DocsQueryProviderDef(DocsQueryProviderDef.DefType.TYPE_CHILDREN);
        def.setParent(parent);
        return new DocumentModelIteratorImpl((CoreSession)this, 15, def, type, null, null);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type, String perm) throws ClientException {
        return this.getChildren(parent, type, perm, null, null);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type, Filter filter, Sorter sorter) throws ClientException {
        return this.getChildren(parent, type, null, filter, sorter);
    }

    public DocumentModelList getChildren(DocumentRef parent, String type, String perm, Filter filter, Sorter sorter) throws ClientException {
        try {
            if (perm == null) {
                perm = "Read";
            }
            Document doc = this.resolveReference(parent);
            this.checkPermission(doc, "ReadChildren");
            Iterator<Document> children = doc.getChildren();
            DocumentModelListImpl docs = new DocumentModelListImpl();
            while (children.hasNext()) {
                Document child = children.next();
                if (!this.hasPermission(child, perm) || child.getType() == null || type != null && !type.equals(child.getType().getName())) continue;
                DocumentModel childModel = this.readModel(child, null);
                if (filter != null && !filter.accept(childModel)) continue;
                docs.add((Object)childModel);
            }
            if (sorter != null) {
                Collections.sort(docs, sorter);
            }
            return docs;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get children for " + parent.toString(), (Throwable)e);
        }
    }

    public List<DocumentRef> getChildrenRefs(DocumentRef parentRef, String perm) throws ClientException {
        if (perm != null) {
            throw new ClientException("perm != null not implemented");
        }
        try {
            Document parent = this.resolveReference(parentRef);
            this.checkPermission(parent, "ReadChildren");
            List<String> ids = parent.getChildrenIds();
            ArrayList<DocumentRef> refs = new ArrayList<DocumentRef>(ids.size());
            for (String id : ids) {
                refs.add((DocumentRef)new IdRef(id));
            }
            return refs;
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public DocumentModelsChunk getDocsResultChunk(DocsQueryProviderDef def, String type, String perm, Filter filter, int start, int max) throws ClientException {
        if (max < 0) {
            throw new IllegalArgumentException("invalid count=" + max);
        }
        int count = max;
        DocsQueryProviderFactory dqpFactory = new DocsQueryProviderFactory(this);
        try {
            if (perm == null) {
                perm = "Read";
            }
            DocsQueryProvider dqp = dqpFactory.getDQLbyType(def);
            DocumentIterator children = dqp.getDocs(start);
            DocumentModelListImpl docs = new DocumentModelListImpl();
            int lastIndex = start;
            boolean hasMore = false;
            while (children.hasNext()) {
                ++lastIndex;
                Document child = (Document)children.next();
                if (!dqp.accept(child) || !this.hasPermission(child, perm) || child.getType() == null || type != null && !type.equals(child.getType().getName())) continue;
                DocumentModel childModel = this.readModel(child, null);
                if (filter != null && !filter.accept(childModel)) continue;
                if (count == 0) {
                    hasMore = true;
                    break;
                }
                --count;
                docs.add((Object)childModel);
            }
            long total = children.getSize();
            return new DocumentModelsChunk((DocumentModelList)docs, lastIndex - 1, hasMore, total);
        }
        catch (DocumentException e) {
            if (def.getParent() != null) {
                throw new ClientException("Failed to get children for " + def.getParent().toString(), (Throwable)e);
            }
            throw new ClientException("Failed to get documents for query: " + def.getQuery(), (Throwable)e);
        }
    }

    public DocumentModelIterator getChildrenIterator(DocumentRef parent, String type, String perm, Filter filter) throws ClientException {
        DocsQueryProviderDef def = new DocsQueryProviderDef(DocsQueryProviderDef.DefType.TYPE_CHILDREN);
        def.setParent(parent);
        return new DocumentModelIteratorImpl((CoreSession)this, 15, def, type, perm, filter);
    }

    public DocumentModel getDocument(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Read");
            return this.readModel(doc, null);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get document " + docRef.toString(), (Throwable)e);
        }
    }

    public DocumentModel getDocument(DocumentRef docRef, String[] schemas) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Read");
            return this.readModel(doc, schemas);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get document " + docRef, (Throwable)e);
        }
    }

    public DocumentModelList getDocuments(DocumentRef[] docRefs) throws ClientException {
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>(docRefs.length);
        for (DocumentRef docRef : docRefs) {
            Document doc;
            try {
                doc = this.resolveReference(docRef);
                this.checkPermission(doc, "Read");
            }
            catch (DocumentException e) {
                continue;
            }
            docs.add(this.readModel(doc, null));
        }
        return new DocumentModelListImpl(docs);
    }

    public DocumentModelList getFiles(DocumentRef parent) throws ClientException {
        try {
            Document doc = this.resolveReference(parent);
            this.checkPermission(doc, "ReadChildren");
            Iterator<Document> children = doc.getChildren();
            DocumentModelListImpl docs = new DocumentModelListImpl();
            while (children.hasNext()) {
                Document child = children.next();
                if (child.isFolder() || !this.hasPermission(child, "Read")) continue;
                docs.add((Object)this.readModel(child, null));
            }
            return docs;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get leaf children for " + parent.toString(), (Throwable)e);
        }
    }

    public DocumentModelIterator getFilesIterator(DocumentRef parent) throws ClientException {
        DocsQueryProviderDef def = new DocsQueryProviderDef(DocsQueryProviderDef.DefType.TYPE_CHILDREN_NON_FOLDER);
        def.setParent(parent);
        return new DocumentModelIteratorImpl((CoreSession)this, 15, def, null, null, null);
    }

    public DocumentModelList getFiles(DocumentRef parent, Filter filter, Sorter sorter) throws ClientException {
        try {
            Document doc = this.resolveReference(parent);
            this.checkPermission(doc, "ReadChildren");
            Iterator<Document> children = doc.getChildren();
            DocumentModelListImpl docs = new DocumentModelListImpl();
            while (children.hasNext()) {
                Document child = children.next();
                if (child.isFolder() || !this.hasPermission(child, "Read")) continue;
                DocumentModel docModel = this.readModel(doc, null);
                if (filter != null && !filter.accept(docModel)) continue;
                docs.add((Object)this.readModel(child, null));
            }
            if (sorter != null) {
                Collections.sort(docs, sorter);
            }
            return docs;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get files for " + parent.toString(), (Throwable)e);
        }
    }

    public DocumentModelList getFolders(DocumentRef parent) throws ClientException {
        try {
            Document doc = this.resolveReference(parent);
            this.checkPermission(doc, "ReadChildren");
            Iterator<Document> children = doc.getChildren();
            DocumentModelListImpl docs = new DocumentModelListImpl();
            while (children.hasNext()) {
                Document child = children.next();
                if (!child.isFolder() || !this.hasPermission(child, "Read")) continue;
                docs.add((Object)this.readModel(child, null));
            }
            return docs;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get folders " + parent, (Throwable)e);
        }
    }

    public DocumentModelIterator getFoldersIterator(DocumentRef parent) throws ClientException {
        DocsQueryProviderDef def = new DocsQueryProviderDef(DocsQueryProviderDef.DefType.TYPE_CHILDREN_FOLDERS);
        def.setParent(parent);
        return new DocumentModelIteratorImpl((CoreSession)this, 15, def, null, null, null);
    }

    public DocumentModelList getFolders(DocumentRef parent, Filter filter, Sorter sorter) throws ClientException {
        try {
            Document doc = this.resolveReference(parent);
            this.checkPermission(doc, "ReadChildren");
            Iterator<Document> children = doc.getChildren();
            DocumentModelListImpl docs = new DocumentModelListImpl();
            while (children.hasNext()) {
                Document child = children.next();
                if (!child.isFolder() || !this.hasPermission(child, "Read")) continue;
                DocumentModel docModel = this.readModel(doc, null);
                if (filter != null && !filter.accept(docModel)) continue;
                docs.add((Object)this.readModel(child, null));
            }
            if (sorter != null) {
                Collections.sort(docs, sorter);
            }
            return docs;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get folders " + parent.toString(), (Throwable)e);
        }
    }

    public DocumentModel getParentDocument(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            Document parentDoc = doc.getParent();
            if (parentDoc == null) {
                return null;
            }
            if (!this.hasPermission(parentDoc, "Read")) {
                throw new DocumentSecurityException("Privilege READ is not granted to " + this.getPrincipal().getName());
            }
            return this.readModel(parentDoc, null);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get parent document of " + docRef, (Throwable)e);
        }
    }

    public List<DocumentModel> getParentDocuments(DocumentRef docRef) throws ClientException {
        if (null == docRef) {
            throw new IllegalArgumentException("null docRef");
        }
        ArrayList<DocumentModel> docsList = new ArrayList<DocumentModel>();
        try {
            Document doc = this.resolveReference(docRef);
            String rootPath = this.getSession().getRootDocument().getPath();
            while (!doc.getPath().equals(rootPath) && this.hasPermission(doc, "Read")) {
                docsList.add(this.readModel(doc, null));
                doc = doc.getParent();
            }
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get parent documents: " + docRef, (Throwable)e);
        }
        Collections.reverse(docsList);
        return docsList;
    }

    public DocumentModel getRootDocument() throws ClientException {
        try {
            return this.readModel(this.getSession().getRootDocument(), null);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get the root document", (Throwable)e);
        }
    }

    public boolean hasChildren(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Browse");
            return doc.hasChildren();
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check for children for " + docRef, (Throwable)e);
        }
    }

    public DocumentModelList query(String query) throws ClientException {
        return this.query(query, null, 0L, 0L, false);
    }

    public DocumentModelList query(String query, int max) throws ClientException {
        return this.query(query, null, max, 0L, false);
    }

    public DocumentModelList query(String query, Filter filter) throws ClientException {
        return this.query(query, filter, 0L, 0L, false);
    }

    public DocumentModelList query(String query, Filter filter, int max) throws ClientException {
        return this.query(query, filter, max, 0L, false);
    }

    public DocumentModelList query(String query, Filter filter, long limit, long offset, boolean countTotal) throws ClientException {
        SecurityService securityService = this.getSecurityService();
        Principal principal = this.getPrincipal();
        try {
            QueryResult results;
            boolean postFilter;
            boolean postFilterFilter;
            boolean postFilterPolicies;
            boolean postFilterPermission;
            Query compiledQuery = this.getSession().createQuery(query, Query.Type.NXQL, new String[0]);
            String permission = "Browse";
            if (compiledQuery instanceof FilterableQuery) {
                postFilterPermission = false;
                postFilterPolicies = !securityService.arePoliciesExpressibleInQuery();
                postFilterFilter = filter != null && !(filter instanceof FacetFilter);
                postFilter = postFilterPolicies || postFilterFilter;
                String[] principals = "system".equals(principal.getName()) ? null : SecurityService.getPrincipalsToCheck(principal);
                String[] permissions = securityService.getPermissionsToCheck(permission);
                QueryFilter queryFilter = new QueryFilter(principals, permissions, filter instanceof FacetFilter ? (FacetFilter)filter : null, securityService.getPoliciesQueryTransformers(), postFilter ? 0L : limit, postFilter ? 0L : offset);
                results = ((FilterableQuery)compiledQuery).execute(queryFilter, countTotal && !postFilter);
            } else {
                postFilterPermission = true;
                postFilterPolicies = securityService.arePoliciesRestrictingPermission(permission);
                postFilterFilter = filter != null;
                postFilter = true;
                results = compiledQuery.execute();
            }
            DocumentModelList dms = results.getDocumentModels();
            if (!postFilter) {
                return dms;
            }
            long start = limit == 0L || offset < 0L ? 0L : offset;
            long stop = start + (limit == 0L ? (long)dms.size() : limit);
            int n = 0;
            DocumentModelListImpl docs = new DocumentModelListImpl();
            for (DocumentModel model : dms) {
                if ((postFilterPermission || postFilterPolicies) && !this.hasPermission(model.getRef(), permission) || postFilterFilter && !filter.accept(model)) continue;
                if ((long)n < start) {
                    ++n;
                    continue;
                }
                if ((long)n >= stop) {
                    if (!countTotal) break;
                    ++n;
                    continue;
                }
                ++n;
                docs.add((Object)model);
            }
            if (countTotal) {
                docs.setTotalSize((long)n);
            }
            return docs;
        }
        catch (Exception e) {
            throw new ClientException("Failed to execute query: " + this.tryToExtractMeaningfulErrMsg(e), (Throwable)e);
        }
    }

    public IterableQueryResult queryAndFetch(String query, String queryType, Object ... params) throws ClientException {
        try {
            SecurityService securityService = this.getSecurityService();
            Principal principal = this.getPrincipal();
            String[] principals = "system".equals(principal.getName()) ? null : SecurityService.getPrincipalsToCheck(principal);
            String permission = "Browse";
            String[] permissions = securityService.getPermissionsToCheck(permission);
            QueryFilter queryFilter = new QueryFilter(principals, permissions, null, Collections.emptyList(), 0L, 0L);
            return this.getSession().queryAndFetch(query, queryType, queryFilter, params);
        }
        catch (Exception e) {
            throw new ClientException("Failed to execute query: " + queryType + ": " + query + ": " + this.tryToExtractMeaningfulErrMsg(e), (Throwable)e);
        }
    }

    public DocumentModelIterator queryIt(String query, Filter filter, int max) throws ClientException {
        DocsQueryProviderDef def = new DocsQueryProviderDef(DocsQueryProviderDef.DefType.TYPE_QUERY);
        def.setQuery(query);
        return new DocumentModelIteratorImpl((CoreSession)this, 15, def, null, "Browse", filter);
    }

    private String tryToExtractMeaningfulErrMsg(Throwable t) {
        if (t instanceof QueryParseException) {
            return t.getMessage();
        }
        if (t.getCause() != null) {
            return this.tryToExtractMeaningfulErrMsg(t.getCause());
        }
        return t.getMessage();
    }

    @Deprecated
    public DocumentModelList querySimpleFts(String keywords) throws ClientException {
        return this.querySimpleFts(keywords, null);
    }

    @Deprecated
    public DocumentModelList querySimpleFts(String keywords, Filter filter) throws ClientException {
        try {
            String xpathQ = "//element(*, ecmnt:document)[jcr:contains(.,'*" + keywords + "*')]";
            Query compiledQuery = this.getSession().createQuery(xpathQ, Query.Type.XPATH, new String[0]);
            QueryResult qr = compiledQuery.execute();
            DocumentModelList retrievedDocs = qr.getDocumentModels();
            DocumentModelListImpl docs = new DocumentModelListImpl();
            for (DocumentModel model : retrievedDocs) {
                if (!this.hasPermission(model.getRef(), "Read") || filter != null && !filter.accept(model)) continue;
                docs.add((Object)model);
            }
            return docs;
        }
        catch (Exception e) {
            log.error((Object)"failed to execute query", (Throwable)e);
            throw new ClientException("Failed to get the root document", (Throwable)e);
        }
    }

    @Deprecated
    public DocumentModelIterator querySimpleFtsIt(String query, Filter filter, int pageSize) throws ClientException {
        return this.querySimpleFtsIt(query, null, filter, pageSize);
    }

    @Deprecated
    public DocumentModelIterator querySimpleFtsIt(String query, String startingPath, Filter filter, int pageSize) throws ClientException {
        DocsQueryProviderDef def = new DocsQueryProviderDef(DocsQueryProviderDef.DefType.TYPE_QUERY_FTS);
        def.setQuery(query);
        def.setStartingPath(startingPath);
        return new DocumentModelIteratorImpl((CoreSession)this, pageSize, def, null, "Browse", filter);
    }

    public void removeChildren(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "RemoveChildren");
            Iterator<Document> children = doc.getChildren();
            while (children.hasNext()) {
                Document child = children.next();
                if (!this.hasPermission(child, "Remove")) continue;
                this.removeNotifyOneDoc(child);
            }
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to remove children for " + docRef, (Throwable)e);
        }
    }

    public boolean canRemoveDocument(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            return this.canRemoveDocument(doc);
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected boolean canRemoveDocument(Document doc) throws ClientException, DocumentException {
        if (doc.isVersion()) {
            Document working;
            Collection<Document> proxies = this.getSession().getProxies(doc, null);
            if (!proxies.isEmpty()) {
                return false;
            }
            try {
                working = doc.getSourceDocument();
            }
            catch (DocumentException e) {
                working = null;
            }
            if (working != null) {
                return this.hasPermission(working, "Remove");
            }
            return this.isAdministrator();
        }
        if (!this.hasPermission(doc, "Remove")) {
            return false;
        }
        Document parent = doc.getParent();
        return parent == null || this.hasPermission(parent, "RemoveChildren");
    }

    public void removeDocument(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.removeDocument(doc);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to fetch document " + docRef + " before removal", (Throwable)e);
        }
    }

    protected void removeDocument(Document doc) throws ClientException {
        try {
            if (!this.canRemoveDocument(doc)) {
                throw new DocumentSecurityException("Permission denied: cannot remove document " + doc.getUUID());
            }
            this.removeNotifyOneDoc(doc);
        }
        catch (DocumentException e) {
            try {
                throw new ClientException("Failed to remove document " + doc.getUUID(), (Throwable)e);
            }
            catch (DocumentException e2) {
                log.error((Object)"Failed to remove doc", (Throwable)e);
                throw new ClientException("Failed to remove and even to get UUID " + doc.toString());
            }
        }
    }

    protected void removeNotifyOneDoc(Document doc) throws ClientException, DocumentException {
        DocumentModel docModel = this.readModel(doc, null);
        HashMap<String, Serializable> options = new HashMap<String, Serializable>();
        if (docModel != null) {
            options.put("docTitle", (Serializable)((Object)docModel.getTitle()));
        }
        if (!doc.isVersion()) {
            this.notifyEvent("aboutToRemove", docModel, options, null, null, true, true);
            CoreService coreService = (CoreService)((Object)Framework.getLocalService(CoreService.class));
            coreService.getVersionRemovalPolicy().removeVersions(this.getSession(), doc, this);
        } else {
            this.notifyEvent("aboutToRemoveVersion", docModel, options, null, null, true, true);
        }
        doc.remove();
        if (!doc.isVersion()) {
            this.notifyEvent("documentRemoved", docModel, options, null, null, false, false);
        } else {
            this.notifyEvent("versionRemoved", docModel, options, null, null, false, false);
        }
    }

    public void removeDocuments(DocumentRef[] docRefs) throws ClientException {
        Document[] docs = new Document[docRefs.length];
        for (int i = 0; i < docs.length; ++i) {
            try {
                docs[i] = this.resolveReference(docRefs[i]);
                continue;
            }
            catch (DocumentException e) {
                throw new ClientException("Failed to resolve reference " + docRefs[i], (Throwable)e);
            }
        }
        Arrays.sort(docs, pathComparator);
        String[] paths = new String[docs.length];
        try {
            for (int i = 0; i < docs.length; ++i) {
                paths[i] = docs[i].getPath();
            }
            String latestRemoved = null;
            for (int i = 0; i < docs.length; ++i) {
                if (i != 0 && paths[i].startsWith(latestRemoved + "/")) continue;
                this.removeDocument(docs[i]);
                latestRemoved = paths[i];
            }
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get path of document", (Throwable)e);
        }
    }

    public void save() throws ClientException {
        try {
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            this.getSession().save();
            this.notifyEvent("sessionSaved", null, options, null, null, true, false);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to save session", (Throwable)e);
        }
    }

    public DocumentModel saveDocument(DocumentModel docModel) throws ClientException {
        try {
            if (docModel.getRef() == null) {
                throw new ClientException(String.format("cannot save document '%s' with null reference: document has probably not yet been created in the repository with 'CoreSession.createDocument(docModel)'", docModel.getTitle()));
            }
            Document doc = this.resolveReference(docModel.getRef());
            this.checkPermission(doc, "WriteProperties");
            Map<String, Serializable> options = this.getContextMapEventInfo(docModel);
            ScopedMap ctxData = docModel.getContextData();
            Boolean createSnapshot = (Boolean)ctxData.getScopedValue(ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE");
            DocumentModel oldDoc = null;
            if (Boolean.TRUE.equals(createSnapshot)) {
                oldDoc = this.createDocumentSnapshot(docModel, doc, options, true);
                ctxData.putScopedValue(ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", null);
                if (oldDoc != null) {
                    options.put("DOCUMENT_WAS_SNAPSHOTTED", Boolean.TRUE);
                }
            }
            boolean dirty = doc.isDirty();
            DocumentModel tmpDocModel = this.readModel(doc, null);
            this.notifyEvent("incrementBeforeUpdate", tmpDocModel, options, null, null, true, true);
            this.writeModel(doc, tmpDocModel);
            doc.setDirty(dirty);
            this.notifyEvent("beforeDocumentModification", docModel, options, null, null, true, true);
            docModel = this.writeModel(doc, docModel);
            this.notifyEvent("documentModified", docModel, options, null, null, true, false);
            if (oldDoc != null) {
                this.notifyVersionChange(oldDoc, docModel, options);
            }
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to save document " + docModel, (Throwable)e);
        }
    }

    public boolean isDirty(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            return doc.isDirty();
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get dirty state on " + docRef, (Throwable)e);
        }
    }

    private DocumentModel createDocumentSnapshot(DocumentModel docModel, Document doc, Map<String, Serializable> options, boolean pendingSave) throws ClientException {
        if (!this.isDirty(docModel.getRef())) {
            log.debug((Object)"Document not dirty -> avoid creating a new version");
            return null;
        }
        DocumentRef docRef = docModel.getRef();
        VersionModelImpl newVersion = new VersionModelImpl();
        String vlabel = this.generateVersionLabelFor(docRef);
        newVersion.setLabel(vlabel);
        this.checkIn(docRef, (VersionModel)newVersion);
        log.debug((Object)("doc checked in " + docModel.getTitle()));
        this.checkOut(docModel, doc, options, pendingSave);
        log.debug((Object)("doc checked out " + docModel.getTitle()));
        return this.getDocumentWithVersion(docRef, (VersionModel)newVersion);
    }

    public void saveDocuments(DocumentModel[] docModels) throws ClientException {
        for (DocumentModel docModel : docModels) {
            this.saveDocument(docModel);
        }
    }

    public DocumentModel getSourceDocument(DocumentRef docRef) throws ClientException {
        assert (null != docRef);
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Version");
            Document headDocument = doc.getSourceDocument();
            if (headDocument == null) {
                throw new DocumentException("Source document has been deleted");
            }
            return this.readModel(headDocument, null);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get head document for " + docRef, (Throwable)e);
        }
    }

    public VersionModel getLastVersion(DocumentRef docRef) throws ClientException {
        assert (null != docRef);
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Version");
            DocumentVersion version = doc.getLastVersion();
            VersionModelImpl versionModel = new VersionModelImpl();
            versionModel.setCreated(version.getCreated());
            versionModel.setDescription(version.getDescription());
            versionModel.setLabel(version.getLabel());
            return versionModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get versions for " + docRef, (Throwable)e);
        }
    }

    public DocumentModel getLastDocumentVersion(DocumentRef docRef) throws ClientException {
        assert (null != docRef);
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Version");
            DocumentVersion version = doc.getLastVersion();
            if (version != null) {
                return this.readModel(version, null);
            }
            return null;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get versions for " + docRef, (Throwable)e);
        }
    }

    public List<DocumentRef> getVersionsRefs(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Version");
            List<String> ids = doc.getVersionsIds();
            ArrayList<DocumentRef> refs = new ArrayList<DocumentRef>(ids.size());
            for (String id : ids) {
                refs.add((DocumentRef)new IdRef(id));
            }
            return refs;
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public List<DocumentModel> getVersions(DocumentRef docRef) throws ClientException {
        assert (null != docRef);
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Version");
            ArrayList<DocumentModel> versions = new ArrayList<DocumentModel>();
            DocumentVersionIterator versionIterator = doc.getVersions();
            while (versionIterator.hasNext()) {
                DocumentVersion docVersion = versionIterator.nextDocumentVersion();
                if (docVersion.getLabel() == null) continue;
                if (docVersion.getType() == null) {
                    throw new IllegalStateException("FAILED TO GET VERSIONS FOR" + docRef + " with path: " + doc.getPath());
                }
                DocumentModel versionModel = this.readModel(docVersion, null);
                versions.add(versionModel);
            }
            log.debug((Object)("Retrieved the versions of the document " + doc.getPath()));
            return versions;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get versions for " + docRef, (Throwable)e);
        }
    }

    public List<VersionModel> getVersionsForDocument(DocumentRef docRef) throws ClientException {
        assert (null != docRef);
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Version");
            ArrayList<VersionModel> versions = new ArrayList<VersionModel>();
            DocumentVersionIterator versionIterator = doc.getVersions();
            while (versionIterator.hasNext()) {
                DocumentVersion docVersion = versionIterator.nextDocumentVersion();
                if (null == docVersion.getLabel()) continue;
                VersionModelImpl versionModel = new VersionModelImpl();
                versionModel.setCreated(docVersion.getCreated());
                versionModel.setDescription(docVersion.getDescription());
                versionModel.setLabel(docVersion.getLabel());
                versions.add((VersionModel)versionModel);
            }
            log.debug((Object)("Retrieved the versions of the document " + doc.getPath()));
            return versions;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get versions for " + docRef, (Throwable)e);
        }
    }

    public DocumentModel restoreToVersion(DocumentRef docRef, VersionModel version) throws ClientException {
        return this.restoreToVersion(docRef, version, false);
    }

    public DocumentModel restoreToVersion(DocumentRef docRef, VersionModel version, boolean skipSnapshotCreation) throws ClientException {
        assert (docRef != null);
        assert (version != null);
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "WriteProperties");
            this.checkPermission(doc, "Version");
            DocumentModel docModel = this.readModel(doc, null);
            if (!skipSnapshotCreation) {
                this.createDocumentSnapshot(docModel, doc, null, false);
            }
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            Long majorVer = doc.getLong("major_version");
            Long minorVer = doc.getLong("minor_version");
            if (majorVer != null || minorVer != null) {
                options.put("CURRENT_DOCUMENT_MAJOR_VERSION", majorVer);
                options.put("CURRENT_DOCUMENT_MINOR_VERSION", minorVer);
            }
            Document docVersion = doc.getVersion(version.getLabel());
            String versionUUID = docVersion.getUUID();
            options.put("RESTORED_VERSION_UUID", (Serializable)((Object)versionUUID));
            this.notifyEvent("beforeRestoringDocument", docModel, options, null, null, true, true);
            this.writeModel(doc, docModel);
            doc.restore(version.getLabel());
            doc.checkOut();
            docModel = this.readModel(doc, null);
            this.notifyEvent("documentRestored", docModel, options, null, null, true, false);
            docModel = this.writeModel(doc, docModel);
            log.debug((Object)("Document restored to version:" + version.getLabel()));
            return docModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to restore document " + docRef, (Throwable)e);
        }
    }

    public void checkIn(DocumentRef docRef, VersionModel version) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "WriteProperties");
            DocumentModel docModel = this.readModel(doc, null);
            this.notifyEvent("aboutToCheckIn", docModel, null, null, null, true, true);
            this.writeModel(doc, docModel);
            String description = version.getDescription();
            if (description != null) {
                doc.checkIn(version.getLabel(), description);
            } else {
                doc.checkIn(version.getLabel());
            }
            Document versionDocument = doc.getVersion(version.getLabel());
            DocumentModel versionModel = this.readModel(versionDocument, null);
            Map<String, Serializable> options = this.getContextMapEventInfo(docModel);
            this.notifyEvent("documentCreated", versionModel, options, null, null, true, false);
            if (doc.getType().hasSchema("uid")) {
                Long majorVer = doc.getLong("major_version");
                Long minorVer = doc.getLong("minor_version");
                String versionComment = majorVer + "." + minorVer;
                options.put("comment", (Serializable)((Object)versionComment));
            }
            this.notifyEvent("documentCheckedIn", docModel, options, null, null, true, false);
            this.writeModel(versionDocument, versionModel);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check in document " + docRef, (Throwable)e);
        }
    }

    public void checkOut(DocumentRef docRef) throws ClientException {
        Document doc;
        try {
            doc = this.resolveReference(docRef);
            this.checkPermission(doc, "WriteProperties");
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check out document " + docRef, (Throwable)e);
        }
        this.checkOut(this.readModel(doc, null), doc, null, false);
    }

    protected void checkOut(DocumentModel docModel, Document doc, Map<String, Serializable> options, boolean pendingSave) throws ClientException {
        try {
            if (doc == null) {
                doc = this.resolveReference(docModel.getRef());
            }
            this.notifyEvent("aboutToCheckout", docModel, options, null, null, true, true);
            doc.checkOut();
            DocumentModel eventDocModel = pendingSave ? this.readModel(doc, null) : docModel;
            this.notifyEvent("documentCheckedOut", eventDocModel, options, null, null, true, false);
            this.writeModel(doc, eventDocModel);
            doc.setDirty(false);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check out document " + docModel.getRef(), (Throwable)e);
        }
    }

    public boolean isCheckedOut(DocumentRef docRef) throws ClientException {
        assert (null != docRef);
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Browse");
            return doc.isCheckedOut();
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check out document " + docRef, (Throwable)e);
        }
    }

    public DocumentModel getVersion(String versionableId, VersionModel versionModel) throws ClientException {
        if (!this.isAdministrator()) {
            throw new DocumentSecurityException("Only Administrator can fetch versions directly");
        }
        String label = versionModel.getLabel();
        try {
            Document doc = this.getSession().getVersion(versionableId, versionModel);
            return doc == null ? null : this.readModel(doc, null);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get version " + label + " for " + versionableId, (Throwable)e);
        }
    }

    public DocumentModel getDocumentWithVersion(DocumentRef docRef, VersionModel version) throws ClientException {
        assert (docRef != null);
        assert (version != null);
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Read");
            String docPath = doc.getPath();
            doc = doc.getVersion(version.getLabel());
            if (doc == null) {
                log.debug((Object)("Version " + version.getLabel() + " does not exist for " + docPath));
                return null;
            }
            log.debug((Object)("Retrieved the version " + version.getLabel() + " of the document " + docPath));
            return this.readModel(doc, null);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get version for " + docRef, (Throwable)e);
        }
    }

    public DocumentModel createProxy(DocumentRef parentRef, DocumentRef docRef, VersionModel version, boolean overwriteExistingProxy) throws ClientException {
        assert (null != parentRef);
        assert (null != docRef);
        assert (null != version);
        try {
            Document doc = this.resolveReference(docRef);
            Document section = this.resolveReference(parentRef);
            this.checkPermission(doc, "Read");
            this.checkPermission(section, "AddChildren");
            DocumentModel proxyModel = null;
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            if (overwriteExistingProxy) {
                proxyModel = this.updateExistingProxies(doc, section, version);
                if (proxyModel != null) {
                    this.notifyEvent("documentProxyUpdated", proxyModel, options, null, null, true, false);
                } else {
                    List<Object> removedProxyIds = Collections.emptyList();
                    removedProxyIds = this.removeExistingProxies(doc, section);
                    options.put("replacedProxyRefs", (Serializable)((Object)removedProxyIds));
                }
            }
            if (proxyModel == null) {
                String vlabel = version.getLabel();
                Document proxy = this.getSession().createProxyForVersion(section, doc, vlabel);
                log.debug((Object)("Created proxy for version " + vlabel + " of the document " + doc.getPath()));
                proxyModel = this.readModel(proxy, null);
                this.notifyEvent("documentCreated", proxyModel, options, null, null, true, false);
            }
            this.notifyEvent("documentProxyPublished", proxyModel, options, null, null, true, false);
            DocumentModel sectionModel = this.readModel(section, null);
            this.notifyEvent("sectionContentPublished", sectionModel, options, null, null, true, false);
            return proxyModel;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to create proxy for doc " + docRef + " , version: " + version.getLabel(), (Throwable)e);
        }
    }

    protected List<String> removeExistingProxies(Document doc, Document folder) throws DocumentException, ClientException {
        Collection<Document> otherProxies = this.getSession().getProxies(doc, folder);
        ArrayList<String> removedProxyIds = new ArrayList<String>(otherProxies.size());
        for (Document otherProxy : otherProxies) {
            removedProxyIds.add(otherProxy.getUUID());
            this.removeNotifyOneDoc(otherProxy);
        }
        return removedProxyIds;
    }

    protected DocumentModel updateExistingProxies(Document doc, Document folder, VersionModel version) throws DocumentException, ClientException {
        Collection<Document> proxies = this.getSession().getProxies(doc, folder);
        try {
            if (proxies.size() == 1) {
                for (Document proxy : proxies) {
                    if (!(proxy instanceof DocumentVersionProxy)) continue;
                    ((DocumentVersionProxy)proxy).setTargetDocument(doc, version.getLabel());
                    return this.readModel(proxy, null);
                }
            }
        }
        catch (UnsupportedOperationException e) {
            log.error((Object)"Cannot update proxy, try to remove");
        }
        return null;
    }

    public DocumentModelList getProxies(DocumentRef docRef, DocumentRef folderRef) throws ClientException {
        try {
            Document folder = null;
            if (folderRef != null) {
                folder = this.resolveReference(folderRef);
                this.checkPermission(folder, "ReadChildren");
            }
            Document doc = this.resolveReference(docRef);
            Collection<Document> children = this.getSession().getProxies(doc, folder);
            DocumentModelListImpl docs = new DocumentModelListImpl();
            for (Document child : children) {
                if (!this.hasPermission(child, "Read")) continue;
                docs.add((Object)this.readModel(child, null));
            }
            return docs;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get children for " + folderRef, (Throwable)e);
        }
    }

    public String[] getProxyVersions(DocumentRef docRef, DocumentRef folderRef) throws ClientException {
        try {
            Document folder = this.resolveReference(folderRef);
            Document doc = this.resolveReference(docRef);
            this.checkPermission(folder, "ReadChildren");
            Collection<Document> children = this.getSession().getProxies(doc, folder);
            if (children.isEmpty()) {
                return null;
            }
            ArrayList<String> versions = new ArrayList<String>();
            for (Document child : children) {
                if (!this.hasPermission(child, "Read")) continue;
                versions.add(((DocumentVersionProxy)child).getTargetVersion().getLabel());
            }
            return versions.toArray(new String[versions.size()]);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get children for " + folderRef.toString(), (Throwable)e);
        }
    }

    public List<String> getAvailableSecurityPermissions() throws ClientException {
        return Arrays.asList(this.getSecurityService().getPermissionProvider().getPermissions());
    }

    public DataModel getDataModel(DocumentRef docRef, String schema) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Read");
            Schema docSchema = doc.getType().getSchema(schema);
            assert (docSchema != null);
            return DocumentModelFactory.exportSchema(doc.getSession().getUserSessionId(), docRef, doc, docSchema);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get data model for " + docRef + ':' + schema, (Throwable)e);
        }
    }

    public Object getDataModelField(DocumentRef docRef, String schema, String field) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            if (doc != null) {
                this.checkPermission(doc, "Read");
                Schema docSchema = doc.getType().getSchema(schema);
                if (docSchema != null) {
                    String prefix = docSchema.getNamespace().prefix;
                    if (prefix != null && prefix.length() > 0) {
                        field = prefix + ':' + field;
                    }
                    return doc.getPropertyValue(field);
                }
                log.warn((Object)("Cannot find schema with name=" + schema));
            } else {
                log.warn((Object)("Cannot resolve docRef=" + docRef));
            }
            return null;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get data model field " + schema + ':' + field, (Throwable)e);
        }
    }

    public Object[] getDataModelFields(DocumentRef docRef, String schema, String[] fields) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Read");
            Schema docSchema = doc.getType().getSchema(schema);
            String prefix = docSchema.getNamespace().prefix;
            if (prefix != null && prefix.length() > 0) {
                prefix = prefix + ':';
            }
            Object[] values = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                if (prefix == null) continue;
                values[i] = doc.getPropertyValue(fields[i]);
            }
            return values;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to check out document " + docRef, (Throwable)e);
        }
    }

    public SerializableInputStream getContentData(String key) throws ClientException {
        try {
            InputStream in = this.getSession().getDataStream(key);
            return new SerializableInputStream(in);
        }
        catch (Exception e) {
            throw new ClientException("Failed to get data stream for " + key, (Throwable)e);
        }
    }

    public String getStreamURI(String blobPropertyId) throws ClientException {
        String uri;
        try {
            SerializableInputStream in = this.getContentData(blobPropertyId);
            StreamManager sm = (StreamManager)Framework.getLocalService(StreamManager.class);
            if (sm == null) {
                throw new ClientException("No Streaming Service was registered");
            }
            uri = sm.addStream((StreamSource)new InputStreamSource((InputStream)in));
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException("Failed to register blob stream: " + blobPropertyId, (Throwable)e);
        }
        return uri;
    }

    public String getCurrentLifeCycleState(DocumentRef docRef) throws ClientException {
        String currentLifeCycleState;
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadLifeCycle");
            currentLifeCycleState = doc.getCurrentLifeCycleState();
        }
        catch (LifeCycleException e) {
            ClientException ce = new ClientException("Failed to get life cycle " + docRef, (Throwable)e);
            ce.fillInStackTrace();
            throw ce;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get content data " + docRef, (Throwable)e);
        }
        return currentLifeCycleState;
    }

    public String getLifeCyclePolicy(DocumentRef docRef) throws ClientException {
        String lifecyclePolicy;
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadLifeCycle");
            lifecyclePolicy = doc.getLifeCyclePolicy();
        }
        catch (LifeCycleException e) {
            ClientException ce = new ClientException("Failed to get life cycle policy" + docRef, (Throwable)e);
            ce.fillInStackTrace();
            throw ce;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get content data " + docRef, (Throwable)e);
        }
        return lifecyclePolicy;
    }

    public boolean followTransition(DocumentRef docRef, String transition) throws ClientException {
        boolean operationResult;
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "WriteLifeCycle");
            String formerStateName = doc.getCurrentLifeCycleState();
            operationResult = doc.followTransition(transition);
            if (operationResult) {
                HashMap<String, Serializable> options = new HashMap<String, Serializable>();
                options.put("from", (Serializable)((Object)formerStateName));
                options.put("to", (Serializable)((Object)doc.getCurrentLifeCycleState()));
                options.put("transition", (Serializable)((Object)transition));
                DocumentModel docModel = this.readModel(doc, null);
                this.notifyEvent("lifecycle_transition_event", docModel, options, "eventLifeCycleCategory", null, true, false);
            }
        }
        catch (LifeCycleException e) {
            ClientException ce = new ClientException("Unable to follow transition <" + transition + "> for document : " + docRef, (Throwable)e);
            ce.fillInStackTrace();
            throw ce;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get content data " + docRef, (Throwable)e);
        }
        return operationResult;
    }

    public Collection<String> getAllowedStateTransitions(DocumentRef docRef) throws ClientException {
        Collection<String> allowedStateTransitions;
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "ReadLifeCycle");
            allowedStateTransitions = doc.getAllowedStateTransitions();
        }
        catch (LifeCycleException e) {
            ClientException ce = new ClientException("Unable to get allowed state transitions for document : " + docRef, (Throwable)e);
            ce.fillInStackTrace();
            throw ce;
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get content data " + docRef, (Throwable)e);
        }
        return allowedStateTransitions;
    }

    public Object[] getDataModelsField(DocumentRef[] docRefs, String schema, String field) throws ClientException {
        assert (docRefs != null);
        assert (schema != null);
        assert (field != null);
        Object[] values = new Object[docRefs.length];
        int i = 0;
        for (DocumentRef docRef : docRefs) {
            Object value = this.getDataModelField(docRef, schema, field);
            values[i++] = value;
        }
        return values;
    }

    public DocumentRef[] getParentDocumentRefs(DocumentRef docRef) throws ClientException {
        ArrayList<IdRef> docRefs = new ArrayList<IdRef>();
        try {
            Document doc = this.resolveReference(docRef);
            for (Document parentDoc = doc.getParent(); parentDoc != null; parentDoc = parentDoc.getParent()) {
                IdRef parentDocRef = new IdRef(parentDoc.getUUID());
                docRefs.add(parentDocRef);
            }
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get all parent documents: " + docRef, (Throwable)e);
        }
        DocumentRef[] refs = new DocumentRef[docRefs.size()];
        return docRefs.toArray(refs);
    }

    public Object[] getDataModelsFieldUp(DocumentRef docRef, String schema, String field) throws ClientException {
        DocumentRef[] parentRefs = this.getParentDocumentRefs(docRef);
        DocumentRef[] allRefs = new DocumentRef[parentRefs.length + 1];
        allRefs[0] = docRef;
        System.arraycopy(parentRefs, 0, allRefs, 1, parentRefs.length);
        return this.getDataModelsField(allRefs, schema, field);
    }

    public String getLock(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "Read");
            return doc.getLock();
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get lock info on " + docRef, (Throwable)e);
        }
    }

    public void setLock(DocumentRef docRef, String key) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            this.checkPermission(doc, "WriteProperties");
            doc.setLock(key);
            DocumentModel docModel = this.readModel(doc, null);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            this.notifyEvent("documentLocked", docModel, options, null, null, true, false);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to set lock on " + docRef, (Throwable)e);
        }
    }

    public String unlock(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            if (!doc.isLocked()) {
                return null;
            }
            String[] lockDetails = doc.getLock().split(":");
            if (lockDetails == null) {
                return null;
            }
            String username = this.getPrincipal().getName();
            if (this.hasPermission(docRef, "Unlock") || lockDetails[0].equals(username)) {
                String lockKey = doc.unlock();
                DocumentModel docModel = this.readModel(doc, null);
                HashMap<String, Serializable> options = new HashMap<String, Serializable>();
                this.notifyEvent("documentUnlocked", docModel, options, null, null, true, false);
                return lockKey;
            }
            throw new ClientException("The caller has no privileges to unlock the document");
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to set lock on " + docRef, (Throwable)e);
        }
    }

    protected boolean isAdministrator() {
        Principal principal = this.getPrincipal();
        if ("Administrator".equals(principal.getName())) {
            return true;
        }
        if ("system".equals(principal.getName())) {
            return true;
        }
        if (principal instanceof NuxeoPrincipal) {
            return ((NuxeoPrincipal)principal).isAdministrator();
        }
        return false;
    }

    public void applyDefaultPermissions(String userOrGroupName) throws ClientException {
        if (null == userOrGroupName) {
            throw new ClientException("Null parameters received.");
        }
        if (!this.isAdministrator()) {
            throw new DocumentSecurityException("You need to be an Administrator to do this.");
        }
        DocumentModel rootDocument = this.getRootDocument();
        ACPImpl acp = new ACPImpl();
        UserEntryImpl userEntry = new UserEntryImpl(userOrGroupName);
        userEntry.addPrivilege("Read", true, false);
        acp.setRules(new UserEntry[]{userEntry});
        this.setACP(rootDocument.getRef(), (ACP)acp, false);
    }

    public void destroy() {
        log.debug((Object)"Destroying core session ...");
        try {
            this.disconnect();
        }
        catch (Exception e) {
            log.error((Object)"Failed to destroy core session", (Throwable)e);
        }
    }

    public DocumentModel publishDocument(DocumentModel docToPublish, DocumentModel section) throws ClientException {
        return this.publishDocument(docToPublish, section, true);
    }

    public DocumentModel publishDocument(DocumentModel docToPublish, DocumentModel section, boolean overwriteExistingProxy) throws ClientException {
        DocumentRef docRef = docToPublish.getRef();
        DocumentRef sectionRef = section.getRef();
        if (docToPublish.isProxy()) {
            try {
                Document doc = this.resolveReference(docRef);
                Document sec = this.resolveReference(sectionRef);
                this.checkPermission(doc, "Read");
                this.checkPermission(sec, "AddChildren");
                List<Object> removedProxyIds = Collections.emptyList();
                if (overwriteExistingProxy) {
                    removedProxyIds = this.removeExistingProxies(doc, sec);
                }
                DocumentModel newDocument = this.copy(docRef, sectionRef, docToPublish.getName());
                HashMap<String, Serializable> options = new HashMap<String, Serializable>();
                options.put("replacedProxyRefs", (Serializable)((Object)removedProxyIds));
                this.notifyEvent("documentProxyPublished", newDocument, options, null, null, true, false);
                this.notifyEvent("sectionContentPublished", section, options, null, null, true, false);
                return newDocument;
            }
            catch (DocumentException e) {
                throw new ClientException((Throwable)e);
            }
        }
        this.createDocumentSnapshot(docToPublish, null, null, false);
        VersionModel version = this.getLastVersion(docRef);
        DocumentModel newProxy = this.createProxy(sectionRef, docRef, version, overwriteExistingProxy);
        return newProxy;
    }

    public VersionModel isPublished(DocumentModel document, DocumentModel section) {
        return null;
    }

    public String getSuperParentType(DocumentModel doc) throws ClientException {
        DocumentModel superSpace = this.getSuperSpace(doc);
        if (superSpace == null) {
            return null;
        }
        return superSpace.getType();
    }

    public DocumentModel getSuperSpace(DocumentModel doc) throws ClientException {
        if (doc == null) {
            throw new ClientException("getSuperSpace: document is null");
        }
        if (doc.hasFacet("SuperSpace")) {
            return doc;
        }
        DocumentModel parent = this.getDirectAccessibleParent(doc.getRef());
        if (parent == null || "/".equals(parent.getPathAsString())) {
            return this.getRootDocument();
        }
        return this.getSuperSpace(parent);
    }

    private DocumentModel getDirectAccessibleParent(DocumentRef docRef) throws ClientException {
        try {
            Document doc = this.resolveReference(docRef);
            Document parentDoc = doc.getParent();
            if (parentDoc == null) {
                return this.readModel(doc, null);
            }
            if (!this.hasPermission(parentDoc, "Read")) {
                String parentPath = parentDoc.getPath();
                if ("/".equals(parentPath)) {
                    return this.getRootDocument();
                }
                return this.getDirectAccessibleParent((DocumentRef)new PathRef(parentDoc.getPath()));
            }
            return this.readModel(parentDoc, null);
        }
        catch (DocumentException e) {
            throw new ClientException((Throwable)e);
        }
    }

    public List<SecuritySummaryEntry> getSecuritySummary(DocumentModel docModel, Boolean includeParents) throws ClientException {
        Document doc;
        if (docModel == null) {
            docModel = this.getRootDocument();
        }
        try {
            doc = this.resolveReference(docModel.getRef());
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get document " + docModel.getRef().toString(), (Throwable)e);
        }
        this.getSecurityService();
        return SecurityService.getSecuritySummary(doc, includeParents);
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public <T extends Serializable> T getDocumentSystemProp(DocumentRef ref, String systemProperty, Class<T> type) throws ClientException, DocumentException {
        Document doc;
        try {
            doc = this.resolveReference(ref);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get document " + ref, (Throwable)e);
        }
        return doc.getSystemProp(systemProperty, type);
    }

    public <T extends Serializable> void setDocumentSystemProp(DocumentRef ref, String systemProperty, T value) throws ClientException, DocumentException {
        Document doc;
        try {
            doc = this.resolveReference(ref);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to get document " + ref, (Throwable)e);
        }
        doc.setSystemProp(systemProperty, value);
    }

    public void orderBefore(DocumentRef parent, String src, String dest) throws ClientException {
        try {
            if (src == null || src.equals(dest)) {
                return;
            }
            Document doc = this.resolveReference(parent);
            doc.orderBefore(src, dest);
            HashMap<String, Serializable> options = new HashMap<String, Serializable>();
            DocumentModel docModel = this.readModel(doc, null);
            String comment = src;
            options.put("reorderedChild", (Serializable)((Object)src));
            this.notifyEvent("childrenOrderChanged", docModel, options, null, comment, true, false);
        }
        catch (DocumentException e) {
            throw new ClientException("Failed to resolve documents: " + src + ", " + dest, (Throwable)e);
        }
    }

    public <T> T run(Operation<T> op) throws ClientException {
        return this.run(op, null);
    }

    public <T> T run(Operation<T> op, ProgressMonitor monitor) throws ClientException {
        Object result = op.run((CoreSession)this, (OperationHandler)this, monitor);
        Status status = op.getStatus();
        if (status.isOk()) {
            return (T)result;
        }
        Throwable t = status.getException();
        if (t != null) {
            if (t instanceof ClientException) {
                throw (ClientException)t;
            }
            throw new ClientException(status.getMessage(), t);
        }
        String msg = status.getMessage();
        if (msg == null) {
            msg = "Unknown Error";
        }
        throw new ClientException(msg);
    }

    public void startOperation(Operation<?> operation) {
        EventContextImpl ctx = new EventContextImpl((CoreSession)this, this.getPrincipal(), new Object[]{operation});
        Event event = ctx.newEvent("!OPERATION_START!");
        try {
            this.fireEvent(event);
        }
        catch (ClientException e) {
            log.error((Object)("Failed to notify operation start for: " + operation), (Throwable)e);
        }
    }

    public void endOperation(Operation<?> operation) {
        EventContextImpl ctx = new EventContextImpl((CoreSession)this, this.getPrincipal(), new Object[]{operation});
        Event event = ctx.newEvent("!OPERATION_END!");
        try {
            this.fireEvent(event);
        }
        catch (ClientException e) {
            log.error((Object)("Failed to notify operation end for: " + operation), (Throwable)e);
        }
    }

    public Object[] refreshDocument(DocumentRef ref, int refreshFlags, String[] schemas) throws ClientException {
        Object[] result = new Object[6];
        try {
            Document doc = this.resolveReference(ref);
            if (doc == null) {
                throw new ClientException("No Such Document: " + ref);
            }
            boolean readPermChecked = false;
            if ((refreshFlags & 4) != 0) {
                PrefetchInfo info;
                if (!readPermChecked) {
                    this.checkPermission(doc, "Read");
                    readPermChecked = true;
                }
                if ((info = doc.getType().getPrefetchInfo()) != null) {
                    Field[] fields;
                    Schema[] pschemas = info.getSchemas();
                    if (pschemas != null) {
                        // empty if block
                    }
                    if ((fields = info.getFields()) != null) {
                        HashMap<String, Null> prefetch = new HashMap<String, Null>();
                        for (Field field : fields) {
                            Object value = doc.getPropertyValue(field.getName().getPrefixedName());
                            prefetch.put(field.getDeclaringType().getName() + '.' + field.getName().getLocalName(), (Null)(value == null ? Null.VALUE : (Serializable)value));
                        }
                        result[0] = prefetch;
                    }
                }
            }
            if ((refreshFlags & 1) != 0) {
                if (!readPermChecked) {
                    this.checkPermission(doc, "Read");
                    readPermChecked = true;
                }
                result[1] = doc.getLock();
            }
            if ((refreshFlags & 2) != 0) {
                this.checkPermission(doc, "ReadLifeCycle");
                result[2] = doc.getCurrentLifeCycleState();
                result[3] = doc.getLifeCyclePolicy();
            }
            if ((refreshFlags & 0x20) != 0) {
                this.checkPermission(doc, "ReadSecurity");
                result[4] = this.getSession().getSecurityManager().getMergedACP(doc);
            }
            if ((refreshFlags & 0x100) != 0) {
                if (!readPermChecked) {
                    this.checkPermission(doc, "Read");
                    readPermChecked = true;
                }
                if (schemas == null) {
                    schemas = doc.getType().getSchemaNames();
                }
                DocumentType type = doc.getType();
                DocumentPart[] parts = new DocumentPart[schemas.length];
                for (int i = 0; i < schemas.length; ++i) {
                    DocumentPartImpl part = new DocumentPartImpl(type.getSchema(schemas[i]));
                    doc.readDocumentPart((DocumentPart)part);
                    parts[i] = part;
                }
                result[5] = parts;
            }
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException("Failed to get refresh data", (Throwable)e);
        }
        return result;
    }

    public String[] getPermissionsToCheck(String permission) {
        return this.getSecurityService().getPermissionsToCheck(permission);
    }
}

