/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api;

import java.io.Serializable;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.core.api.model.impl.DocumentPartImpl;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.NoSuchPropertyException;
import org.nuxeo.ecm.core.model.Property;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.versioning.DocumentVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentModelFactory {
    private static final Log log = LogFactory.getLog(DocumentModelFactory.class);
    private static final SecureRandom random = new SecureRandom();

    private DocumentModelFactory() {
    }

    public static DocumentModel newDocument(DocumentModel parent, String type) {
        DocumentType docType = parent.getCoreSession().getDocumentType(type);
        return DocumentModelFactory.newDocument(parent, docType);
    }

    public static DocumentModel newDocument(DocumentModel parent, String name, String type) {
        DocumentType docType = parent.getCoreSession().getDocumentType(type);
        return DocumentModelFactory.newDocument(parent, name, docType);
    }

    public static DocumentModel newDocument(DocumentModel parent, DocumentType type) {
        return DocumentModelFactory.newDocument(parent, "Untitled_" + Long.toHexString(random.nextLong()), type);
    }

    public static DocumentModel newDocument(DocumentModel parent, String name, DocumentType type) {
        return new DocumentModelImpl(null, type.getName(), null, parent.getPath(), null, null, parent.getRef(), type.getSchemaNames(), type.getFacets(), null, parent.getRepositoryName());
    }

    public static DocumentModelImpl createDocumentModel(Document doc) throws DocumentException {
        DocumentType docType = doc.getType();
        String[] schemas = docType == null ? null : docType.getSchemaNames();
        return DocumentModelFactory.createDocumentModel(doc, schemas);
    }

    public static Map<String, Serializable> updatePrefetch(DocumentModel docModel) {
        HashMap<String, Serializable> prefetchMap = new HashMap<String, Serializable>();
        PrefetchInfo prefetchInfo = docModel.getDocumentType().getPrefetchInfo();
        if (prefetchInfo != null) {
            Field[] prefetchFields;
            for (Field field : prefetchFields = prefetchInfo.getFields()) {
                Object value;
                String typeName = field.getDeclaringType().getName();
                String typeLocalName = field.getName().getLocalName();
                String fieldName = typeName + '.' + typeLocalName;
                try {
                    value = docModel.getProperty(typeName, typeLocalName);
                }
                catch (ClientException e) {
                    continue;
                }
                prefetchMap.put(fieldName, (Serializable)value);
            }
        }
        return prefetchMap;
    }

    /*
     * WARNING - void declaration
     */
    public static DocumentModelImpl createDocumentModel(Document doc, String[] schemas) throws DocumentException {
        DataModel dataModel;
        String p;
        DocumentType type = doc.getType();
        if (type == null) {
            throw new DocumentException("Type not found for doc " + doc);
        }
        Session session = doc.getSession();
        String sid = session.getUserSessionId();
        IdRef docRef = new IdRef(doc.getUUID());
        IdRef parentRef = null;
        Document parent = doc.getParent();
        if (null != parent) {
            parentRef = new IdRef(parent.getUUID());
        }
        HashSet<String> typeFacets = type.getFacets();
        if (doc.isProxy() || doc.isVersion()) {
            typeFacets = typeFacets != null ? new HashSet(typeFacets) : new HashSet<String>();
            typeFacets.add("Immutable");
        }
        String sourceId = null;
        Document sourceDoc = doc.getSourceDocument();
        if (sourceDoc != null) {
            sourceId = sourceDoc.getUUID();
        }
        String repositoryName = null;
        Repository repository = doc.getRepository();
        if (repository != null) {
            repositoryName = repository.getName();
        }
        Path path = (p = doc.getPath()) == null ? null : new Path(p);
        DocumentModelImpl docModel = new DocumentModelImpl(sid, type.getName(), doc.getUUID(), path, doc.getLock(), (DocumentRef)docRef, (DocumentRef)parentRef, type.getSchemaNames(), typeFacets, sourceId, repositoryName);
        if (doc.isVersion()) {
            docModel.setIsVersion(true);
            docModel.putContextData("version.label", (Serializable)((Object)((DocumentVersion)doc).getLabel()));
        }
        if (doc.isProxy()) {
            docModel.setIsProxy(true);
        }
        Schema[] prefetchSchemas = null;
        PrefetchInfo prefetchInfo = type.getPrefetchInfo();
        if (prefetchInfo != null) {
            void var21_26;
            Field[] prefetchFields;
            prefetchSchemas = prefetchInfo.getSchemas();
            Field[] arr$ = prefetchFields = prefetchInfo.getFields();
            int len$ = arr$.length;
            boolean bl = false;
            while (var21_26 < len$) {
                Field field = arr$[var21_26];
                try {
                    Object value = doc.getPropertyValue(field.getName().getPrefixedName());
                    docModel.prefetchProperty(field.getDeclaringType().getName() + '.' + field.getName().getLocalName(), value);
                }
                catch (NoSuchPropertyException e) {
                }
                catch (DocumentException e) {
                    log.error((Object)"Error while building prefetch fields, check the document configuration", (Throwable)e);
                }
                ++var21_26;
            }
        }
        if (schemas != null) {
            for (String string : schemas) {
                dataModel = DocumentModelFactory.exportSchema(sid, (DocumentRef)docRef, doc, type.getSchema(string));
                docModel.addDataModel(dataModel);
            }
        } else if (prefetchSchemas != null && prefetchSchemas.length > 0) {
            for (String string : prefetchSchemas) {
                dataModel = DocumentModelFactory.exportSchema(sid, (DocumentRef)docRef, doc, (Schema)string);
                docModel.addDataModel(dataModel);
            }
        }
        try {
            String lifecycle = doc.getCurrentLifeCycleState();
            docModel.prefetchCurrentLifecycleState(lifecycle);
            String lifeCyclePolicy = doc.getLifeCyclePolicy();
            docModel.prefetchLifeCyclePolicy(lifeCyclePolicy);
        }
        catch (LifeCycleException e) {
            log.debug((Object)("Cannot prefetch lifecycle for doc: " + doc.getName() + ". Error: " + e.getMessage()));
        }
        return docModel;
    }

    public static DocumentModelImpl createDocumentModel(DocumentType docType) throws DocumentException {
        return DocumentModelFactory.createDocumentModel(null, docType);
    }

    public static DocumentModelImpl createDocumentModel(String sessionId, DocumentType docType) throws DocumentException {
        Set facets = docType.getFacets();
        String[] schemas = docType.getSchemaNames();
        DocumentModelImpl docModel = new DocumentModelImpl(sessionId, docType.getName(), null, null, null, null, schemas, facets);
        for (Schema schema : docType.getSchemas()) {
            DataModel dataModel = DocumentModelFactory.exportSchema(null, null, null, schema);
            docModel.addDataModel(dataModel);
        }
        return docModel;
    }

    public static DocumentModelImpl createDocumentModel(String parentPath, String id, DocumentType docType, String[] schemas) throws DocumentException {
        DocumentModelImpl docModel = new DocumentModelImpl(parentPath, id, docType.getName());
        if (schemas != null) {
            for (String schema : schemas) {
                DataModel dataModel = DocumentModelFactory.exportSchema(null, null, null, docType.getSchema(schema));
                docModel.addDataModel(dataModel);
            }
        }
        return docModel;
    }

    public static DataModel exportSchema_OLD(String sid, DocumentRef docRef, Document doc, Schema schema) throws DocumentException {
        Collection fields = schema.getFields();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields) {
            String name = field.getName().getLocalName();
            if (doc == null) {
                map.put(name, field.getDefaultValue());
                continue;
            }
            Type type = field.getType();
            Property prop = doc.getProperty(name);
            map.put(name, DocumentModelFactory.exportProperty(sid, docRef, type, prop));
        }
        return new DataModelImpl(schema.getName(), map);
    }

    public static DataModel exportSchema(String sid, DocumentRef docRef, Document doc, Schema schema) throws DocumentException {
        DocumentPartImpl part = new DocumentPartImpl(schema);
        if (doc != null) {
            try {
                doc.readDocumentPart((DocumentPart)part);
            }
            catch (DocumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DocumentException("failed to read document part", (Throwable)e);
            }
        }
        return new DataModelImpl((DocumentPart)part);
    }

    public static Map<String, Object> exportComplexProperty(String sid, DocumentRef docRef, Property property) throws DocumentException {
        Collection fields = ((ComplexType)property.getType()).getFields();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : fields) {
            Type type = field.getType();
            String name = field.getName().getLocalName();
            Property prop = property.getProperty(name);
            map.put(name, DocumentModelFactory.exportProperty(sid, docRef, type, prop));
        }
        return map;
    }

    private static Object exportProperty(String sid, DocumentRef docRef, Type type, Property prop) throws DocumentException {
        if (type.isSimpleType() || type.isListType()) {
            return prop.getValue();
        }
        if (TypeConstants.isContentType((Type)type)) {
            return prop.getValue();
        }
        if (TypeConstants.isExternalContentType((Type)type)) {
            return DocumentModelFactory.exportComplexProperty(sid, docRef, prop);
        }
        return DocumentModelFactory.exportComplexProperty(sid, docRef, prop);
    }
}

