/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class BulkLifeCycleChangeListener
implements PostCommitEventListener {
    private static final Log log = LogFactory.getLog(BulkLifeCycleChangeListener.class);

    public void handleEvent(EventBundle events) throws ClientException {
        if (!events.containsEventName("lifecycle_transition_event")) {
            return;
        }
        for (Event event : events) {
            if (!"lifecycle_transition_event".equals(event.getName())) continue;
            this.processTransition(event);
        }
    }

    protected void processTransition(Event event) {
        DocumentEventContext docCtx;
        DocumentModel doc;
        log.debug((Object)"Processing lifecycle change in async listener");
        EventContext ctx = event.getContext();
        if (ctx instanceof DocumentEventContext && (doc = (docCtx = (DocumentEventContext)ctx).getSourceDocument()).isFolder()) {
            CoreSession session = docCtx.getCoreSession();
            if (session == null) {
                log.error((Object)"Can not process lifeCycle change since session is null");
                return;
            }
            try {
                DocumentModelList docModelList = session.getChildren(doc.getRef());
                String transition = (String)((Object)docCtx.getProperty("transition"));
                String targetState = (String)((Object)docCtx.getProperty("to"));
                this.changeDocumentsState(session, docModelList, transition, targetState);
                session.save();
            }
            catch (ClientException e) {
                log.error((Object)"Unable to get children", (Throwable)e);
                return;
            }
        }
    }

    protected void changeDocumentsState(CoreSession documentManager, DocumentModelList docModelList, String transition, String targetState) throws ClientException {
        for (DocumentModel docMod : docModelList) {
            boolean removed = false;
            if (docMod.getCurrentLifeCycleState() == null) {
                if ("deleted".equals(targetState)) {
                    log.debug((Object)"Doc has no lifecycle, deleting ...");
                    documentManager.removeDocument(docMod.getRef());
                    removed = true;
                }
            } else if (docMod.getAllowedStateTransitions().contains(transition)) {
                docMod.followTransition(transition);
            } else if (targetState.equals(docMod.getCurrentLifeCycleState())) {
                log.debug((Object)("Document" + docMod.getRef() + " is already in the target LifeCycle state"));
            } else if ("deleted".equals(targetState)) {
                log.debug((Object)("Impossible to change state of " + docMod.getRef() + " :removing"));
                documentManager.removeDocument(docMod.getRef());
                removed = true;
            } else {
                log.debug((Object)("Document" + docMod.getRef() + " has no transition to the target LifeCycle state"));
            }
            if (!docMod.isFolder() || removed) continue;
            this.changeDocumentsState(documentManager, documentManager.getChildren(docMod.getRef()), transition, targetState);
        }
    }
}

