/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.impl;

import java.util.Collection;
import org.nuxeo.ecm.core.lifecycle.LifeCycle;
import org.nuxeo.ecm.core.lifecycle.LifeCycleException;
import org.nuxeo.ecm.core.lifecycle.LifeCycleState;
import org.nuxeo.ecm.core.lifecycle.LifeCycleTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LifeCycleImpl
implements LifeCycle {
    private final String name;
    private final String defaultInitialStateName;
    private final Collection<String> initialStateNames;
    private final Collection<LifeCycleState> states;
    private final Collection<LifeCycleTransition> transitions;

    public LifeCycleImpl(String name, String defaultInitialStateName, Collection<String> initialStateNames, Collection<LifeCycleState> states, Collection<LifeCycleTransition> transitions) {
        this.name = name;
        this.defaultInitialStateName = defaultInitialStateName;
        this.initialStateNames = initialStateNames;
        this.states = states;
        this.transitions = transitions;
    }

    @Override
    public String getDefaultInitialStateName() {
        return this.defaultInitialStateName;
    }

    @Override
    public Collection<String> getInitialStateNames() {
        return this.initialStateNames;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<LifeCycleState> getStates() {
        return this.states;
    }

    @Override
    public LifeCycleState getStateByName(String stateName) {
        LifeCycleState lifeCycleState = null;
        for (LifeCycleState state : this.states) {
            if (!state.getName().equals(stateName)) continue;
            lifeCycleState = state;
            break;
        }
        return lifeCycleState;
    }

    @Override
    public Collection<String> getAllowedStateTransitionsFrom(String stateName) throws LifeCycleException {
        LifeCycleState lifeCycleState = this.getStateByName(stateName);
        if (lifeCycleState != null) {
            return lifeCycleState.getAllowedStateTransitions();
        }
        throw new LifeCycleException("State <" + stateName + "> does not exist !");
    }

    @Override
    public Collection<LifeCycleTransition> getTransitions() {
        return this.transitions;
    }

    @Override
    public LifeCycleTransition getTransitionByName(String transitionName) {
        LifeCycleTransition lifeCycleTransition = null;
        for (LifeCycleTransition itransition : this.transitions) {
            if (!itransition.getName().equals(transitionName)) continue;
            lifeCycleTransition = itransition;
            break;
        }
        return lifeCycleTransition;
    }
}

