/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.security.PermissionDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedPermissionDescriptor {
    private String name;
    private final List<String> subPermissions = new ArrayList<String>();
    private final List<String> aliasPermissions = new ArrayList<String>();

    public MergedPermissionDescriptor(PermissionDescriptor pd) {
        this.mergeDescriptor(pd);
    }

    public void mergeDescriptor(PermissionDescriptor pd) {
        this.name = pd.getName();
        this.subPermissions.addAll(pd.getIncludePermissions());
        this.subPermissions.removeAll(pd.getRemovePermissions());
        this.aliasPermissions.addAll(pd.getAliasPermissions());
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSubPermissions() {
        return this.subPermissions;
    }

    public void removeSubPermission(String permissionName) {
        this.subPermissions.remove(permissionName);
    }

    public List<String> getAliasPermissions() {
        return this.aliasPermissions;
    }

    public String toString() {
        return String.format("MergedPermission[%s]", this.name);
    }
}

