/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.gadgets.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.opensocial.gadgets.service.api.GadgetDeclaration;
import org.nuxeo.opensocial.gadgets.service.api.GadgetService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GadgetServiceImpl
extends DefaultComponent
implements GadgetService {
    private static final String URL_SEPARATOR = "/";
    private static final String HTTP_SEPARATOR = ":";
    private static final String GADGETS_PORT = "gadgets.port";
    private static final String GADGETS_HOST = "gadgets.host";
    private static final String GADGETS_PATH = "gadgets.path";
    private static final String GWTGADGETS_PORT = "gwtgadgets.port";
    private static final String GWTGADGETS_HOST = "gwtgadgets.host";
    private static final String GWTGADGETS_PATH = "gwtgadgets.path";
    private static final String HTTP = "http://";
    private static final String GADGET_XP = "gadget";
    private Map<String, GadgetDeclaration> gadgets = new HashMap<String, GadgetDeclaration>();
    private static final Log log = LogFactory.getLog(GadgetServiceImpl.class);

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (GADGET_XP.equals(extensionPoint)) {
            this.registerNewGadget((GadgetDeclaration)contribution, contributor);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (GADGET_XP.equals(extensionPoint)) {
            this.unregisterNewGadget((GadgetDeclaration)contribution, contributor);
        }
    }

    private void registerNewGadget(GadgetDeclaration gadget, ComponentInstance contributor) {
        if (this.gadgets.containsKey(gadget.getName())) {
            this.gadgets.remove(gadget.getName());
        }
        gadget.setComponentName(contributor.getName());
        this.gadgets.put(gadget.getName(), gadget);
    }

    private void unregisterNewGadget(GadgetDeclaration gadget, ComponentInstance contributor) {
        if (this.gadgets.containsKey(gadget.getName())) {
            this.gadgets.remove(gadget.getName());
        }
    }

    @Override
    public GadgetDeclaration getGadget(String name) {
        if (this.gadgets.containsKey(name)) {
            return this.gadgets.get(name);
        }
        return null;
    }

    @Override
    public InputStream getGadgetResource(String gadgetName, String resourcePath) throws IOException {
        GadgetDeclaration gadget = this.getGadget(gadgetName);
        ComponentInstance component = Framework.getRuntime().getComponentInstance(gadget.getComponentName());
        URL gadgetURL = component.getRuntimeContext().getBundle().getEntry("gadget/" + gadget.getDirectory() + URL_SEPARATOR + resourcePath);
        if (gadgetURL != null) {
            return gadgetURL.openStream();
        }
        return null;
    }

    @Override
    public List<GadgetDeclaration> getGadgetList() {
        ArrayList<GadgetDeclaration> gadgetList = new ArrayList<GadgetDeclaration>();
        for (GadgetDeclaration gadget : this.gadgets.values()) {
            gadgetList.add(gadget);
        }
        return gadgetList;
    }

    @Override
    public List<GadgetDeclaration> getGadgetList(String category) {
        return this.getGadgetList();
    }

    public HashMap<String, ArrayList<String>> getGadgetNameByCategory() {
        HashMap<String, ArrayList<String>> listByCategories = new HashMap<String, ArrayList<String>>();
        for (GadgetDeclaration gadget : this.gadgets.values()) {
            ArrayList<String> listGadget;
            if (listByCategories.containsKey(gadget.getCategory())) {
                listGadget = listByCategories.get(gadget.getCategory());
                listGadget.add(gadget.getName());
                continue;
            }
            if (gadget.getCategory() == null) continue;
            listGadget = new ArrayList();
            listGadget.add(gadget.getName());
            listByCategories.put(gadget.getCategory(), listGadget);
        }
        return listByCategories;
    }

    @Override
    public URL getGadgetDefinition(String gadgetName) {
        GadgetDeclaration gadget = this.getGadget(gadgetName);
        StringBuilder sb = this.getUrlPrefix();
        if (gadget != null) {
            sb.append(gadget.getMountPoint());
            sb.append(URL_SEPARATOR);
            sb.append(gadget.getEntryPoint());
            try {
                return new URL(sb.toString());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private StringBuilder getUrlPrefix() {
        StringBuilder sb = new StringBuilder();
        sb.append(HTTP);
        sb.append(Framework.getProperty((String)GADGETS_HOST));
        sb.append(HTTP_SEPARATOR);
        sb.append(Framework.getProperty((String)GADGETS_PORT));
        sb.append(Framework.getProperty((String)GADGETS_PATH));
        return sb;
    }

    @Override
    public List<String> getGadgetCategory() {
        ArrayList<String> categories = new ArrayList<String>();
        for (GadgetDeclaration gadget : this.gadgets.values()) {
            if (categories.contains(gadget.getCategory())) continue;
            categories.add(gadget.getCategory());
        }
        return categories;
    }

    @Override
    public String getIconUrl(String gadgetName) {
        StringBuilder sb = new StringBuilder(Framework.getProperty((String)GADGETS_PATH));
        GadgetDeclaration gadget = this.getGadget(gadgetName);
        sb.append(gadget.getMountPoint());
        sb.append(URL_SEPARATOR);
        sb.append(gadget.getIcon());
        return sb.toString();
    }
}

