/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;

public class EventImpl
implements Event {
    private static final long serialVersionUID = 1L;
    protected final String name;
    protected final long time;
    protected final EventContext ctx;
    protected int flags;

    public EventImpl(String name, EventContext ctx, int flags, long creationTime) {
        this.name = name;
        this.ctx = ctx;
        this.time = creationTime;
        this.flags = flags;
    }

    public EventImpl(String name, EventContext ctx, int flags) {
        this(name, ctx, flags, System.currentTimeMillis());
    }

    public EventImpl(String name, EventContext ctx) {
        this(name, ctx, 0);
    }

    public int getFlags() {
        return this.flags;
    }

    public EventContext getContext() {
        return this.ctx;
    }

    public String getName() {
        return this.name;
    }

    public long getTime() {
        return this.time;
    }

    public void cancel() {
        this.flags |= 1;
    }

    public void markRollBack() {
        this.flags |= 2;
    }

    public boolean isMarkedForRollBack() {
        return (this.flags & 2) != 0;
    }

    public boolean isCanceled() {
        return (this.flags & 1) != 0;
    }

    public boolean isInline() {
        return (this.flags & 0x10) != 0;
    }

    public void setInline(boolean isInline) {
        this.flags = isInline ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public boolean isCommitEvent() {
        return (this.flags & 4) != 0;
    }

    public void setIsCommitEvent(boolean isCommit) {
        this.flags = isCommit ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public boolean isLocal() {
        return (this.flags & 8) != 0;
    }

    public void setLocal(boolean isLocal) {
        this.flags = isLocal ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public boolean isPublic() {
        return !this.isLocal();
    }

    public void setPublic(boolean isPublic) {
        this.setLocal(!isPublic);
    }

    public boolean isImmediate() {
        return (this.flags & 0x20) != 0;
    }

    public void setImmediate(boolean immediate) {
        this.flags = immediate ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }
}

