/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.jmx;

import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventListenerList;
import org.nuxeo.ecm.core.event.jmx.EventMonitoringMBean;
import org.nuxeo.ecm.core.event.jmx.EventStatsHolder;
import org.nuxeo.runtime.api.Framework;

public class EventMonitoring
implements EventMonitoringMBean {
    private EventServiceAdmin getAdminService() {
        return (EventServiceAdmin)Framework.getLocalService(EventServiceAdmin.class);
    }

    public boolean isAsyncHandlersTrackingEnabled() {
        return EventStatsHolder.isCollectAsyncHandlersExecTime();
    }

    public void setAsyncHandlersTrackingEnabled(boolean collectAsyncHandlersExecTime) {
        EventStatsHolder.setCollectAsyncHandlersExecTime(collectAsyncHandlersExecTime);
    }

    public boolean isSyncHandlersTrackingEnabled() {
        return EventStatsHolder.isCollectSyncHandlersExecTime();
    }

    public void setSyncHandlersTrackingEnabled(boolean collectSyncHandlersExecTime) {
        EventStatsHolder.setCollectSyncHandlersExecTime(collectSyncHandlersExecTime);
    }

    public int getActiveThreadsCount() {
        return this.getAdminService().getActiveThreadsCount();
    }

    public int getEventsInQueueCount() {
        return this.getAdminService().getEventsInQueueCount();
    }

    public String getAsyncHandlersExecTime() {
        return EventStatsHolder.getAsyncHandlersExecTime();
    }

    public String getSyncHandlersExecTime() {
        return EventStatsHolder.getSyncHandlersExecTime();
    }

    public boolean isBlockAsyncHandlers() {
        return this.getAdminService().isBlockAsyncHandlers();
    }

    public void setBlockAsyncHandlers(boolean blockAsyncHandlers) {
        this.getAdminService().setBlockAsyncHandlers(blockAsyncHandlers);
    }

    public boolean isBlockSyncPostCommitHandlers() {
        return this.getAdminService().isBlockSyncPostCommitHandlers();
    }

    public void setBlockSyncPostCommitHandlers(boolean blockSyncPostCommitHandlers) {
        this.getAdminService().setBlockSyncPostCommitHandlers(blockSyncPostCommitHandlers);
    }

    public void resetHandlersExecTime() {
        EventStatsHolder.resetHandlersExecTime();
    }

    public String getListenersConfig() {
        EventListenerList listenerList = this.getAdminService().getListenerList();
        StringBuilder sb = new StringBuilder();
        for (EventListenerDescriptor desc : listenerList.getAsyncPostCommitListenersDescriptors()) {
            sb.append(desc.getName());
            sb.append(" - Async PostCommit - ");
            sb.append(desc.isEnabled());
            sb.append("\n");
        }
        for (EventListenerDescriptor desc : listenerList.getSyncPostCommitListenersDescriptors()) {
            sb.append(desc.getName());
            sb.append(" - Sync PostCommit - ");
            sb.append(desc.isEnabled());
            sb.append("\n");
        }
        for (EventListenerDescriptor desc : listenerList.getInlineListenersDescriptors()) {
            sb.append(desc.getName());
            sb.append(" - Synchronous - ");
            sb.append(desc.isEnabled());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setListenerEnabledFlag(String listenerName, boolean enabled) {
        this.getAdminService().setListenerEnabledFlag(listenerName, enabled);
    }

    public boolean isBulkModeEnabled() {
        return this.getAdminService().isBulkModeEnabled();
    }

    public void setBulkModeEnabled(boolean bulkModeEnabled) {
        this.getAdminService().setBulkModeEnabled(bulkModeEnabled);
    }
}

