/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.tx;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.tx.EventBundleTransactionHandler;
import org.nuxeo.ecm.core.event.tx.PostCommitSynchronousRunner;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BulkExecutor
extends PostCommitSynchronousRunner {
    private static final Log log = LogFactory.getLog(BulkExecutor.class);
    protected static Integer timeout;

    protected static int getExecTimeOutInS() {
        if (timeout == null) {
            String strTimeout = Framework.getProperty((String)"org.nuxeo.ecm.core.event.tx.BulkExecutor.timeout", (String)"600");
            timeout = Integer.parseInt(strTimeout);
        }
        return timeout;
    }

    public BulkExecutor(List<EventListenerDescriptor> listeners, EventBundle event) {
        super(listeners, event, BulkExecutor.getExecTimeOutInS() * 1000);
    }

    @Override
    protected Runnable getExecutor() {
        return new MonoThreadBulkExecutor();
    }

    @Override
    protected void handleUnfinishedThread(Thread runner) {
        log.error((Object)"Bulk execution of event handlers is too long, exiting by killing thread");
        runner.interrupt();
    }

    protected class MonoThreadBulkExecutor
    implements Runnable {
        protected MonoThreadBulkExecutor() {
        }

        public void run() {
            EventBundleTransactionHandler txh = new EventBundleTransactionHandler();
            long t0 = System.currentTimeMillis();
            log.debug((Object)("Start post commit sync execution in Thread " + Thread.currentThread().getId()));
            txh.beginNewTransaction(BulkExecutor.getExecTimeOutInS());
            try {
                for (EventListenerDescriptor listener : BulkExecutor.this.listeners) {
                    listener.asPostCommitListener().handleEvent(BulkExecutor.this.event);
                }
                txh.commitOrRollbackTransaction();
            }
            catch (Throwable t) {
                log.error((Object)"Exception occured during Bulk Event Handler execution, rolling back transaction", t);
                log.error((Object)("Total execution time = " + (System.currentTimeMillis() - t0) + "ms"));
                txh.rollbackTransaction();
            }
            log.debug((Object)("End of all post commit sync executions : " + (System.currentTimeMillis() - t0) + "ms"));
        }
    }
}

