/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.service.impl;

import com.google.inject.Injector;
import java.net.ProxySelector;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.opensocial.service.impl.SimpleProxySelector;
import org.nuxeo.opensocial.servlet.GuiceContextListener;
import org.nuxeo.opensocial.shindig.crypto.KeyDescriptor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenSocialServiceImpl
extends DefaultComponent
implements OpenSocialService {
    public static final String ID = "org.nuxeo.opensocial.service.impl.OpenSocialServiceImpl";
    public static final ComponentName NAME = new ComponentName("org.nuxeo.opensocial.service.impl.OpenSocialServiceImpl");
    private static final Log LOG = LogFactory.getLog(OpenSocialService.class);
    private static final String XP_CRYPTO = "cryptoConfig";
    private static Injector injector;
    private Map<String, String> keys = new HashMap<String, String>();

    public Injector getInjector() {
        return injector;
    }

    @Override
    public GadgetSpecFactory getGadgetSpecFactory() {
        return (GadgetSpecFactory)injector.getInstance(GadgetSpecFactory.class);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP_CRYPTO.equals(extensionPoint)) {
            KeyDescriptor kd = (KeyDescriptor)contribution;
            this.keys.put(kd.getContainer(), kd.getKey());
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        KeyDescriptor kd;
        if (XP_CRYPTO.equals(extensionPoint) && this.keys.containsKey((kd = (KeyDescriptor)contribution).getContainer())) {
            this.keys.remove(kd.getContainer());
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        return null;
    }

    public void activate(ComponentContext context) {
        LOG.info((Object)"Activate component OpenSocial service");
        if (injector == null) {
            injector = GuiceContextListener.guiceInjector;
        }
    }

    public void deactivate(ComponentContext arg0) {
        LOG.info((Object)"DeActivate component OpenSocial service");
    }

    public Object getInstance(Class<?> klass) {
        if (this.getInjector() != null) {
            return this.getInjector().getInstance(klass);
        }
        return null;
    }

    @Override
    public void setInjector(Injector injector) {
        OpenSocialServiceImpl.injector = injector;
    }

    @Override
    public String getKeyForContainer(String defaultContainer) {
        return this.keys.get(defaultContainer);
    }

    @Override
    public ProxySelector getProxySelector() {
        return new SimpleProxySelector();
    }
}

