/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.service.impl;

import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleProxySelector
extends ProxySelector {
    private static final String SHINDIG_PROXY_PROXY_PORT = "shindig.proxy.proxyPort";
    private static final String SHINDIG_PROXY_PROXY_HOST = "shindig.proxy.proxyHost";
    private static final String SHINDIG_PROXY_PROXY_SET = "shindig.proxy.proxySet";
    private static final String SHINDIG_PROXY_PASSWORD = "shindig.proxy.password";
    private static final String SHINDIG_PROXY_USER = "shindig.proxy.user";
    private Proxy proxySettings = null;

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    @Override
    public List<Proxy> select(URI uri) {
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        if ("localhost".equals(uri.getHost())) {
            proxies.add(Proxy.NO_PROXY);
        } else {
            proxies.add(this.getProxySettings());
        }
        return proxies;
    }

    private Proxy getProxySettings() {
        if (SimpleProxySelector.isProxySet()) {
            if (this.proxySettings == null) {
                SimpleProxySelector.setAuthenticator();
                this.proxySettings = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(Framework.getProperty((String)SHINDIG_PROXY_PROXY_HOST), Integer.parseInt(Framework.getProperty((String)SHINDIG_PROXY_PROXY_PORT))));
            }
            return this.proxySettings;
        }
        return Proxy.NO_PROXY;
    }

    private static void setAuthenticator() {
        Authenticator.setDefault(new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                String password = Framework.getProperty((String)SimpleProxySelector.SHINDIG_PROXY_PASSWORD);
                if (password != null) {
                    return new PasswordAuthentication(Framework.getProperty((String)SimpleProxySelector.SHINDIG_PROXY_USER), password.toCharArray());
                }
                return null;
            }
        });
    }

    private static boolean isProxySet() {
        return Framework.getProperty((String)SHINDIG_PROXY_PROXY_SET) != null && Framework.getProperty((String)SHINDIG_PROXY_PROXY_SET).equals("true");
    }
}

