/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.servlet;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.tools.jmx.Manager;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceContextListener
implements ServletContextListener {
    public static final String INJECTOR_ATTRIBUTE = "guice-injector";
    public static final String MODULES_ATTRIBUTE = "guice-modules";
    private boolean jmxInitialized = false;
    private static final Log log = LogFactory.getLog(GuiceContextListener.class);
    public static Injector guiceInjector = null;

    public void contextInitialized(ServletContextEvent event) {
        log.info((Object)"GuiceContextListener contextInitialized");
        ServletContext context = event.getServletContext();
        List<Module> modules = this.getModuleList(context.getInitParameter(MODULES_ATTRIBUTE));
        log.info((Object)"GuiceContextListener getModuleList");
        Injector injector = null;
        try {
            log.info((Object)"GuiceContextListener createInjector");
            injector = Guice.createInjector((Stage)Stage.PRODUCTION, modules);
            OpenSocialService service = (OpenSocialService)Framework.getService(OpenSocialService.class);
            if (service != null) {
                service.setInjector(injector);
            } else {
                guiceInjector = injector;
            }
            context.setAttribute(INJECTOR_ATTRIBUTE, (Object)injector);
        }
        catch (Exception e) {
            log.error((Object)"GuiceContextListener caught exception during injection process", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            if (!this.jmxInitialized) {
                Manager.manage((String)"ShindigGuiceContext", (Injector)injector);
                this.jmxInitialized = true;
            }
        }
        catch (Exception e) {
            log.error((Object)"GuiceContextListener caught exception trying to init shindig guice context (JMX):", (Throwable)e);
        }
    }

    private Module getModuleInstance(String moduleName) throws InstantiationException {
        try {
            return (Module)Class.forName(moduleName).newInstance();
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException();
        }
        catch (ClassNotFoundException e) {
            throw new InstantiationException();
        }
    }

    private List<Module> getModuleList(String moduleNames) {
        LinkedList<Module> modules = new LinkedList<Module>();
        if (moduleNames != null) {
            for (String moduleName : moduleNames.split(":")) {
                try {
                    moduleName = moduleName.trim();
                    if (moduleName.length() <= 0) continue;
                    Module moduleInstance = this.getModuleInstance(moduleName);
                    modules.add(moduleInstance);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return modules;
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        context.removeAttribute(INJECTOR_ATTRIBUTE);
    }
}

