/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.shindig.crypto;

import java.util.HashMap;
import java.util.Map;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenDecoder;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.ContainerConfig;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.apache.shindig.common.util.CharsetUtil;
import org.nuxeo.opensocial.shindig.crypto.BlobCrypterSecurityToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlobCrypterSecurityTokenDecoder
implements SecurityTokenDecoder {
    public static final String SIGNED_FETCH_DOMAIN = "gadgets.signedFetchDomain";
    private BlobCrypter crypter;
    private Map<String, String> domains = new HashMap<String, String>();

    public BlobCrypterSecurityTokenDecoder(ContainerConfig config, String key) {
        byte[] keyBytes = CharsetUtil.getUtf8Bytes((String)key.trim());
        this.crypter = new BasicBlobCrypter(keyBytes);
        for (String container : config.getContainers()) {
            String domain = config.get(container, SIGNED_FETCH_DOMAIN);
            this.domains.put(container, domain);
        }
    }

    public SecurityToken createToken(Map<String, String> tokenParameters) throws SecurityTokenException {
        String token = tokenParameters.get("token");
        if (token == null || token.trim().length() == 0) {
            return new AnonymousSecurityToken();
        }
        String[] fields = token.split(":");
        if (fields.length != 2) {
            throw new SecurityTokenException("Invalid security token " + token);
        }
        String container = fields[0];
        if (this.crypter == null) {
            throw new SecurityTokenException("Unknown container " + token);
        }
        String domain = this.domains.get(container);
        String crypted = fields[1];
        try {
            return BlobCrypterSecurityToken.decrypt(this.crypter, container, domain, crypted);
        }
        catch (BlobCrypterException e) {
            throw new SecurityTokenException((Exception)((Object)e));
        }
    }
}

