/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.shindig.crypto;

import com.google.inject.Inject;
import java.util.Map;
import org.apache.shindig.auth.BasicSecurityTokenDecoder;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenDecoder;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.ContainerConfig;
import org.nuxeo.opensocial.service.api.OpenSocialService;
import org.nuxeo.opensocial.shindig.crypto.BlobCrypterSecurityTokenDecoder;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NXSecurityTokenDecoder
implements SecurityTokenDecoder {
    private static final String SECURITY_TOKEN_TYPE = "gadgets.securityTokenType";
    private SecurityTokenDecoder decoder;
    private String tokenType;
    private ContainerConfig config;

    @Inject
    public NXSecurityTokenDecoder(ContainerConfig config) throws Exception {
        this.tokenType = config.get("default", SECURITY_TOKEN_TYPE);
        if (!"insecure".equals(this.tokenType) && !"secure".equals(this.tokenType)) {
            throw new RuntimeException("Unknown security token type specified in default container configuration. gadgets.securityTokenType: " + this.tokenType);
        }
        this.config = config;
    }

    protected SecurityTokenDecoder getDecoder() throws Exception {
        if (this.decoder == null) {
            if ("insecure".equals(this.tokenType)) {
                this.decoder = new BasicSecurityTokenDecoder();
            } else if ("secure".equals(this.tokenType)) {
                OpenSocialService os = (OpenSocialService)Framework.getService(OpenSocialService.class);
                String key = os.getKeyForContainer("default");
                this.decoder = new BlobCrypterSecurityTokenDecoder(this.config, key);
            }
        }
        return this.decoder;
    }

    public SecurityToken createToken(Map<String, String> tokenParameters) throws SecurityTokenException {
        try {
            return this.getDecoder().createToken(tokenParameters);
        }
        catch (Exception e) {
            throw new SecurityTokenException(e);
        }
    }
}

