/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.shindig.gadgets;

import com.sun.syndication.feed.synd.SyndCategory;
import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndEnclosure;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndPerson;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.shindig.gadgets.FeedProcessor;
import org.apache.shindig.gadgets.GadgetException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NXFeedProcessor
extends FeedProcessor {
    public JSONObject process(String feedUrl, String feedXml, boolean getSummaries, int numEntries) throws GadgetException {
        try {
            SyndFeed feed = new SyndFeedInput().build((Reader)new StringReader(feedXml));
            JSONObject json = new JSONObject();
            json.put("Title", (Object)feed.getTitle());
            json.put("URL", (Object)feedUrl);
            json.put("Description", (Object)feed.getDescription());
            json.put("Link", (Object)feed.getLink());
            if (feed.getCategories().size() > 0) {
                json.put("Categories", this.getCategoriesStringList(feed.getCategories()));
            }
            List authors = feed.getAuthors();
            String jsonAuthor = null;
            jsonAuthor = this.getAuthor(authors);
            JSONArray entries = new JSONArray();
            json.put("Entry", (Object)entries);
            int entryCnt = 0;
            for (Object obj : feed.getEntries()) {
                SyndEntry e = (SyndEntry)obj;
                if (entryCnt >= numEntries) break;
                ++entryCnt;
                JSONObject entry = this.getJSONEntryFromSyndEntry(e, getSummaries);
                entries.put((Object)entry);
                if (jsonAuthor != null) continue;
                jsonAuthor = e.getAuthor();
            }
            json.put("Author", (Object)(jsonAuthor != null ? jsonAuthor : ""));
            return json;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (FeedException e) {
            throw new GadgetException(GadgetException.Code.MALFORMED_XML_DOCUMENT, (Throwable)e);
        }
    }

    private List<String> getCategoriesStringList(List categories) {
        ArrayList<String> result = new ArrayList<String>();
        for (Object cat : categories) {
            SyndCategory syndCat = (SyndCategory)cat;
            result.add(syndCat.getName());
        }
        return result;
    }

    private JSONObject getJSONEntryFromSyndEntry(SyndEntry e, boolean getSummaries) throws JSONException {
        JSONObject entry = new JSONObject();
        entry.put("Title", (Object)e.getTitle());
        entry.put("Link", (Object)e.getLink());
        if (e.getCategories().size() > 0) {
            entry.put("Categories", this.getCategoriesStringList(e.getCategories()));
        }
        if (getSummaries) {
            this.addSummariesFromEntry(entry, e);
        }
        this.addDateFromEntry(entry, e);
        this.joinEnclosureFromEntry(entry, e);
        return entry;
    }

    private void addDateFromEntry(JSONObject entry, SyndEntry e) throws JSONException {
        if (e.getUpdatedDate() != null) {
            entry.put("Date", e.getUpdatedDate().getTime());
        } else if (e.getPublishedDate() != null) {
            entry.put("Date", e.getPublishedDate().getTime());
        } else {
            entry.put("Date", 0);
        }
    }

    private void addSummariesFromEntry(JSONObject entry, SyndEntry e) throws JSONException {
        if (e.getContents() != null && e.getContents().size() > 0) {
            entry.put("Summary", (Object)((SyndContent)e.getContents().get(0)).getValue());
        } else {
            entry.put("Summary", (Object)(e.getDescription() != null ? e.getDescription().getValue() : ""));
        }
    }

    private String getAuthor(List<SyndPerson> authors) {
        String jsonAuthor = null;
        if (authors != null && !authors.isEmpty()) {
            SyndPerson author = authors.get(0);
            if (author.getName() != null) {
                jsonAuthor = author.getName();
            } else if (author.getEmail() != null) {
                jsonAuthor = author.getEmail();
            }
        }
        return jsonAuthor;
    }

    private void joinEnclosureFromEntry(JSONObject entry, SyndEntry e) throws JSONException {
        List enclosuresDefined = e.getEnclosures();
        JSONObject enclosure = new JSONObject();
        if (enclosuresDefined != null && enclosuresDefined.size() > 0) {
            SyndEnclosure enclosureDefined = (SyndEnclosure)enclosuresDefined.get(0);
            enclosure.put("Length", enclosureDefined.getLength());
            enclosure.put("URL", (Object)enclosureDefined.getUrl());
            enclosure.put("MimeType", (Object)enclosureDefined.getType());
        }
        entry.put("Enclosure", (Object)enclosure);
    }
}

