/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.shindig.gadgets;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.net.URI;
import java.util.logging.Logger;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.SoftExpiringCache;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.Check;
import org.apache.shindig.gadgets.AuthType;
import org.apache.shindig.gadgets.DefaultGadgetSpecFactory;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.http.HttpFetcher;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth.OAuthFetcher;
import org.apache.shindig.gadgets.oauth.OAuthFetcherConfig;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.RequestAuthenticationInfo;
import org.nuxeo.opensocial.shindig.gadgets.UriGadgetContext;
import org.nuxeo.opensocial.shindig.oauth.SignedRequestAuthenticationInfo;
import org.nuxeo.opensocial.shindig.oauth.SimpleSignedOAuthFetcherConfig;

@Singleton
public class NXGadgetSpecFactory
implements GadgetSpecFactory {
    private static final int ONE_SECOND = 1000;
    private static final String WEBENGINE_GET_DEF_ACTION = "@@getDef";
    public static final String CACHE_NAME = "gadgetSpecs";
    static final String RAW_GADGETSPEC_XML_PARAM_NAME = "rawxml";
    static final Uri RAW_GADGET_URI = Uri.parse((String)"http://localhost/raw.xml");
    static final String ERROR_SPEC = "<Module><ModulePrefs title='Error'/><Content/></Module>";
    static final String ERROR_KEY = "parse.exception";
    static final Logger LOG = Logger.getLogger(DefaultGadgetSpecFactory.class.getName());
    private final HttpFetcher fetcher;
    private final OAuthFetcherConfig oAuthFetcherConfig;
    private final SoftExpiringCache<Uri, GadgetSpec> cache;
    private final long refresh;

    @Inject
    public NXGadgetSpecFactory(HttpFetcher fetcher, CacheProvider cacheProvider, @Named(value="shindig.cache.xml.refreshInterval") long refresh, SimpleSignedOAuthFetcherConfig oauthFetcherConfig) {
        this.fetcher = fetcher;
        this.oAuthFetcherConfig = oauthFetcherConfig;
        Cache baseCache = cacheProvider.createCache(CACHE_NAME);
        this.cache = new SoftExpiringCache(baseCache);
        this.refresh = refresh;
    }

    public GadgetSpec getGadgetSpec(GadgetContext context) throws GadgetException {
        String rawxml = context.getParameter(RAW_GADGETSPEC_XML_PARAM_NAME);
        if (rawxml != null) {
            return new GadgetSpec(RAW_GADGET_URI, rawxml);
        }
        return this.getGadgetSpec(context, context.getIgnoreCache());
    }

    public GadgetSpec getGadgetSpec(GadgetContext context, boolean ignoreCache) throws GadgetException {
        GadgetException exception;
        Uri uri = Uri.fromJavaUri((URI)context.getUrl());
        if (ignoreCache) {
            return this.fetchObjectAndCache(uri, context, ignoreCache);
        }
        SoftExpiringCache.CachedObject cached = this.cache.getElement((Object)uri);
        GadgetSpec spec = null;
        if (cached == null || cached.isExpired) {
            try {
                spec = this.fetchObjectAndCache(uri, context, ignoreCache);
            }
            catch (GadgetException e) {
                if (cached != null) {
                    spec = (GadgetSpec)cached.obj;
                    Check.notNull((Object)spec);
                } else {
                    spec = new GadgetSpec(uri, ERROR_SPEC);
                    spec.setAttribute(ERROR_KEY, (Object)e);
                }
                LOG.info("GadgetSpec fetch failed for " + uri + " - using cached.");
                this.cache.addElement((Object)uri, (Object)spec, this.refresh);
            }
        } else {
            spec = (GadgetSpec)cached.obj;
        }
        if ((exception = (GadgetException)((Object)spec.getAttribute(ERROR_KEY))) != null) {
            throw exception;
        }
        return spec;
    }

    private GadgetSpec fetchObjectAndCache(Uri uri, GadgetContext context, boolean ignoreCache) throws GadgetException {
        HttpRequest request = new HttpRequest(uri).setIgnoreCache(ignoreCache);
        HttpResponse response = null;
        request.setCacheTtl((int)(this.refresh / 1000L));
        if (context.getToken() != null) {
            AuthType auth = AuthType.SIGNED;
            request.setAuthType(auth);
            SecurityToken token = context.getToken();
            request.setSecurityToken(token);
            request.setOAuthArguments(new OAuthArguments((RequestAuthenticationInfo)new SignedRequestAuthenticationInfo(token.getOwnerId(), token.getViewerId(), uri)));
            OAuthFetcher oauthFetcher = new OAuthFetcher(this.oAuthFetcherConfig, this.fetcher, request);
            response = oauthFetcher.fetch(request);
        } else {
            response = this.fetcher.fetch(request);
        }
        if (response.getHttpStatusCode() != 200) {
            throw new GadgetException(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "Unable to retrieve gadget xml. HTTP error " + response.getHttpStatusCode());
        }
        GadgetSpec spec = new GadgetSpec(uri, response.getResponseAsString());
        this.cache.addElement((Object)uri, (Object)spec, this.refresh);
        return spec;
    }

    public GadgetSpec getGadgetSpec(URI uri, boolean ignoreCache) throws GadgetException {
        UriGadgetContext context = new UriGadgetContext(uri);
        return this.getGadgetSpec(context, ignoreCache);
    }
}

