/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.opensocial.shindig.oauth;

import com.google.inject.Inject;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.oauth.AccessorInfo;
import org.apache.shindig.gadgets.oauth.AccessorInfoBuilder;
import org.apache.shindig.gadgets.oauth.GadgetOAuthTokenStore;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth.OAuthClientState;
import org.apache.shindig.gadgets.oauth.OAuthStore;

public class SignedFetchGadgetOAuthTokenStore
extends GadgetOAuthTokenStore {
    private final OAuthStore store;

    @Inject
    public SignedFetchGadgetOAuthTokenStore(OAuthStore store) {
        super(store, null);
        this.store = store;
    }

    public AccessorInfo getOAuthAccessor(SecurityToken securityToken, OAuthArguments arguments, OAuthClientState clientState) throws GadgetException {
        AccessorInfoBuilder accessorBuilder = new AccessorInfoBuilder();
        OAuthServiceProvider provider = null;
        accessorBuilder.setParameterLocation(AccessorInfo.OAuthParamLocation.URI_QUERY);
        OAuthStore.ConsumerInfo consumer = this.store.getConsumerKeyAndSecret(securityToken, arguments.getServiceName(), provider);
        accessorBuilder.setConsumer(consumer);
        if (arguments.mayUseToken() && securityToken.getOwnerId() != null && securityToken.getViewerId().equals(securityToken.getOwnerId())) {
            this.lookupToken(securityToken, consumer, arguments, clientState, accessorBuilder);
        }
        return accessorBuilder.create();
    }

    private void lookupToken(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, OAuthArguments arguments, OAuthClientState clientState, AccessorInfoBuilder accessorBuilder) throws GadgetException {
        if (clientState.getRequestToken() != null) {
            accessorBuilder.setRequestToken(clientState.getRequestToken());
            accessorBuilder.setTokenSecret(clientState.getRequestTokenSecret());
        } else if (clientState.getAccessToken() != null) {
            accessorBuilder.setAccessToken(clientState.getAccessToken());
            accessorBuilder.setTokenSecret(clientState.getAccessTokenSecret());
            accessorBuilder.setSessionHandle(clientState.getSessionHandle());
            accessorBuilder.setTokenExpireMillis(clientState.getTokenExpireMillis());
        } else {
            OAuthStore.TokenInfo tokenInfo = this.store.getTokenInfo(securityToken, consumerInfo, arguments.getServiceName(), arguments.getTokenName());
            if (tokenInfo != null && tokenInfo.getAccessToken() != null) {
                accessorBuilder.setAccessToken(tokenInfo.getAccessToken());
                accessorBuilder.setTokenSecret(tokenInfo.getTokenSecret());
                accessorBuilder.setSessionHandle(tokenInfo.getSessionHandle());
                accessorBuilder.setTokenExpireMillis(tokenInfo.getTokenExpireMillis());
            } else {
                accessorBuilder.setRequestToken(arguments.getRequestToken());
                accessorBuilder.setTokenSecret(arguments.getRequestTokenSecret());
            }
        }
    }
}

