/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.api.model.DocumentPart;
import org.nuxeo.ecm.platform.rendering.api.DocumentView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDocumentView
implements DocumentView {
    public static final Object UNKNOWN = new Object();
    protected final Map<String, Field> fields;
    protected static final Field SESSION = new Field(){

        public final String getName() {
            return "session";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return CoreInstance.getInstance().getSession(doc.getSessionId());
        }
    };
    protected static final Field ID = new Field(){

        public final String getName() {
            return "id";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getId();
        }
    };
    protected static final Field NAME = new Field(){

        public final String getName() {
            return "name";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getName();
        }
    };
    protected static final Field PATH = new Field(){

        public final String getName() {
            return "path";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getPathAsString();
        }
    };
    protected static final Field TYPE = new Field(){

        public final String getName() {
            return "type";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getType();
        }
    };
    protected static final Field SCHEMAS = new Field(){

        public final String getName() {
            return "schemas";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getDeclaredSchemas();
        }
    };
    protected static final Field FACETS = new Field(){

        public final String getName() {
            return "facets";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getDeclaredFacets();
        }
    };
    protected static final Field STATE = new Field(){

        public final String getName() {
            return "state";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getCurrentLifeCycleState();
        }
    };
    protected static final Field LOCKED = new Field(){

        public final String getName() {
            return "isLocked";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.isLocked();
        }
    };
    protected static final Field LIFE_CYCLE_STATE = new Field(){

        public final String getName() {
            return "lifeCycleState";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getCurrentLifeCycleState();
        }
    };
    protected static final Field LIFE_CYCLE_POLICY = new Field(){

        public final String getName() {
            return "lifeCyclePolicy";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getLifeCyclePolicy();
        }
    };
    protected static final Field ALLOWED_STATE_TRANSITIONS = new Field(){

        public final String getName() {
            return "allowedStateTransitions";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getAllowedStateTransitions();
        }
    };
    protected static final Field IS_FOLDER = new Field(){

        public final String getName() {
            return "isFolder";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getDeclaredFacets().contains("Folderish");
        }
    };
    protected static final Field TITLE = new Field(){

        public String getName() {
            return "title";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getTitle();
        }
    };
    protected static final Field AUTHOR = new Field(){

        public String getName() {
            return "author";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getPart("dublincore").get("creator").getValue();
        }
    };
    protected static final Field CREATED = new Field(){

        public String getName() {
            return "created";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            Calendar cal = (Calendar)doc.getPart("dublincore").get("created").getValue();
            return cal == null ? null : cal.getTime();
        }
    };
    protected static final Field MODIFIED = new Field(){

        public String getName() {
            return "modified";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            Calendar cal = (Calendar)doc.getPart("dublincore").get("modified").getValue();
            return cal == null ? null : cal.getTime();
        }
    };
    protected static final Field CONTENT = new Field(){

        public String getName() {
            return "content";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            DocumentPart part = doc.getPart("file");
            StringBlob blob = null;
            if (part != null) {
                blob = (Blob)part.get("content").getValue();
            }
            return blob != null ? blob : new StringBlob("", "text/plain");
        }
    };
    protected static final Field PARTS = new Field(){

        public String getName() {
            return "parts";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getParts();
        }
    };
    protected static final Field SID = new Field(){

        public String getName() {
            return "sessionId";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getSessionId();
        }
    };
    protected static final Field REPOSITORY = new Field(){

        public String getName() {
            return "repository";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getRepositoryName();
        }
    };
    protected static final Field PARENT = new Field(){

        public String getName() {
            return "parent";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            CoreSession session = CoreInstance.getInstance().getSession(doc.getSessionId());
            return session.getParentDocument(doc.getRef());
        }
    };
    protected static final Field CHILDREN = new Field(){

        public String getName() {
            return "children";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            CoreSession session = CoreInstance.getInstance().getSession(doc.getSessionId());
            return session.getChildren(doc.getRef());
        }
    };
    protected static final Field REF = new Field(){

        public String getName() {
            return "ref";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getRef();
        }
    };
    protected static final Field VERSIONS = new Field(){

        public String getName() {
            return "versions";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return CoreInstance.getInstance().getSession(doc.getSessionId()).getVersions(doc.getRef());
        }
    };
    protected static final Field PROXIES = new Field(){

        public String getName() {
            return "proxies";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return CoreInstance.getInstance().getSession(doc.getSessionId()).getProxies(doc.getRef(), null);
        }
    };
    protected static final Field VERSION_LABEL = new Field(){

        public String getName() {
            return "versionLabel";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getVersionLabel();
        }
    };
    protected static final Field SOURCE_ID = new Field(){

        public String getName() {
            return "sourceId";
        }

        public Object getValue(DocumentModel doc) throws Exception {
            return doc.getSourceId();
        }
    };
    public static final DefaultDocumentView DEFAULT = new DefaultDocumentView();

    public DefaultDocumentView() {
        this.fields = new HashMap<String, Field>();
        this.initialize();
    }

    public DefaultDocumentView(Map<String, Field> fields) {
        this.fields = fields == null ? new HashMap() : fields;
    }

    protected void initialize() {
        this.addField(SESSION);
        this.addField(ID);
        this.addField(NAME);
        this.addField(PATH);
        this.addField(TYPE);
        this.addField(PARTS);
        this.addField(SID);
        this.addField(REPOSITORY);
        this.addField(SCHEMAS);
        this.addField(FACETS);
        this.addField(LOCKED);
        this.addField(LIFE_CYCLE_STATE);
        this.addField(LIFE_CYCLE_POLICY);
        this.addField(ALLOWED_STATE_TRANSITIONS);
        this.addField(IS_FOLDER);
        this.addField(TITLE);
        this.addField(AUTHOR);
        this.addField(CREATED);
        this.addField(MODIFIED);
        this.addField(CONTENT);
        this.addField(PARENT);
        this.addField(CHILDREN);
        this.addField(REF);
        this.addField(VERSIONS);
        this.addField(PROXIES);
        this.addField(VERSION_LABEL);
        this.addField(SOURCE_ID);
    }

    public final void addField(Field field) {
        this.fields.put(field.getName(), field);
    }

    public final void addFields(Collection<Field> fields) {
        for (Field field : fields) {
            this.fields.put(field.getName(), field);
        }
    }

    public final void removeField(String name) {
        this.fields.remove(name);
    }

    public Field getField(String name) {
        return this.fields.get(name);
    }

    @Override
    public Object get(DocumentModel doc, String name) throws Exception {
        Field field = this.fields.get(name);
        if (field != null) {
            return field.getValue(doc);
        }
        if (name.indexOf(58) > -1) {
            return doc.getProperty(name);
        }
        DocumentPart part = doc.getPart(name);
        if (part != null) {
            return part;
        }
        return UNKNOWN;
    }

    @Override
    public Collection<String> keys(DocumentModel doc) {
        ArrayList<String> keys = new ArrayList<String>(this.fields.keySet());
        keys.addAll(Arrays.asList(doc.getDeclaredSchemas()));
        return keys;
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    public boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public int size(DocumentModel doc) {
        return this.fields.size() + doc.getDeclaredSchemas().length;
    }

    public static interface Field {
        public String getName();

        public Object getValue(DocumentModel var1) throws Exception;
    }
}

