/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.fm.adapters;

import freemarker.ext.beans.ArrayModel;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.Serializable;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.platform.rendering.fm.FreemarkerEngine;
import org.nuxeo.ecm.platform.rendering.fm.adapters.BlobTemplate;
import org.nuxeo.ecm.platform.rendering.fm.adapters.ComplexPropertyTemplate;
import org.nuxeo.ecm.platform.rendering.fm.adapters.DocumentTemplate;
import org.nuxeo.ecm.platform.rendering.fm.adapters.ListPropertyTemplate;
import org.nuxeo.ecm.platform.rendering.fm.adapters.PropertyWrapper;

public class DocumentObjectWrapper
extends DefaultObjectWrapper {
    protected final FreemarkerEngine engine;

    public DocumentObjectWrapper(FreemarkerEngine engine) {
        this.engine = engine;
    }

    public final TemplateModel wrap(Object obj) throws TemplateModelException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof DocumentModel) {
            return new DocumentTemplate((ObjectWrapper)this, (DocumentModel)obj);
        }
        if (obj instanceof Property) {
            Property p = (Property)obj;
            if (p.isScalar()) {
                return new PropertyWrapper(this).wrap(p);
            }
            if (p.isList()) {
                if (obj instanceof ListProperty) {
                    return new ListPropertyTemplate(this, (ListProperty)obj);
                }
                if (obj instanceof ArrayProperty) {
                    Serializable value;
                    try {
                        value = ((ArrayProperty)obj).getValue();
                    }
                    catch (PropertyException e) {
                        throw new IllegalArgumentException("Cannot get array from array property " + obj);
                    }
                    if (value == null) {
                        return TemplateModel.NOTHING;
                    }
                    return new ArrayModel((Object)value, (BeansWrapper)this);
                }
            } else {
                if (p.getClass() == BlobProperty.class) {
                    try {
                        Blob blob = (Blob)p.getValue();
                        if (blob == null) {
                            return TemplateModel.NOTHING;
                        }
                        return new BlobTemplate(this, blob);
                    }
                    catch (PropertyException e) {
                        throw new TemplateModelException((Exception)((Object)e));
                    }
                }
                return new ComplexPropertyTemplate(this, (Property)obj);
            }
        }
        return super.wrap(obj);
    }
}

