/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.fm.extensions;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.platform.rendering.fm.extensions.BlockWriterRegistry;

public class BlockWriter
extends Writer {
    BlockWriterRegistry reg;
    final String page;
    final String name;
    StringBuilder buf = new StringBuilder();
    List<String> segments = new ArrayList<String>();
    List<String> blocks = new ArrayList<String>();
    BlockWriter superBlock;
    BlockWriter baseBlock;
    String ifBlockDefined;
    boolean suppressOutput = false;

    public BlockWriter(String page, String name, BlockWriterRegistry reg) {
        this.reg = reg;
        this.name = name;
        this.page = page;
    }

    public final BlockWriterRegistry getRegistry() {
        return this.reg;
    }

    public void setSuppressOutput(boolean suppressOutput) {
        this.suppressOutput = suppressOutput;
    }

    public boolean getSuppressOutput() {
        return this.suppressOutput;
    }

    public void close() throws IOException {
        this.buf = null;
        this.segments = null;
        this.blocks = null;
        this.superBlock = null;
        this.reg = null;
    }

    public void flush() throws IOException {
    }

    public boolean isEmpty() {
        return this.buf.length() == 0 && this.segments.isEmpty() && this.blocks.isEmpty();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (!this.suppressOutput) {
            this.buf.append(cbuf, off, len);
        }
    }

    public void writeBlock(BlockWriter bw) {
        if (!this.suppressOutput) {
            this.segments.add(this.buf.toString());
            this.buf.setLength(0);
            this.blocks.add(bw.name);
        }
        this.reg.addBlock(bw.name, bw);
    }

    public void writeSuperBlock() {
        if (!this.suppressOutput) {
            this.segments.add(this.buf.toString());
            this.buf.setLength(0);
            this.blocks.add("..");
        }
    }

    public void copyTo(Writer writer) throws TemplateException, IOException {
        BlockWriter bw;
        if (this.ifBlockDefined != null && ((bw = this.reg.getBlock(this.ifBlockDefined)) == null || bw.isEmpty())) {
            return;
        }
        int len = this.segments.size();
        for (int i = 0; i < len; ++i) {
            writer.write(this.segments.get(i));
            String key = this.blocks.get(i);
            BlockWriter bw2 = null;
            bw2 = key == ".." ? this.superBlock : this.reg.getBlock(key);
            bw2.copyTo(writer);
        }
        writer.write(this.buf.toString());
    }

    public String toString() {
        return this.name + "@" + this.page;
    }
}

