/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.fm.extensions;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.text.MessageFormat;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessagesMethod
implements TemplateMethodModelEx {
    protected static final ResourceBundle NULL_BUNDLE = new ListResourceBundle(){

        protected Object[][] getContents() {
            return new Object[0][0];
        }
    };
    protected ResourceBundle bundle;

    public MessagesMethod(ResourceBundle bundle) {
        this.setBundle(bundle);
    }

    public void setBundle(ResourceBundle bundle) {
        this.bundle = bundle;
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("messages");
            }
            catch (MissingResourceException e) {
                this.bundle = NULL_BUNDLE;
            }
        }
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public Object exec(List arguments) throws TemplateModelException {
        String value;
        int size = arguments.size();
        if (size < 1) {
            throw new TemplateModelException("Invalid number of arguments for messages(key, args ..) method");
        }
        SimpleScalar scalar = (SimpleScalar)arguments.get(0);
        if (scalar == null) {
            throw new TemplateModelException("the argument is not defined");
        }
        String key = scalar.getAsString();
        try {
            value = this.bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return '!' + key + '!';
        }
        if (size > 1) {
            String[] args = new String[size - 1];
            for (int i = 0; i < args.length; ++i) {
                args[i] = ((SimpleScalar)arguments.get(i + 1)).getAsString();
            }
            value = MessageFormat.format(value, args);
        }
        return value;
    }
}

