/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.wiki;

import java.io.IOException;
import java.io.Writer;
import org.nuxeo.ecm.platform.rendering.wiki.Toc;
import org.nuxeo.ecm.platform.rendering.wiki.WikiSerializerHandler;
import org.nuxeo.ecm.platform.rendering.wiki.WikiText;
import org.nuxeo.ecm.platform.rendering.wiki.WikiWriter;

public class TocText
implements WikiText {
    protected String title = "Table of Contents";

    public TocText(String title) {
        if (title != null && (title = title.trim()).length() > 0) {
            this.title = title;
        }
    }

    public void writeTo(WikiSerializerHandler handler, Writer writer) throws IOException {
        this.printToc(handler, writer);
    }

    public void printToc(WikiSerializerHandler serializer, Writer writer) throws IOException {
        this.printTocHeader(serializer, writer, this.title);
        Toc.Entry h = serializer.toc.head.firstChild;
        if (h != null) {
            this.prinEntry(serializer, writer, h);
        }
        this.printTocFooter(serializer, writer);
    }

    private void prinEntry(WikiSerializerHandler serializer, Writer writer, Toc.Entry entry) throws IOException {
        this.printHeading(serializer, writer, entry);
        if (entry.firstChild != null) {
            writer.write("<ol>" + WikiWriter.LINE_SEP);
            this.prinEntry(serializer, writer, entry.firstChild);
            writer.write("</ol>" + WikiWriter.LINE_SEP);
        }
        if (entry.next != null) {
            this.prinEntry(serializer, writer, entry.next);
        }
    }

    protected void printTocHeader(WikiSerializerHandler serializer, Writer writer, String title) throws IOException {
        writer.write("<table class=\"toc\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">");
        writer.write(WikiWriter.LINE_SEP);
        writer.write("<tr><td>");
        writer.write("<div class=\"tocTitle\">" + title + "</div>");
        writer.write("</td></tr>");
        writer.write(WikiWriter.LINE_SEP);
        writer.write("<tr><td>");
        writer.write(WikiWriter.LINE_SEP);
        writer.write("<ol class=\"contentToc\">");
        writer.write(WikiWriter.LINE_SEP);
    }

    protected void printTocFooter(WikiSerializerHandler serializer, Writer writer) throws IOException {
        writer.write("</ol>");
        writer.write(WikiWriter.LINE_SEP);
        writer.write("</td></tr>");
        writer.write(WikiWriter.LINE_SEP);
        writer.write("</table>");
        writer.write(WikiWriter.LINE_SEP);
    }

    protected void printHeading(WikiSerializerHandler serializer, Writer writer, Toc.Entry entry) throws IOException {
        writer.write("<li><a href=\"#heading_" + entry.id + "\">" + entry.title + "</a></li>" + WikiWriter.LINE_SEP);
    }
}

