/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendering.wiki.extensions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.rendering.wiki.WikiFilter;

@XObject(value="filter")
public class PatternFilter
implements WikiFilter {
    @XNode(value="pattern")
    protected Pattern pattern;
    @XNode(value="replacement")
    protected String replacement;

    public PatternFilter(String pattern, String replacement) {
        this.pattern = Pattern.compile(pattern);
        this.replacement = replacement;
    }

    public String apply(String content) {
        Matcher matcher = this.pattern.matcher(content);
        if (!matcher.find()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        do {
            matcher.appendReplacement(sb, this.replacement);
        } while (matcher.find());
        matcher.appendTail(sb);
        return sb.toString();
    }
}

