/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutionException;
import edu.emory.mathcs.backport.java.util.concurrent.Future;
import edu.emory.mathcs.backport.java.util.concurrent.LinkedBlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.ThreadPoolExecutor;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Statistics;
import net.sf.ehcache.Status;
import net.sf.ehcache.bootstrap.BootstrapCacheLoader;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.exceptionhandler.CacheExceptionHandler;
import net.sf.ehcache.extension.CacheExtension;
import net.sf.ehcache.loader.CacheLoader;
import net.sf.ehcache.store.DiskStore;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Store;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Cache
implements Ehcache {
    public static final String DEFAULT_CACHE_NAME = "default";
    public static final String NET_SF_EHCACHE_DISABLED = "net.sf.ehcache.disabled";
    public static final long DEFAULT_EXPIRY_THREAD_INTERVAL_SECONDS = 120L;
    private static final int DEFAULT_SPOOL_BUFFER_SIZE = 30;
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$Cache == null ? (class$net$sf$ehcache$Cache = Cache.class$("net.sf.ehcache.Cache")) : class$net$sf$ehcache$Cache).getName());
    private static final MemoryStoreEvictionPolicy DEFAULT_MEMORY_STORE_EVICTION_POLICY = MemoryStoreEvictionPolicy.LRU;
    private static InetAddress localhost;
    private static final int BACK_OFF_TIME_MILLIS = 50;
    private static final int EXECUTOR_KEEP_ALIVE_TIME = 60000;
    private static final int EXECUTOR_MAXIMUM_POOL_SIZE = 10;
    private static final int EXECUTOR_CORE_POOL_SIZE = 0;
    private boolean disabled;
    private Store diskStore;
    private String diskStorePath;
    private Status status;
    private CacheConfiguration configuration;
    private long hitCount;
    private long memoryStoreHitCount;
    private long diskStoreHitCount;
    private long missCountNotFound;
    private long missCountExpired;
    private MemoryStore memoryStore;
    private RegisteredEventListeners registeredEventListeners;
    private List registeredCacheExtensions;
    private String guid;
    private CacheManager cacheManager;
    private BootstrapCacheLoader bootstrapCacheLoader;
    private int statisticsAccuracy;
    private long totalGetTime;
    private CacheExceptionHandler cacheExceptionHandler;
    private CacheLoader cacheLoader;
    private ThreadPoolExecutor executorService;
    static /* synthetic */ Class class$net$sf$ehcache$Cache;

    public Cache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds) {
        this(name, maxElementsInMemory, DEFAULT_MEMORY_STORE_EVICTION_POLICY, overflowToDisk, null, eternal, timeToLiveSeconds, timeToIdleSeconds, false, 120L, null, null);
    }

    public Cache(String name, int maxElementsInMemory, boolean overflowToDisk, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds) {
        this(name, maxElementsInMemory, DEFAULT_MEMORY_STORE_EVICTION_POLICY, overflowToDisk, null, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, null, null);
        LOG.warn((Object)("An API change between ehcache-1.1 and ehcache-1.2 results in the persistence path being set to " + DiskStoreConfiguration.getDefaultPath() + " when the ehcache-1.1 constructor is used. " + "Please change to the 1.2 constructor."));
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners) {
        this(name, maxElementsInMemory, memoryStoreEvictionPolicy, overflowToDisk, diskStorePath, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, registeredEventListeners, null);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader) {
        this(name, maxElementsInMemory, memoryStoreEvictionPolicy, overflowToDisk, diskStorePath, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, registeredEventListeners, bootstrapCacheLoader, 0);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk) {
        this(name, maxElementsInMemory, memoryStoreEvictionPolicy, overflowToDisk, diskStorePath, eternal, timeToLiveSeconds, timeToIdleSeconds, diskPersistent, diskExpiryThreadIntervalSeconds, registeredEventListeners, bootstrapCacheLoader, maxElementsOnDisk, 0);
    }

    public Cache(String name, int maxElementsInMemory, MemoryStoreEvictionPolicy memoryStoreEvictionPolicy, boolean overflowToDisk, String diskStorePath, boolean eternal, long timeToLiveSeconds, long timeToIdleSeconds, boolean diskPersistent, long diskExpiryThreadIntervalSeconds, RegisteredEventListeners registeredEventListeners, BootstrapCacheLoader bootstrapCacheLoader, int maxElementsOnDisk, int diskSpoolBufferSizeMB) {
        String value = System.getProperty(NET_SF_EHCACHE_DISABLED);
        if (value != null) {
            this.disabled = value.equalsIgnoreCase("true");
        }
        this.changeStatus(Status.STATUS_UNINITIALISED);
        this.guid = this.createGuid();
        this.configuration = new CacheConfiguration();
        this.configuration.setName(name);
        this.configuration.setMaxElementsInMemory(maxElementsInMemory);
        this.configuration.setMemoryStoreEvictionPolicyFromObject(memoryStoreEvictionPolicy);
        this.configuration.setOverflowToDisk(overflowToDisk);
        this.configuration.setEternal(eternal);
        this.configuration.setTimeToLiveSeconds(timeToLiveSeconds);
        this.configuration.setTimeToIdleSeconds(timeToIdleSeconds);
        this.configuration.setDiskPersistent(diskPersistent);
        this.configuration.setMaxElementsOnDisk(maxElementsOnDisk);
        this.diskStorePath = diskStorePath == null ? DiskStoreConfiguration.getDefaultPath() : diskStorePath;
        this.registeredEventListeners = registeredEventListeners == null ? new RegisteredEventListeners(this) : registeredEventListeners;
        this.registeredCacheExtensions = this.createNewCacheExtensionsList();
        if (diskExpiryThreadIntervalSeconds == 0L) {
            this.configuration.setDiskExpiryThreadIntervalSeconds(120L);
        } else {
            this.configuration.setDiskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds);
        }
        if (diskSpoolBufferSizeMB == 0) {
            this.configuration.setDiskSpoolBufferSizeMB(30);
        } else {
            this.configuration.setDiskSpoolBufferSizeMB(diskSpoolBufferSizeMB);
        }
        if (memoryStoreEvictionPolicy == null) {
            this.configuration.setMemoryStoreEvictionPolicyFromObject(DEFAULT_MEMORY_STORE_EVICTION_POLICY);
        }
        this.bootstrapCacheLoader = bootstrapCacheLoader;
        this.statisticsAccuracy = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialise() {
        Cache cache = this;
        synchronized (cache) {
            if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
                throw new IllegalStateException("Cannot initialise the " + this.configuration.getName() + " cache because its status is not STATUS_UNINITIALISED");
            }
            if (this.configuration.getMaxElementsInMemory() == 0 && LOG.isWarnEnabled()) {
                LOG.warn((Object)("Cache: " + this.configuration.getName() + " has a maxElementsInMemory of 0. It is strongly recommended to " + "have a maximumSize of at least 1. Performance is halved by not using a MemoryStore."));
            }
            this.diskStore = this.createDiskStore();
            this.memoryStore = MemoryStore.create(this, this.diskStore);
            this.changeStatus(Status.STATUS_ALIVE);
            this.initialiseRegisteredCacheExtensions();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Initialised cache: " + this.configuration.getName()));
        }
        if (this.disabled && LOG.isWarnEnabled()) {
            LOG.warn((Object)("Cache: " + this.configuration.getName() + " is disabled because the " + NET_SF_EHCACHE_DISABLED + " property was set to true. No elements will be added to the cache."));
        }
    }

    protected Store createDiskStore() {
        if (this.isDiskStore()) {
            return new DiskStore(this, this.diskStorePath);
        }
        return null;
    }

    protected boolean isDiskStore() {
        return this.configuration.isOverflowToDisk() || this.configuration.isDiskPersistent();
    }

    public void bootstrap() {
        if (!this.disabled && this.bootstrapCacheLoader != null) {
            this.bootstrapCacheLoader.load(this);
        }
    }

    private void changeStatus(Status status) {
        this.status = status;
    }

    public final void put(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.put(element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void put(Element element, boolean doNotNotifyCacheReplicators) throws IllegalArgumentException, IllegalStateException, CacheException {
        boolean elementExists;
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null) {
            if (doNotNotifyCacheReplicators) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Element from replicated put is null. This happens because the element is a SoftReference and it has been collected.Increase heap memory on the JVM or set -Xms to be the same as -Xmx to avoid this problem.");
                }
            } else {
                throw new IllegalArgumentException("Element cannot be null");
            }
        }
        element.resetAccessStatistics();
        Object key = element.getObjectKey();
        boolean bl = elementExists = this.isElementInMemory(key) || this.isElementOnDisk(key);
        if (elementExists) {
            element.updateUpdateStatistics();
        }
        this.applyDefaultsToElementWithoutLifespanSet(element);
        this.backOffIfDiskSpoolFull();
        Cache cache = this;
        synchronized (cache) {
            this.memoryStore.put(element);
        }
        if (elementExists) {
            this.registeredEventListeners.notifyElementUpdated(element, doNotNotifyCacheReplicators);
        } else {
            this.registeredEventListeners.notifyElementPut(element, doNotNotifyCacheReplicators);
        }
    }

    private void backOffIfDiskSpoolFull() {
        if (this.diskStore != null && this.diskStore.backedUp()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void applyDefaultsToElementWithoutLifespanSet(Element element) {
        if (!element.isLifespanSet()) {
            element.setTimeToLive((int)this.configuration.getTimeToLiveSeconds());
            element.setTimeToIdle((int)this.configuration.getTimeToIdleSeconds());
            element.setEternal(this.configuration.isEternal());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putQuiet(Element element) throws IllegalArgumentException, IllegalStateException, CacheException {
        this.checkStatus();
        if (this.disabled) {
            return;
        }
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        this.applyDefaultsToElementWithoutLifespanSet(element);
        Cache cache = this;
        synchronized (cache) {
            this.memoryStore.put(element);
        }
    }

    public final Element get(Serializable key) throws IllegalStateException, CacheException {
        return this.get((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element get(Object key) throws IllegalStateException, CacheException {
        Element element;
        this.checkStatus();
        long start = System.currentTimeMillis();
        Cache cache = this;
        synchronized (cache) {
            element = this.searchInMemoryStore(key, true);
            if (element == null && this.isDiskStore()) {
                element = this.searchInDiskStore(key, true);
            }
            if (element == null) {
                ++this.missCountNotFound;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(this.configuration.getName() + " cache - Miss"));
                }
            } else {
                ++this.hitCount;
            }
        }
        long end = System.currentTimeMillis();
        this.totalGetTime += end - start;
        return element;
    }

    public Element getWithLoader(Object key, CacheLoader loader, Object loaderArgument) throws CacheException {
        Element element = this.get(key);
        if (element != null) {
            return element;
        }
        if (this.cacheLoader == null && loader == null) {
            return null;
        }
        try {
            element = this.getQuiet(key);
            if (element != null) {
                return element;
            }
            Future future = this.asynchronousLoad(key, loader, loaderArgument);
            future.get();
        }
        catch (Exception e) {
            throw new CacheException("Exception on load for key " + key, e);
        }
        return this.getQuiet(key);
    }

    public void load(Object key) throws CacheException {
        if (this.cacheLoader == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The CacheLoader is null. Returning.");
            }
            return;
        }
        boolean existsOnCall = this.isKeyInCache(key);
        if (existsOnCall) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The key " + key + " exists in the cache. Returning."));
            }
            return;
        }
        this.asynchronousLoad(key, null, null);
    }

    public Map getAllWithLoader(Collection keys, Object loaderArgument) throws CacheException {
        if (keys == null) {
            return new HashMap(0);
        }
        HashMap map = new HashMap(keys.size());
        ArrayList missingKeys = new ArrayList(keys.size());
        if (this.cacheLoader != null) {
            Object key = null;
            try {
                map = new HashMap(keys.size());
                Iterator iterator = keys.iterator();
                while (iterator.hasNext()) {
                    key = iterator.next();
                    if (this.isKeyInCache(key)) {
                        Element element = this.get(key);
                        if (element != null) {
                            map.put(key, element.getObjectValue());
                            continue;
                        }
                        map.put(key, null);
                        continue;
                    }
                    missingKeys.add(key);
                }
                Future future = this.asynchronousLoadAll(missingKeys, loaderArgument);
                future.get();
                for (int i = 0; i < missingKeys.size(); ++i) {
                    key = missingKeys.get(i);
                    Element element = this.get(key);
                    if (element != null) {
                        map.put(key, element.getObjectValue());
                        continue;
                    }
                    map.put(key, null);
                }
            }
            catch (ExecutionException e) {
                throw new CacheException(e.getMessage() + " for key " + key, e);
            }
            catch (InterruptedException e) {
                throw new CacheException(e.getMessage() + " for key " + key, e);
            }
        } else {
            Iterator iterator = keys.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                Element element = this.get(key);
                if (element != null) {
                    map.put(key, element.getObjectValue());
                    continue;
                }
                map.put(key, null);
            }
        }
        return map;
    }

    public void loadAll(Collection keys, Object argument) throws CacheException {
        if (this.cacheLoader == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The CacheLoader is null. Returning.");
            }
            return;
        }
        if (keys == null) {
            return;
        }
        this.asynchronousLoadAll(keys, argument);
    }

    public final Element getQuiet(Serializable key) throws IllegalStateException, CacheException {
        return this.getQuiet((Object)key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Element getQuiet(Object key) throws IllegalStateException, CacheException {
        Element element;
        this.checkStatus();
        Cache cache = this;
        synchronized (cache) {
            element = this.searchInMemoryStore(key, false);
            if (element == null && this.isDiskStore()) {
                element = this.searchInDiskStore(key, false);
            }
        }
        return element;
    }

    public final synchronized List getKeys() throws IllegalStateException, CacheException {
        this.checkStatus();
        ArrayList<Object> allKeyList = new ArrayList<Object>();
        List<Object> keyList = Arrays.asList(this.memoryStore.getKeyArray());
        allKeyList.addAll(keyList);
        if (this.isDiskStore()) {
            HashSet<Object> allKeys = new HashSet<Object>();
            allKeys.addAll(keyList);
            Object[] diskKeys = this.diskStore.getKeyArray();
            for (int i = 0; i < diskKeys.length; ++i) {
                Object diskKey = diskKeys[i];
                if (!allKeys.add(diskKey)) continue;
                allKeyList.add(diskKey);
            }
        }
        return allKeyList;
    }

    public final List getKeysWithExpiryCheck() throws IllegalStateException, CacheException {
        List allKeyList = this.getKeys();
        ArrayList nonExpiredKeys = new ArrayList(allKeyList.size());
        int allKeyListSize = allKeyList.size();
        for (int i = 0; i < allKeyListSize; ++i) {
            Object key = allKeyList.get(i);
            Element element = this.getQuiet(key);
            if (element == null) continue;
            nonExpiredKeys.add(key);
        }
        nonExpiredKeys.trimToSize();
        return nonExpiredKeys;
    }

    public final synchronized List getKeysNoDuplicateCheck() throws IllegalStateException {
        this.checkStatus();
        ArrayList<Object> allKeys = new ArrayList<Object>();
        List<Object> memoryKeySet = Arrays.asList(this.memoryStore.getKeyArray());
        allKeys.addAll(memoryKeySet);
        if (this.isDiskStore()) {
            List<Object> diskKeySet = Arrays.asList(this.diskStore.getKeyArray());
            allKeys.addAll(diskKeySet);
        }
        return allKeys;
    }

    private Element searchInMemoryStore(Object key, boolean updateStatistics) {
        Element element = updateStatistics ? this.memoryStore.get(key) : this.memoryStore.getQuiet(key);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.configuration.getName() + " Memory cache hit, but element expired"));
                }
                if (updateStatistics) {
                    ++this.missCountExpired;
                }
                this.remove(key, true, true, false);
                element = null;
            } else if (updateStatistics) {
                ++this.memoryStoreHitCount;
            }
        }
        return element;
    }

    private Element searchInDiskStore(Object key, boolean updateStatistics) {
        if (!(key instanceof Serializable)) {
            return null;
        }
        Serializable serializableKey = (Serializable)key;
        Element element = updateStatistics ? this.diskStore.get(serializableKey) : this.diskStore.getQuiet(serializableKey);
        if (element != null) {
            if (this.isExpired(element)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(this.configuration.getName() + " cache - Disk Store hit, but element expired"));
                }
                ++this.missCountExpired;
                this.remove(key, true, true, false);
                element = null;
            } else {
                ++this.diskStoreHitCount;
                this.memoryStore.put(element);
            }
        }
        return element;
    }

    public final boolean remove(Serializable key) throws IllegalStateException {
        return this.remove((Object)key);
    }

    public final boolean remove(Object key) throws IllegalStateException {
        return this.remove(key, false);
    }

    public final boolean remove(Serializable key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.remove((Object)key, doNotNotifyCacheReplicators);
    }

    public final boolean remove(Object key, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        return this.remove(key, false, true, doNotNotifyCacheReplicators);
    }

    public final boolean removeQuiet(Serializable key) throws IllegalStateException {
        return this.remove(key, false, false, false);
    }

    public final boolean removeQuiet(Object key) throws IllegalStateException {
        return this.remove(key, false, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Object key, boolean expiry, boolean notifyListeners, boolean doNotNotifyCacheReplicators) throws IllegalStateException {
        Element elementFromDiskStore;
        Element elementFromMemoryStore;
        this.checkStatus();
        boolean removed = false;
        Cache cache = this;
        synchronized (cache) {
            elementFromMemoryStore = this.memoryStore.remove(key);
            elementFromDiskStore = null;
            if (this.isDiskStore() && key instanceof Serializable) {
                Serializable serializableKey = (Serializable)key;
                elementFromDiskStore = this.diskStore.remove(serializableKey);
            }
        }
        boolean removeNotified = false;
        if (elementFromMemoryStore != null) {
            if (notifyListeners) {
                if (expiry) {
                    this.registeredEventListeners.notifyElementExpiry(elementFromMemoryStore, doNotNotifyCacheReplicators);
                } else {
                    removeNotified = true;
                    this.registeredEventListeners.notifyElementRemoved(elementFromMemoryStore, doNotNotifyCacheReplicators);
                }
            }
            removed = true;
        }
        if (elementFromDiskStore != null) {
            if (expiry) {
                this.registeredEventListeners.notifyElementExpiry(elementFromDiskStore, doNotNotifyCacheReplicators);
            } else {
                removeNotified = true;
                this.registeredEventListeners.notifyElementRemoved(elementFromDiskStore, doNotNotifyCacheReplicators);
            }
            removed = true;
        }
        if (!expiry && !removeNotified) {
            Element syntheticElement = new Element(key, null);
            this.registeredEventListeners.notifyElementRemoved(syntheticElement, doNotNotifyCacheReplicators);
        }
        return removed;
    }

    public void removeAll() throws IllegalStateException, CacheException {
        this.removeAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(boolean doNotNotifyCacheReplicators) throws IllegalStateException, CacheException {
        this.checkStatus();
        Cache cache = this;
        synchronized (cache) {
            this.memoryStore.removeAll();
            if (this.isDiskStore()) {
                this.diskStore.removeAll();
            }
        }
        this.registeredEventListeners.notifyRemoveAll(doNotNotifyCacheReplicators);
    }

    public synchronized void dispose() throws IllegalStateException {
        this.checkStatusNotDisposed();
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.disposeRegisteredCacheExtensions();
        this.registeredEventListeners.dispose();
        if (this.memoryStore != null) {
            this.memoryStore.dispose();
        }
        this.memoryStore = null;
        if (this.diskStore != null) {
            this.diskStore.dispose();
            this.diskStore = null;
        }
        this.changeStatus(Status.STATUS_SHUTDOWN);
    }

    private void initialiseRegisteredCacheExtensions() {
        for (int i = 0; i < this.registeredCacheExtensions.size(); ++i) {
            CacheExtension cacheExtension = (CacheExtension)this.registeredCacheExtensions.get(i);
            cacheExtension.init();
        }
    }

    private void disposeRegisteredCacheExtensions() {
        for (int i = 0; i < this.registeredCacheExtensions.size(); ++i) {
            CacheExtension cacheExtension = (CacheExtension)this.registeredCacheExtensions.get(i);
            cacheExtension.dispose();
        }
    }

    public CacheConfiguration getCacheConfiguration() {
        return this.configuration;
    }

    public final synchronized void flush() throws IllegalStateException, CacheException {
        this.checkStatus();
        try {
            this.memoryStore.flush();
            if (this.isDiskStore()) {
                this.diskStore.flush();
            }
        }
        catch (IOException e) {
            throw new CacheException("Unable to flush cache: " + this.configuration.getName() + ". Initial cause was " + e.getMessage(), e);
        }
    }

    public final synchronized int getSize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.getKeys().size();
    }

    public final synchronized long calculateInMemorySize() throws IllegalStateException, CacheException {
        this.checkStatus();
        return this.memoryStore.getSizeInBytes();
    }

    public final long getMemoryStoreSize() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore.getSize();
    }

    public final int getDiskStoreSize() throws IllegalStateException {
        this.checkStatus();
        if (this.isDiskStore()) {
            return this.diskStore.getSize();
        }
        return 0;
    }

    public final Status getStatus() {
        return this.status;
    }

    private void checkStatus() throws IllegalStateException {
        if (!this.status.equals(Status.STATUS_ALIVE)) {
            throw new IllegalStateException("The " + this.configuration.getName() + " Cache is not alive.");
        }
    }

    private void checkStatusNotDisposed() throws IllegalStateException {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            throw new IllegalStateException("The " + this.configuration.getName() + " Cache is disposed.");
        }
    }

    public final int getHitCount() {
        return (int)this.hitCount;
    }

    public final int getMemoryStoreHitCount() {
        return (int)this.memoryStoreHitCount;
    }

    public final int getDiskStoreHitCount() {
        return (int)this.diskStoreHitCount;
    }

    public final int getMissCountNotFound() {
        return (int)this.missCountNotFound;
    }

    public final int getMissCountExpired() {
        return (int)this.missCountExpired;
    }

    public final String getName() {
        return this.configuration.getName();
    }

    public final void setName(String name) throws IllegalArgumentException {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new IllegalStateException("Only unitialised caches can have their names set.");
        }
        this.configuration.setName(name);
    }

    public final long getTimeToIdleSeconds() {
        return this.configuration.getTimeToIdleSeconds();
    }

    public final long getTimeToLiveSeconds() {
        return this.configuration.getTimeToLiveSeconds();
    }

    public final boolean isEternal() {
        return this.configuration.isEternal();
    }

    public final boolean isOverflowToDisk() {
        return this.configuration.isOverflowToDisk();
    }

    public final int getMaxElementsInMemory() {
        return this.configuration.getMaxElementsInMemory();
    }

    public int getMaxElementsOnDisk() {
        return this.configuration.getMaxElementsOnDisk();
    }

    public final MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.configuration.getMemoryStoreEvictionPolicy();
    }

    public final boolean isDiskPersistent() {
        return this.configuration.isDiskPersistent();
    }

    public final long getDiskExpiryThreadIntervalSeconds() {
        return this.configuration.getDiskExpiryThreadIntervalSeconds();
    }

    public final String toString() {
        StringBuffer dump = new StringBuffer();
        dump.append("[").append(" name = ").append(this.configuration.getName()).append(" status = ").append(this.status).append(" eternal = ").append(this.configuration.isEternal()).append(" overflowToDisk = ").append(this.configuration.isOverflowToDisk()).append(" maxElementsInMemory = ").append(this.configuration.getMaxElementsInMemory()).append(" maxElementsOnDisk = ").append(this.configuration.getMaxElementsOnDisk()).append(" memoryStoreEvictionPolicy = ").append(this.configuration.getMemoryStoreEvictionPolicy()).append(" timeToLiveSeconds = ").append(this.configuration.getTimeToLiveSeconds()).append(" timeToIdleSeconds = ").append(this.configuration.getTimeToIdleSeconds()).append(" diskPersistent = ").append(this.configuration.isDiskPersistent()).append(" diskExpiryThreadIntervalSeconds = ").append(this.configuration.getDiskExpiryThreadIntervalSeconds()).append(this.registeredEventListeners).append(" hitCount = ").append(this.hitCount).append(" memoryStoreHitCount = ").append(this.memoryStoreHitCount).append(" diskStoreHitCount = ").append(this.diskStoreHitCount).append(" missCountNotFound = ").append(this.missCountNotFound).append(" missCountExpired = ").append(this.missCountExpired).append(" ]");
        return dump.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isExpired(Element element) throws IllegalStateException, NullPointerException {
        this.checkStatus();
        Element element2 = element;
        synchronized (element2) {
            return element.isExpired();
        }
    }

    public final Object clone() throws CloneNotSupportedException {
        if (this.memoryStore != null || this.diskStore != null) {
            throw new CloneNotSupportedException("Cannot clone an initialized cache.");
        }
        Cache copy = (Cache)super.clone();
        copy.configuration = (CacheConfiguration)this.configuration.clone();
        copy.guid = this.createGuid();
        RegisteredEventListeners registeredEventListenersFromCopy = copy.getCacheEventNotificationService();
        if (registeredEventListenersFromCopy == null || registeredEventListenersFromCopy.getCacheEventListeners().size() == 0) {
            copy.registeredEventListeners = new RegisteredEventListeners(copy);
        } else {
            copy.registeredEventListeners = new RegisteredEventListeners(copy);
            Set cacheEventListeners = this.registeredEventListeners.getCacheEventListeners();
            Iterator iterator = cacheEventListeners.iterator();
            while (iterator.hasNext()) {
                CacheEventListener cacheEventListener = (CacheEventListener)iterator.next();
                CacheEventListener cacheEventListenerClone = (CacheEventListener)cacheEventListener.clone();
                copy.registeredEventListeners.registerListener(cacheEventListenerClone);
            }
        }
        copy.registeredCacheExtensions = this.createNewCacheExtensionsList();
        for (int i = 0; i < this.registeredCacheExtensions.size(); ++i) {
            CacheExtension cacheExtension = (CacheExtension)this.registeredCacheExtensions.get(i);
            copy.registerCacheExtension(cacheExtension.clone(copy));
        }
        if (this.bootstrapCacheLoader != null) {
            BootstrapCacheLoader bootstrapCacheLoaderClone = (BootstrapCacheLoader)this.bootstrapCacheLoader.clone();
            copy.setBootstrapCacheLoader(bootstrapCacheLoaderClone);
        }
        return copy;
    }

    final Store getDiskStore() throws IllegalStateException {
        this.checkStatus();
        return this.diskStore;
    }

    final MemoryStore getMemoryStore() throws IllegalStateException {
        this.checkStatus();
        return this.memoryStore;
    }

    public final RegisteredEventListeners getCacheEventNotificationService() {
        return this.registeredEventListeners;
    }

    public final boolean isElementInMemory(Serializable key) {
        return this.isElementInMemory((Object)key);
    }

    public final boolean isElementInMemory(Object key) {
        return this.memoryStore.containsKey(key);
    }

    public final boolean isElementOnDisk(Serializable key) {
        return this.isElementOnDisk((Object)key);
    }

    public final boolean isElementOnDisk(Object key) {
        if (!(key instanceof Serializable)) {
            return false;
        }
        Serializable serializableKey = (Serializable)key;
        if (this.isDiskStore()) {
            return this.diskStore != null && this.diskStore.containsKey(serializableKey);
        }
        return false;
    }

    public final String getGuid() {
        return this.guid;
    }

    public final CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public synchronized void clearStatistics() throws IllegalStateException {
        this.checkStatus();
        this.hitCount = 0L;
        this.memoryStoreHitCount = 0L;
        this.diskStoreHitCount = 0L;
        this.missCountExpired = 0L;
        this.missCountNotFound = 0L;
        this.totalGetTime = 0L;
        this.registeredEventListeners.clearCounters();
    }

    public int getStatisticsAccuracy() {
        return this.statisticsAccuracy;
    }

    public void setStatisticsAccuracy(int statisticsAccuracy) {
        this.statisticsAccuracy = statisticsAccuracy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evictExpiredElements() {
        Object[] keys = this.memoryStore.getKeyArray();
        Cache cache = this;
        synchronized (cache) {
            for (int i = 0; i < keys.length; ++i) {
                Object key = keys[i];
                this.searchInMemoryStore(key, false);
            }
        }
        if (this.isDiskStore()) {
            this.diskStore.expireElements();
        }
    }

    public boolean isKeyInCache(Object key) {
        return this.isElementInMemory(key) || this.isElementOnDisk(key);
    }

    public boolean isValueInCache(Object value) {
        boolean isSerializable = value instanceof Serializable;
        List<Object> keys = isSerializable ? this.getKeys() : Arrays.asList(this.memoryStore.getKeyArray());
        for (int i = 0; i < keys.size(); ++i) {
            Serializable elementValue;
            Object key = keys.get(i);
            Element element = this.get(key);
            if (element == null || !((elementValue = element.getValue()) == null ? value == null : elementValue.equals(value))) continue;
            return true;
        }
        return false;
    }

    public Statistics getStatistics() throws IllegalStateException {
        int size = 0;
        if (this.statisticsAccuracy == 1) {
            size = this.getSize();
        } else if (this.statisticsAccuracy == 2) {
            size = this.getKeysWithExpiryCheck().size();
        } else if (this.statisticsAccuracy == 0) {
            size = this.getKeysNoDuplicateCheck().size();
        }
        return new Statistics(this, this.statisticsAccuracy, this.hitCount, this.diskStoreHitCount, this.memoryStoreHitCount, this.missCountExpired + this.missCountNotFound, size, this.getAverageGetTime(), this.registeredEventListeners.getElementsEvictedCounter());
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    public BootstrapCacheLoader getBootstrapCacheLoader() {
        return this.bootstrapCacheLoader;
    }

    public void setBootstrapCacheLoader(BootstrapCacheLoader bootstrapCacheLoader) throws CacheException {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new CacheException("A bootstrap cache loader can only be set before the cache is initialized. " + this.configuration.getName());
        }
        this.bootstrapCacheLoader = bootstrapCacheLoader;
    }

    public void setDiskStorePath(String diskStorePath) throws CacheException {
        if (!this.status.equals(Status.STATUS_UNINITIALISED)) {
            throw new CacheException("A DiskStore path can only be set before the cache is initialized. " + this.configuration.getName());
        }
        this.diskStorePath = diskStorePath;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Ehcache)) {
            return false;
        }
        Ehcache other = (Ehcache)object;
        return this.guid.equals(other.getGuid());
    }

    public int hashCode() {
        return this.guid.hashCode();
    }

    private String createGuid() {
        return localhost + "-" + new UID();
    }

    public void registerCacheExtension(CacheExtension cacheExtension) {
        this.registeredCacheExtensions.add(cacheExtension);
    }

    public void unregisterCacheExtension(CacheExtension cacheExtension) {
        this.registeredCacheExtensions.remove(cacheExtension);
    }

    private List createNewCacheExtensionsList() {
        return Collections.synchronizedList(new ArrayList());
    }

    public float getAverageGetTime() {
        if (this.hitCount == 0L) {
            return 0.0f;
        }
        return (float)this.totalGetTime / (float)this.hitCount;
    }

    public void setCacheExceptionHandler(CacheExceptionHandler cacheExceptionHandler) {
        this.cacheExceptionHandler = cacheExceptionHandler;
    }

    public CacheExceptionHandler getCacheExceptionHandler() {
        return this.cacheExceptionHandler;
    }

    public void setCacheLoader(CacheLoader cacheLoader) {
        this.cacheLoader = cacheLoader;
    }

    public CacheLoader getCacheLoader() {
        return this.cacheLoader;
    }

    Future asynchronousLoad(final Object key, final CacheLoader specificLoader, final Object argument) {
        Future future = this.getExecutorService().submit(new Runnable(){

            public void run() throws CacheException {
                try {
                    boolean existsOnRun = Cache.this.isKeyInCache(key);
                    if (!existsOnRun) {
                        Object value;
                        if (specificLoader == null) {
                            if (Cache.this.cacheLoader == null) {
                                return;
                            }
                            value = argument == null ? Cache.this.cacheLoader.load(key) : Cache.this.cacheLoader.load(key, argument);
                        } else {
                            value = argument == null ? specificLoader.load(key) : specificLoader.load(key, argument);
                        }
                        Cache.this.put(new Element(key, value), false);
                    }
                }
                catch (Throwable e) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Problem during load. Load will not be completed. Cause was " + e.getCause()), e);
                    }
                    throw new CacheException(e);
                }
            }
        });
        return future;
    }

    Future asynchronousLoadAll(final Collection keys, final Object argument) {
        Future future = this.getExecutorService().submit(new Runnable(){

            public void run() {
                block4: {
                    try {
                        ArrayList nonLoadedKeys = new ArrayList(keys.size());
                        Iterator iterator = keys.iterator();
                        while (iterator.hasNext()) {
                            Object key = iterator.next();
                            if (Cache.this.isKeyInCache(key)) continue;
                            nonLoadedKeys.add(key);
                        }
                        Map map = argument == null ? Cache.this.cacheLoader.loadAll(nonLoadedKeys) : Cache.this.cacheLoader.loadAll(nonLoadedKeys, argument);
                        Iterator iterator2 = map.keySet().iterator();
                        while (iterator2.hasNext()) {
                            Object key = iterator2.next();
                            Cache.this.put(new Element(key, map.get(key)));
                        }
                    }
                    catch (Throwable e) {
                        if (!LOG.isDebugEnabled()) break block4;
                        LOG.debug((Object)("Problem during load. Load will not be completed. Cause was " + e.getCause()), e);
                    }
                }
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadPoolExecutor getExecutorService() {
        if (this.executorService == null) {
            Cache cache = this;
            synchronized (cache) {
                this.executorService = new ThreadPoolExecutor(0, 10, 60000L, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue());
            }
        }
        return this.executorService;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            LOG.error((Object)("Unable to set localhost. This prevents creation of a GUID. Cause was: " + e.getMessage()), (Throwable)e);
        }
    }

    class KeyedFuture {
        private Object key;
        private Future future;

        public KeyedFuture(Object key, Future future) {
            this.key = key;
            this.future = future;
        }
    }
}

