/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.ResultsProviderFarm;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelListener;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelRowEvent;
import org.nuxeo.ecm.platform.ui.web.pagination.ResultsProviderFarmUserException;
import org.nuxeo.ecm.platform.ui.web.util.DocumentsListsUtils;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.action.DeleteActions;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.edit.lock.LockActions;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;
import org.nuxeo.ecm.webapp.querymodel.QueryModelActions;
import org.nuxeo.ecm.webapp.search.SearchActions;
import org.nuxeo.ecm.webapp.trashManagement.TrashManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="deleteActions")
@Scope(value=ScopeType.EVENT)
@Install(precedence=10)
public class DeleteActionsBean
extends InputController
implements DeleteActions,
Serializable,
SelectDataModelListener,
ResultsProviderFarm {
    public static final String DELETED_CHILDREN_BY_COREAPI = "CURRENT_DOC_DELETED_CHILDREN";
    protected static final String BOARD_USER_DELETED = "USER_DELETED_DOCUMENTS";
    private static final long serialVersionUID = 9860854328986L;
    private static final Log log = LogFactory.getLog(DeleteActionsBean.class);
    private static final String DELETE_OUTCOME = "after_delete";
    protected static final String DELETE_TRANSITION = "delete";
    protected static final String UNDELETE_TRANSITION = "undelete";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected RepositoryLocation currentServerLocation;
    @In(create=true)
    private transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    private transient TrashManager trashManager;
    @In(create=true)
    private transient LockActions lockActions;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient QueryModelActions queryModelActions;
    @In(create=true)
    private transient SearchActions searchActions;
    @Out(required=false)
    @Deprecated
    private PagedDocumentsProvider resultsProvider;
    private DocumentModelList currentDocumentChildren;
    @In
    private transient Principal currentUser;
    private Boolean searchDeletedDocuments;

    @Override
    public String purgeSelection() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_TRASH")) {
            return this.purgeSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String purgeSelection(List<DocumentModel> docsToPurge) throws ClientException {
        if (null != docsToPurge) {
            List<DocumentModel> docsThatCanBeDeleted = this.filterDeleteListAccordingToPerms(docsToPurge);
            Collections.sort(docsThatCanBeDeleted, new PathComparator());
            LinkedList<DocumentModel> rootDocsToDelete = new LinkedList<DocumentModel>();
            Path previousPath = null;
            for (DocumentModel doc : docsThatCanBeDeleted) {
                if (previousPath != null && previousPath.isPrefixOf(doc.getPath())) continue;
                rootDocsToDelete.add(doc);
                previousPath = doc.getPath();
            }
            List references = DocumentsListsUtils.getDocRefs(rootDocsToDelete);
            HashSet<Path> paths = new HashSet<Path>();
            for (DocumentModel doc : rootDocsToDelete) {
                paths.add(doc.getPath());
            }
            HashSet parentsRefs = new HashSet();
            parentsRefs.addAll(DocumentsListsUtils.getParentRefFromDocumentList(rootDocsToDelete));
            DocumentModel targetContext = this.navigationContext.getCurrentDocument();
            while (DeleteActionsBean.underOneOf(targetContext.getPath(), paths)) {
                targetContext = this.documentManager.getParentDocument(targetContext.getRef());
            }
            this.documentsListsManager.removeFromAllLists(docsThatCanBeDeleted);
            this.documentManager.removeDocuments(references.toArray(new DocumentRef[references.size()]));
            this.documentManager.save();
            this.navigationContext.setCurrentDocument(targetContext);
            for (DocumentRef parentRef : parentsRefs) {
                DocumentModel parent = this.documentManager.getDocument(parentRef);
                if (parent == null) continue;
                Events.instance().raiseEvent("documentChildrenChanged", new Object[]{parent});
            }
            Object[] params = new Object[]{references.size()};
            FacesMessage message = FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("#0 " + (String)this.resourcesAccessor.getMessages().get("n_deleted_docs")), (Object[])params);
            this.facesMessages.add(message);
            log.debug((Object)"documents deleted...");
        } else {
            log.debug((Object)"nothing to delete...");
        }
        return this.computeOutcome(DELETE_OUTCOME);
    }

    private static boolean underOneOf(Path testedPath, Set<Path> paths) {
        for (Path path : paths) {
            if (!path.isPrefixOf(testedPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getCanDeleteItem(DocumentModel container) throws ClientException {
        return this.documentManager != null && container != null && this.documentManager.hasPermission(container.getRef(), "RemoveChildren");
    }

    @Override
    public boolean getCanDelete() {
        List docsToDelete = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (docsToDelete == null || docsToDelete.isEmpty()) {
            return false;
        }
        return this.checkDeletePermOnParents(docsToDelete);
    }

    @Override
    public boolean getCanDeleteSections() {
        List docsToDelete = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
        if (docsToDelete == null || docsToDelete.isEmpty()) {
            return false;
        }
        ArrayList<DocumentModel> realDocsToDelete = new ArrayList<DocumentModel>();
        for (DocumentModel doc : docsToDelete) {
            if (doc.isProxy()) continue;
            realDocsToDelete.add(doc);
        }
        if (realDocsToDelete.isEmpty()) {
            return false;
        }
        return this.checkDeletePermOnParents(realDocsToDelete);
    }

    @Override
    public boolean getCanPurge() throws ClientException {
        List docsToDelete = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH");
        if (docsToDelete == null || docsToDelete.isEmpty()) {
            return false;
        }
        for (DocumentModel doc : docsToDelete) {
            if ("deleted".equals(doc.getCurrentLifeCycleState())) continue;
            return false;
        }
        return this.checkDeletePermOnParents(docsToDelete);
    }

    @Override
    public boolean checkDeletePermOnParents(List<DocumentModel> docsToDelete) {
        List parentRefs = DocumentsListsUtils.getParentRefFromDocumentList(docsToDelete);
        for (DocumentRef parentRef : parentRefs) {
            try {
                if (!this.documentManager.hasPermission(parentRef, "RemoveChildren")) continue;
                return true;
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
        }
        return false;
    }

    private List<DocumentModel> filterDeleteListAccordingToPermsOnParents(List<DocumentModel> docsToDelete) throws ClientException {
        ArrayList<DocumentModel> docsThatCanBeDeleted = new ArrayList<DocumentModel>();
        List parentRefs = DocumentsListsUtils.getParentRefFromDocumentList(docsToDelete);
        for (DocumentRef parentRef : parentRefs) {
            if (!this.documentManager.hasPermission(parentRef, "RemoveChildren")) continue;
            for (DocumentModel doc : docsToDelete) {
                if (!doc.getParentRef().equals(parentRef)) continue;
                docsThatCanBeDeleted.add(doc);
            }
        }
        return docsThatCanBeDeleted;
    }

    private List<DocumentModel> filterDeleteListAccordingToPerms(List<DocumentModel> docsToDelete) throws ClientException {
        List<DocumentModel> docsThatCanBeDeletedOnParent = this.filterDeleteListAccordingToPermsOnParents(docsToDelete);
        ArrayList<DocumentModel> docsThatCanBeDeleted = new ArrayList<DocumentModel>();
        int forbiddenDocs = docsToDelete.size() - docsThatCanBeDeletedOnParent.size();
        int lockedDocs = 0;
        for (DocumentModel docToDelete : docsThatCanBeDeletedOnParent) {
            if (this.documentManager.hasPermission(docToDelete.getRef(), "Remove")) {
                if (docToDelete.isLocked()) {
                    String locker = this.lockActions.getLockDetails(docToDelete).get("document.locker");
                    if (this.currentUser.getName().equals(locker)) {
                        docsThatCanBeDeleted.add(docToDelete);
                        continue;
                    }
                    ++lockedDocs;
                    continue;
                }
                docsThatCanBeDeleted.add(docToDelete);
                continue;
            }
            ++forbiddenDocs;
        }
        if (lockedDocs > 0) {
            Object[] params = new Object[]{lockedDocs};
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, "#0 " + (String)this.resourcesAccessor.getMessages().get("n_locked_docs_can_not_delete"), params);
        }
        if (forbiddenDocs > 0) {
            Object[] params2 = new Object[]{forbiddenDocs};
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, "#0 " + (String)this.resourcesAccessor.getMessages().get("n_forbidden_docs_can_not_delete"), params2);
        }
        return docsThatCanBeDeleted;
    }

    @Override
    public String deleteSelection() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            return this.deleteSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String deleteSelectionSections() throws ClientException {
        List docsToDelete = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_SECTIONS");
        if (docsToDelete == null || docsToDelete.isEmpty()) {
            return null;
        }
        boolean selectionContainsProxy = false;
        ArrayList<DocumentModel> nonProxyDocsToDelete = new ArrayList<DocumentModel>();
        for (DocumentModel doc : docsToDelete) {
            if (doc.isProxy()) {
                selectionContainsProxy = true;
                continue;
            }
            nonProxyDocsToDelete.add(doc);
        }
        if (selectionContainsProxy) {
            FacesMessage message = FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_WARN, (String)"can_not_delete_proxies", null);
            this.facesMessages.add(message);
        }
        return this.deleteSelection(nonProxyDocsToDelete);
    }

    @Override
    public String deleteSelection(List<DocumentModel> docsToDelete) throws ClientException {
        if (null != docsToDelete) {
            List<DocumentModel> docsThatCanBeDeleted = this.filterDeleteListAccordingToPerms(docsToDelete);
            Collections.sort(docsThatCanBeDeleted, new PathComparator());
            LinkedList<DocumentModel> rootDocsToDelete = new LinkedList<DocumentModel>();
            Path previousPath = null;
            for (DocumentModel doc : docsThatCanBeDeleted) {
                if (previousPath != null && previousPath.isPrefixOf(doc.getPath())) continue;
                rootDocsToDelete.add(doc);
                previousPath = doc.getPath();
            }
            List references = DocumentsListsUtils.getDocRefs(rootDocsToDelete);
            HashSet<Path> paths = new HashSet<Path>();
            for (DocumentModel doc : rootDocsToDelete) {
                paths.add(doc.getPath());
            }
            HashSet parentsRefs = new HashSet();
            parentsRefs.addAll(DocumentsListsUtils.getParentRefFromDocumentList(rootDocsToDelete));
            DocumentModel targetContext = this.navigationContext.getCurrentDocument();
            while (DeleteActionsBean.underOneOf(targetContext.getPath(), paths)) {
                targetContext = this.documentManager.getParentDocument(targetContext.getRef());
            }
            this.documentsListsManager.removeFromAllLists(docsThatCanBeDeleted);
            if (this.trashManager.isTrashManagementEnabled()) {
                this.moveDocumentsToTrash(docsThatCanBeDeleted);
            } else {
                this.documentManager.removeDocuments(references.toArray(new DocumentRef[references.size()]));
            }
            this.documentManager.save();
            this.navigationContext.setCurrentDocument(targetContext);
            for (DocumentRef parentRef : parentsRefs) {
                DocumentModel parent = this.documentManager.getDocument(parentRef);
                if (parent == null) continue;
                Events.instance().raiseEvent("documentChildrenChanged", new Object[]{parent});
            }
            Object[] params = new Object[]{references.size()};
            FacesMessage message = FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("#0 " + (String)this.resourcesAccessor.getMessages().get("n_deleted_docs")), (Object[])params);
            this.facesMessages.add(message);
            log.debug((Object)"documents deleted...");
        } else {
            log.debug((Object)"nothing to delete...");
        }
        return this.computeOutcome(DELETE_OUTCOME);
    }

    protected void moveDocumentsToTrash(List<DocumentModel> docsThatCanBeDeleted) throws ClientException {
        for (DocumentModel docModel : docsThatCanBeDeleted) {
            DocumentModel document = this.documentManager.getDocument(docModel.getRef());
            if (document.getAllowedStateTransitions().contains(DELETE_TRANSITION)) {
                document.followTransition(DELETE_TRANSITION);
                continue;
            }
            log.warn((Object)("Document " + document.getId() + " of type " + document.getType() + " in state " + document.getCurrentLifeCycleState() + " does not support transition " + DELETE_TRANSITION + ", it will be deleted immediately"));
            this.documentManager.removeDocument(document.getRef());
        }
    }

    @Override
    public String undeleteSelection() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_TRASH")) {
            return this.undeleteSelection(this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH"));
        }
        log.debug((Object)"No documents selection in context to process delete on...");
        return null;
    }

    @Override
    public String undeleteSelection(List<DocumentModel> docsToUndelete) throws ClientException {
        if (null != docsToUndelete) {
            List<DocumentModel> docsThatCanBeUndeleted = this.filterDeleteListAccordingToPerms(docsToUndelete);
            Collections.sort(docsThatCanBeUndeleted, new PathComparator());
            LinkedList<DocumentModel> rootDocsToDelete = new LinkedList<DocumentModel>();
            Path previousPath = null;
            for (DocumentModel doc : docsToUndelete) {
                if (previousPath != null && previousPath.isPrefixOf(doc.getPath())) continue;
                rootDocsToDelete.add(doc);
                previousPath = doc.getPath();
            }
            List references = DocumentsListsUtils.getDocRefs(rootDocsToDelete);
            HashSet<Path> paths = new HashSet<Path>();
            for (DocumentModel doc : rootDocsToDelete) {
                paths.add(doc.getPath());
            }
            HashSet parentsRefs = new HashSet();
            parentsRefs.addAll(DocumentsListsUtils.getParentRefFromDocumentList(rootDocsToDelete));
            DocumentModel targetContext = this.navigationContext.getCurrentDocument();
            while (DeleteActionsBean.underOneOf(targetContext.getPath(), paths)) {
                targetContext = this.documentManager.getParentDocument(targetContext.getRef());
            }
            this.documentsListsManager.removeFromAllLists(docsThatCanBeUndeleted);
            this.undeleteDocumentsFromTrash(docsThatCanBeUndeleted);
            for (DocumentModel document : docsThatCanBeUndeleted) {
                DeleteActionsBean.undeleteDocument(this.documentManager.getParentDocuments(document.getRef()));
            }
            this.documentManager.save();
            this.navigationContext.setCurrentDocument(targetContext);
            for (DocumentRef parentRef : parentsRefs) {
                List parents = this.documentManager.getParentDocuments(parentRef);
                for (DocumentModel parent : parents) {
                    if (parent == null) continue;
                    Events.instance().raiseEvent("documentChildrenChanged", new Object[]{parent});
                }
            }
            Object[] params = new Object[]{references.size()};
            FacesMessage message = FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("#0 " + (String)this.resourcesAccessor.getMessages().get("n_undeleted_docs")), (Object[])params);
            this.facesMessages.add(message);
            log.debug((Object)"documents undeleted...");
        } else {
            log.debug((Object)"nothing to undelete...");
        }
        return this.computeOutcome(DELETE_OUTCOME);
    }

    @Override
    public boolean isTrashManagementEnabled() {
        return this.trashManager.isTrashManagementEnabled();
    }

    protected void undeleteDocumentsFromTrash(List<DocumentModel> docsToBeUndeleted) throws ClientException {
        for (DocumentModel docModel : docsToBeUndeleted) {
            DocumentModel document = this.documentManager.getDocument(docModel.getRef());
            if (document.getAllowedStateTransitions().contains(UNDELETE_TRANSITION)) {
                document.followTransition(UNDELETE_TRANSITION);
                continue;
            }
            throw new ClientException("Impossible to move document=" + document.getPathAsString() + " Life Cycle is not available 1");
        }
    }

    private static void undeleteDocument(List<DocumentModel> docsToBeUndeleted) throws ClientException {
        for (DocumentModel document : docsToBeUndeleted) {
            if (document.getAllowedStateTransitions().contains(UNDELETE_TRANSITION)) {
                document.followTransition(UNDELETE_TRANSITION);
                continue;
            }
            log.debug((Object)"No undelete transition defined....");
        }
    }

    @Override
    public SelectDataModel getDeletedChildrenSelectModel() throws ClientException {
        DocumentModelList documents = this.getCurrentDocumentDeletedChildrenPage();
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_TRASH");
        SelectDataModelImpl model = new SelectDataModelImpl("CHILDREN_DOCUMENT_LIST", (List)documents, selectedDocuments);
        model.addSelectModelListener((SelectDataModelListener)this);
        return model;
    }

    @Override
    public DocumentModelList getCurrentDocumentDeletedChildrenPage() throws ClientException {
        if (this.documentManager == null) {
            log.error((Object)"documentManager not initialized");
            return new DocumentModelListImpl();
        }
        try {
            ResultsProvidersCache resultsProvidersCache = (ResultsProvidersCache)Component.getInstance((String)"resultsProvidersCache");
            this.resultsProvider = resultsProvidersCache.get(DELETED_CHILDREN_BY_COREAPI);
            this.currentDocumentChildren = this.resultsProvider.getCurrentPage();
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
        return this.currentDocumentChildren;
    }

    public void processSelectRowEvent(SelectDataModelRowEvent event) {
        Boolean selection = event.getSelected();
        DocumentModel data = (DocumentModel)event.getRowData();
        if (selection.booleanValue()) {
            this.documentsListsManager.addToWorkingList("CURRENT_SELECTION_TRASH", data);
        } else {
            this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION_TRASH", data);
        }
    }

    public List<Action> getActionsForTrashSelection() {
        return this.webActions.getUnfiltredActionsList("CURRENT_SELECTION_TRASH_LIST");
    }

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    public PagedDocumentsProvider getResultsProvider(String name) throws ClientException, ResultsProviderFarmUserException {
        return this.getResultsProvider(name, null);
    }

    public PagedDocumentsProvider getResultsProvider(String name, SortInfo sortInfo) throws ClientException, ResultsProviderFarmUserException {
        PagedDocumentsProvider provider = null;
        if (BOARD_USER_DELETED.equals(name)) {
            Object[] params = new Object[]{this.currentUser.getName()};
            try {
                provider = this.getQmDocuments(name, params, sortInfo);
            }
            catch (Exception e) {
                log.error((Object)"sorted query failed");
                log.debug((Object)e);
                log.error((Object)"retrying without sort parameters");
                provider = this.getQmDocuments(name, params, null);
            }
        } else if (DELETED_CHILDREN_BY_COREAPI.equals(name)) {
            provider = this.getResultsProviderForDeletedDocs(name, sortInfo);
        }
        provider.setName(name);
        return provider;
    }

    private PagedDocumentsProvider getResultsProviderForDeletedDocs(String name, SortInfo sortInfo) throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (DELETED_CHILDREN_BY_COREAPI.equals(name)) {
            PagedDocumentsProvider provider = this.getChildrenResultsProviderQMPattern(name, currentDoc, sortInfo);
            provider.setName(name);
            return provider;
        }
        throw new ClientException("Unknown provider: " + name);
    }

    protected PagedDocumentsProvider getQmDocuments(String qmName, Object[] params, SortInfo sortInfo) throws ClientException {
        return this.queryModelActions.get(qmName).getResultsProvider(this.documentManager, params, sortInfo);
    }

    private PagedDocumentsProvider getChildrenResultsProviderQMPattern(String queryModelName, DocumentModel parent, SortInfo sortInfo) throws ClientException {
        String parentId = parent.getId();
        Object[] params = new Object[]{parentId};
        return this.getResultsProvider(queryModelName, params, sortInfo);
    }

    private PagedDocumentsProvider getResultsProvider(String qmName, Object[] params, SortInfo sortInfo) throws ClientException {
        QueryModel qm = this.queryModelActions.get(qmName);
        return qm.getResultsProvider(this.documentManager, params, sortInfo);
    }

    @Override
    public Boolean getSearchDeletedDocuments() {
        return this.searchDeletedDocuments;
    }

    @Override
    public void setSearchDeletedDocuments(Boolean searchDeletedDocuments) throws ClientException {
        this.searchDeletedDocuments = searchDeletedDocuments;
        String[] states = null;
        states = searchDeletedDocuments != false ? new String[]{"project", "approved", "obsolete", "deleted"} : new String[]{"project", "approved", "obsolete"};
        this.searchActions.getDocumentModel().setProperty("advanced_search", "currentLifeCycleStates", (Object)states);
    }

    @Override
    public void restoreCurrentDocument() throws ClientException {
        ArrayList<DocumentModel> doc = new ArrayList<DocumentModel>();
        doc.add(this.navigationContext.getCurrentDocument());
        this.undeleteSelection(doc);
    }

    @Override
    public boolean getCanRestoreCurrentDoc() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (currentDoc != null) {
            return "deleted".equals(currentDoc.getCurrentLifeCycleState());
        }
        log.warn((Object)"Null currentDocument in navigationContext");
        return false;
    }

    @Observer(value={"folderishDocumentSelectionChanged"})
    @BypassInterceptors
    public void resetProviderCache() {
        ResultsProvidersCache resultsProvidersCache = (ResultsProvidersCache)Component.getInstance((String)"resultsProvidersCache");
        resultsProvidersCache.invalidate(DELETED_CHILDREN_BY_COREAPI);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PathComparator
    implements Comparator<DocumentModel>,
    Serializable {
        private static final long serialVersionUID = -6449747704324789701L;

        private PathComparator() {
        }

        @Override
        public int compare(DocumentModel o1, DocumentModel o2) {
            return o1.getPathAsString().compareTo(o2.getPathAsString());
        }
    }
}

