/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;

@Name(value="siteActions")
@Scope(value=ScopeType.STATELESS)
public class SiteActionsBean {
    private static final Log log = LogFactory.getLog(SiteActionsBean.class);

    public void validateName(FacesContext context, UIComponent component, Object value) {
        Map attributes = component.getAttributes();
        String wcId = (String)attributes.get("webContainerId");
        if (wcId == null) {
            log.debug((Object)"Cannot validate name: input wcId not found");
            return;
        }
        UIInput wcComp = (UIInput)component.findComponent(wcId);
        if (wcComp == null) {
            log.debug((Object)"Cannot validate name: input wcId not found second time");
            return;
        }
        Boolean propValue = (Boolean)wcComp.getLocalValue();
        boolean isWC = false;
        if (propValue != null) {
            isWC = propValue;
        }
        if (!isWC) {
            return;
        }
        String nameId = (String)attributes.get("nameId");
        if (nameId == null) {
            log.error((Object)"Cannot validate name: input id(s) not found");
            return;
        }
        UIInput nameComp = (UIInput)component.findComponent(nameId);
        if (nameComp == null) {
            log.error((Object)"Cannot validate name: input(s) not found second time");
            return;
        }
        Object nameObj = nameComp.getLocalValue();
        if (nameObj == null || StringUtils.isBlank((String)nameObj.toString())) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.error.need.name.webcontainer"), null);
            throw new ValidatorException(message);
        }
    }
}

