/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.bulkupdate;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.FacesMessage;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.nuxeo.common.utils.ArrayUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.types.FieldWidget;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.bulkupdate.FictiveDocumentModel;
import org.nuxeo.ecm.webapp.bulkupdate.MassEditAction;
import org.nuxeo.ecm.webapp.clipboard.ClipboardActions;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.ecm.webapp.versioning.DocumentVersioning;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="massEditActions")
@Scope(value=ScopeType.CONVERSATION)
public class MassEditActionsBean
extends InputController
implements MassEditAction,
Serializable {
    public static final String NAVIGATION_PREVIEW = "mass_edit_confirm";
    public static final String NAVIGATION_MASS_EDIT = "mass_edit";
    private static final long serialVersionUID = 76543986285636L;
    private static final Log log = LogFactory.getLog(MassEditActionsBean.class);
    private static final String SELECT_ITEM_ID_EMPTY = "SELECT_ITEM_ID_EMPTY";
    private static final String SELECT_ITEM_ID_ALL = "SELECT_ITEM_ID_ALL";
    private static final String RB_KEY_TEXT_EMPTY = "label.bulkedit.cbvalue.EMPTY";
    private static final String RB_KEY_TEXT_ALL = "label.bulkedit.cbvalue.ALL";
    protected Map<String, Boolean> chainSelectMap;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient ClipboardActions clipboardActions;
    @In(create=true)
    protected transient DocumentVersioning documentVersioning;
    FictiveDocumentModel fictiveDocumentModel;
    DocumentModel changeCheckboxes;
    DocumentModel currentFieldValues;
    DocumentModel docModelExistingSelect;
    DocumentModel docModelExistingSelectVerbose;
    @DataModelSelection
    private DocumentModel selectedDM;
    private List<DocumentModel> docsList;
    private Map<String, Set<String>> changingFields;
    private List<DocumentModel> changingDocuments;
    private List<DocumentModel> unchangingDocuments;
    private boolean removeFromList = true;

    @Override
    @Begin(nested=true)
    public String putSelectionInWorkList() throws ClientException {
        String logPrefix = "<putSelectionInWorkList> ";
        if (this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            log.debug((Object)"<putSelectionInWorkList> No selectable Documents in context for mass edition.");
            return null;
        }
        List selectedDocs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        this.setDocumentsList(selectedDocs);
        log.debug((Object)"<putSelectionInWorkList> add to worklist processed...");
        return NAVIGATION_MASS_EDIT;
    }

    @Factory(value="fictiveDocumentModel", scope=ScopeType.EVENT)
    public DocumentModel getFictiveDocumentModel() {
        return this.fictiveDocumentModel;
    }

    @Factory(value="docModelExistingSelect", scope=ScopeType.EVENT)
    public DocumentModel getDocModelExistingSelect() {
        return this.docModelExistingSelect;
    }

    @Factory(value="changeCheckboxes", scope=ScopeType.EVENT)
    public DocumentModel getChangeCheckboxes() {
        return this.changeCheckboxes;
    }

    @Factory(value="currentFieldValues", scope=ScopeType.EVENT)
    public DocumentModel getCurrentFieldValues() {
        return this.currentFieldValues;
    }

    @Factory(value="docModelExistingSelectVerbose", scope=ScopeType.EVENT)
    public DocumentModel getDocModelExistingSelectVerbose() {
        return this.docModelExistingSelectVerbose;
    }

    @Override
    @DataModel
    public List<DocumentModel> getDocumentsList() {
        return this.docsList;
    }

    @Override
    public void setDocumentsList(List<DocumentModel> docsList) throws ClientException {
        String logPrefix = "<setDocumentsList> ";
        log.debug((Object)("<setDocumentsList> setting " + docsList.size() + " documents."));
        this.docsList = new ArrayList<DocumentModel>();
        for (DocumentModel documentModel : docsList) {
            DocumentRef docRef = documentModel.getRef();
            if (docRef == null) {
                log.error((Object)("null DocumentRef for: " + documentModel));
            }
            DocumentModel realDocModel = this.documentManager.getDocument(docRef);
            this.docsList.add(realDocModel);
        }
        this.fictiveDocumentModel = new FictiveDocumentModel();
        String[] schemas = MassEditActionsBean.getCommonSchemas(docsList);
        this.fictiveDocumentModel.registerSchemas(schemas);
        this.changeCheckboxes = new FictiveDocumentModel();
        this.currentFieldValues = new FictiveDocumentModel();
        this.docModelExistingSelect = new FictiveDocumentModel();
        this.docModelExistingSelectVerbose = new FictiveDocumentModel();
        this.changingDocuments = new ArrayList<DocumentModel>();
        this.unchangingDocuments = new ArrayList<DocumentModel>();
    }

    @Override
    public FieldWidget[] getCommonLayout() throws ClientException {
        String logPrefix = "<getCommonLayout> ";
        if (this.docsList == null) {
            log.debug((Object)"<getCommonLayout> docsList is null");
            return new FieldWidget[0];
        }
        return this.getCommonWidgets(this.docsList);
    }

    @Override
    public FieldWidget[] getChangeLayout() throws ClientException {
        FieldWidget[] commonWidgets = this.getCommonLayout();
        if (commonWidgets.length == 0) {
            return commonWidgets;
        }
        HashMap checkboxes = new HashMap();
        ArrayList<FieldWidget> filteredWidgetsList = new ArrayList<FieldWidget>();
        for (FieldWidget widget : commonWidgets) {
            String jsfComp = widget.getJsfComponent();
            if (jsfComp.equals("t:inputFileUpload")) continue;
            String schemaName = widget.getSchemaName();
            String fieldName = widget.getFieldName();
            this.addExistingValues(schemaName, fieldName);
            filteredWidgetsList.add(widget);
        }
        FieldWidget[] filteredWidgets = new FieldWidget[filteredWidgetsList.size()];
        filteredWidgets = filteredWidgetsList.toArray(filteredWidgets);
        if (this.changeCheckboxes != null) {
            for (FieldWidget fw : filteredWidgetsList) {
                this.changeCheckboxes.setProperty(fw.getSchemaName(), fw.getFieldName(), (Object)false);
            }
        }
        return filteredWidgets;
    }

    @Override
    public boolean getMapFlag(String key) {
        return this.chainSelectMap.get(key);
    }

    @Override
    public FieldWidget[] getPreviewLayout() throws ClientException {
        FieldWidget[] commonWidgets = this.getCommonLayout();
        ArrayList<FieldWidget> filteredWidgetsList = new ArrayList<FieldWidget>();
        for (FieldWidget widget : commonWidgets) {
            String schemaName = widget.getSchemaName();
            String fieldName = widget.getFieldName();
            Set<String> props = this.changingFields.get(schemaName);
            if (props == null || !props.contains(fieldName)) continue;
            filteredWidgetsList.add(widget);
        }
        FieldWidget[] filteredWidgets = new FieldWidget[filteredWidgetsList.size()];
        filteredWidgets = filteredWidgetsList.toArray(filteredWidgets);
        return filteredWidgets;
    }

    @Override
    public List<DocumentModel> getChangingDocuments() {
        return this.changingDocuments;
    }

    @Override
    public List<DocumentModel> getUnchangingDocuments() {
        return this.unchangingDocuments;
    }

    private void addExistingValues(String schemaName, String fieldName) {
        ArrayList<SelectItem> existingValues = new ArrayList<SelectItem>();
        String text_ALL = (String)this.resourcesAccessor.getMessages().get(RB_KEY_TEXT_ALL);
        SelectItem itemAll = new SelectItem((Object)SELECT_ITEM_ID_ALL, text_ALL);
        existingValues.add(itemAll);
        String text_EMPTY = (String)this.resourcesAccessor.getMessages().get(RB_KEY_TEXT_EMPTY);
        SelectItem itemEmpty = new SelectItem((Object)SELECT_ITEM_ID_EMPTY, text_EMPTY);
        existingValues.add(itemEmpty);
        HashSet<Object> addedItemIds = new HashSet<Object>();
        for (DocumentModel doc : this.docsList) {
            String label;
            Object exValue;
            try {
                exValue = doc.getProperty(schemaName, fieldName);
            }
            catch (ClientException e) {
                exValue = null;
            }
            if (exValue == null) continue;
            Object id = exValue;
            if (exValue instanceof String) {
                label = (String)exValue;
            } else if (exValue instanceof Calendar) {
                Calendar date = (Calendar)exValue;
                SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
                label = df.format(date.getTime());
                id = date.getTimeInMillis();
            } else if (exValue instanceof String[]) {
                String[] currentValueList = (String[])exValue;
                label = Arrays.asList(currentValueList).toString();
                id = label;
            } else {
                log.warn((Object)("unknown type for property (" + schemaName + ':' + fieldName + "= " + exValue));
                label = exValue.toString();
            }
            if (addedItemIds.contains(id)) continue;
            if (label.length() > 30) {
                label = label.substring(0, 27) + "...";
            }
            SelectItem item = new SelectItem(id, label);
            existingValues.add(item);
            addedItemIds.add(id);
        }
        try {
            this.currentFieldValues.setProperty(schemaName, fieldName, existingValues);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private static String[] getCommonSchemas(List<DocumentModel> docsList) {
        Object[][] docsSchemas = new String[docsList.size()][];
        int i = 0;
        for (DocumentModel docModel : docsList) {
            docsSchemas[i] = docModel.getDeclaredSchemas();
            ++i;
        }
        return (String[])ArrayUtils.intersect((Object[][])docsSchemas);
    }

    private FieldWidget[] getCommonWidgets(List<DocumentModel> docsList) throws ClientException {
        assert (null != docsList);
        Object[][] fieldWidgets = new FieldWidget[docsList.size()][];
        int i = 0;
        for (DocumentModel docModel : docsList) {
            Type t = this.getDocumentType(docModel);
            fieldWidgets[i] = t.getLayout();
            log.debug((Object)("Doc type: " + t.getId() + ", fieldWidgets[" + i + "]= " + Arrays.asList(fieldWidgets[i])));
            ++i;
        }
        FieldWidget[] commonFieldWidgets = (FieldWidget[])ArrayUtils.intersect((Object[][])fieldWidgets);
        log.debug((Object)("common fieldWidgets: " + Arrays.asList(commonFieldWidgets)));
        for (FieldWidget widget : commonFieldWidgets) {
            widget.setRequired(false);
        }
        return commonFieldWidgets;
    }

    private Type getDocumentType(DocumentModel docModel) throws ClientException {
        Type platformType = this.typeManager.getType(docModel.getType());
        if (null == platformType) {
            throw new ClientException("Platform type not defined for document type: " + docModel.getType());
        }
        return platformType;
    }

    @Override
    public String previewChanges() {
        if (this.docsList == null || this.docsList.isEmpty()) {
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("message.bulkedit.emptyList"), new Object[0]);
            log.error((Object)"empty list for bulk edit preview");
            return null;
        }
        int docsCount = this.docsList.size();
        String[] schemas = MassEditActionsBean.getCommonSchemas(this.docsList);
        this.changingDocuments.clear();
        this.unchangingDocuments.clear();
        this.changingFields = new HashMap<String, Set<String>>();
        for (DocumentModel docModel : this.docsList) {
            this.copyDocData(this.fictiveDocumentModel, docModel, schemas, true);
        }
        log.debug((Object)("will change " + this.changingDocuments.size() + " documents from " + docsCount));
        return NAVIGATION_PREVIEW;
    }

    @Override
    public String cancelChanges() {
        return NAVIGATION_MASS_EDIT;
    }

    @Override
    @End
    public String updateDocuments() throws ClientException {
        String logPrefix = "<updateDocuments> ";
        int docsCount = this.changingDocuments.size();
        log.debug((Object)("<updateDocuments> updating " + docsCount + " documents"));
        String[] schemas = MassEditActionsBean.getCommonSchemas(this.docsList);
        for (DocumentModel docModel : this.changingDocuments) {
            boolean canWrite;
            boolean bl = canWrite = this.documentManager.hasPermission(docModel.getRef(), "WriteProperties") && !docModel.hasFacet("Immutable");
            if (!canWrite) {
                String titleOrId = docModel.getTitle();
                if (titleOrId == null) {
                    titleOrId = docModel.getId();
                }
                this.facesMessages.add(FacesMessage.SEVERITY_ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.documents_update_error.writePermDenied"), new Object[]{titleOrId});
                return null;
            }
            this.copyDocData(this.fictiveDocumentModel, docModel, schemas, false);
            VersioningActions optionId = VersioningActions.ACTION_INCREMENT_DEFAULT;
            this.documentVersioning.setVersioningOptionInstanceId(docModel, optionId);
        }
        DocumentModel[] documents = new DocumentModel[docsCount];
        documents = this.changingDocuments.toArray(documents);
        this.documentManager.saveDocuments(documents);
        this.documentManager.save();
        for (DocumentModel docModel : this.docsList) {
            EventManager.raiseEventsOnDocumentChange((DocumentModel)docModel);
        }
        log.debug((Object)"<updateDocuments> documents updated ");
        if (this.removeFromList) {
            for (DocumentModel docModel : this.changingDocuments) {
                this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION", docModel);
            }
        }
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("feedback.documents_updated"), new Object[0]);
        return null;
    }

    private boolean isFieldSelected(String schemaName, String propName) {
        try {
            return (Boolean)this.changeCheckboxes.getProperty(schemaName, propName);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    private void copyDocData(DocumentModel srcDocModel, DocumentModel destDocModel, String[] schemas, boolean previewOnly) {
        String logPrefix = "<copyDocData> ";
        boolean docToBeUpdated = false;
        for (String schemaName : schemas) {
            Map data;
            try {
                data = srcDocModel.getProperties(schemaName);
            }
            catch (ClientException e) {
                data = null;
            }
            if (null == data) {
                log.warn((Object)("<copyDocData> null data for schema name: " + schemaName));
                continue;
            }
            if (data.isEmpty()) {
                log.debug((Object)("<copyDocData> empty data for schema name: " + schemaName + ". Check declared schema on document layout for type: " + destDocModel.getType()));
                continue;
            }
            for (String propName : data.keySet()) {
                Object value = data.get(propName);
                if (value == null) continue;
                if (value instanceof String) {
                    // empty if block
                }
                if (!this.isFieldSelected(schemaName, propName)) {
                    log.debug((Object)("<copyDocData> skip not selected prop " + schemaName + ':' + propName));
                    continue;
                }
                if (!this.isSelectedValueMatching(destDocModel, schemaName, propName)) {
                    log.debug((Object)("<copyDocData> skip value not matching for " + srcDocModel.getId() + '.' + schemaName + ':' + propName));
                    continue;
                }
                if (previewOnly) {
                    Object selectedValue;
                    log.debug((Object)("<copyDocData> will set prop '" + schemaName + ':' + propName + " = " + value));
                    docToBeUpdated = true;
                    Set<String> props = this.changingFields.get(schemaName);
                    if (props == null) {
                        props = new HashSet<String>();
                        this.changingFields.put(schemaName, props);
                    }
                    try {
                        selectedValue = this.docModelExistingSelect.getProperty(schemaName, propName);
                    }
                    catch (ClientException e) {
                        selectedValue = null;
                    }
                    if (selectedValue != null) {
                        Object currentValue;
                        String verboseValue = selectedValue.toString();
                        if (verboseValue.equals(SELECT_ITEM_ID_ALL)) {
                            String text_ALL;
                            verboseValue = text_ALL = (String)this.resourcesAccessor.getMessages().get(RB_KEY_TEXT_ALL);
                        } else if (verboseValue.equals(SELECT_ITEM_ID_EMPTY)) {
                            String text_EMPTY;
                            verboseValue = text_EMPTY = (String)this.resourcesAccessor.getMessages().get(RB_KEY_TEXT_EMPTY);
                        }
                        try {
                            currentValue = destDocModel.getProperty(schemaName, propName);
                        }
                        catch (ClientException e) {
                            throw new ClientRuntimeException((Throwable)e);
                        }
                        if (currentValue instanceof Calendar) {
                            try {
                                this.docModelExistingSelectVerbose.setProperty(schemaName, propName, currentValue);
                            }
                            catch (ClientException e) {
                                throw new ClientRuntimeException((Throwable)e);
                            }
                        }
                        try {
                            this.docModelExistingSelectVerbose.setProperty(schemaName, propName, (Object)verboseValue);
                        }
                        catch (ClientException e) {
                            throw new ClientRuntimeException((Throwable)e);
                        }
                    }
                    props.add(propName);
                    continue;
                }
                log.debug((Object)("<copyDocData> set prop '" + schemaName + ':' + propName + " = " + value));
                try {
                    destDocModel.setProperty(schemaName, propName, value);
                }
                catch (ClientException e) {
                    throw new ClientRuntimeException((Throwable)e);
                }
            }
        }
        if (previewOnly) {
            if (docToBeUpdated) {
                this.changingDocuments.add(destDocModel);
            } else {
                this.unchangingDocuments.add(destDocModel);
            }
        }
    }

    private boolean isSelectedValueMatching(DocumentModel destDocModel, String schemaName, String propName) {
        Object selectedValue;
        Object currentValue;
        try {
            currentValue = destDocModel.getProperty(schemaName, propName);
        }
        catch (ClientException e) {
            currentValue = null;
        }
        try {
            selectedValue = this.docModelExistingSelect.getProperty(schemaName, propName);
        }
        catch (ClientException e) {
            selectedValue = null;
        }
        if (selectedValue == null) {
            log.warn((Object)"selectedValue=null");
            return false;
        }
        if (currentValue != null) {
            if (selectedValue.equals(SELECT_ITEM_ID_ALL)) {
                return true;
            }
            if (selectedValue.equals(SELECT_ITEM_ID_EMPTY) && currentValue instanceof String && ((String)currentValue).length() == 0) {
                return true;
            }
            if (currentValue instanceof Calendar) {
                Calendar currentCalendarDate = (Calendar)currentValue;
                long currentDate = currentCalendarDate.getTimeInMillis();
                return selectedValue.equals(Long.toString(currentDate));
            }
            if (currentValue instanceof String[]) {
                Object[] currentValueArray = (String[])currentValue;
                String selectedValueStr = (String)selectedValue;
                if (selectedValueStr.length() < 2) {
                    log.warn((Object)("selected item has invalid value: " + selectedValueStr));
                    return false;
                }
                selectedValueStr = selectedValueStr.substring(1, selectedValueStr.length() - 1);
                Object[] selectedValueArray = selectedValueStr.split(", ");
                boolean eq = Arrays.equals(currentValueArray, selectedValueArray);
                log.debug((Object)("comparing currentValue: " + Arrays.asList(currentValueArray) + " with selectedValue: " + Arrays.asList(selectedValueArray) + " = " + eq));
                return eq;
            }
            if (currentValue.equals(selectedValue)) {
                return true;
            }
        } else if (selectedValue.equals(SELECT_ITEM_ID_EMPTY) || selectedValue.equals(SELECT_ITEM_ID_ALL)) {
            return true;
        }
        return false;
    }

    @Override
    public String viewDocument() throws ClientException {
        String logPrefix = "<viewDocument> ";
        log.debug((Object)("<viewDocument> selected doc: " + this.selectedDM));
        return this.navigationContext.navigateToDocument(this.selectedDM);
    }

    @Override
    public String massEditWorkList() throws ClientException {
        String logPrefix = "<massEditWorkList> ";
        List clipboardSelection = this.clipboardActions.getCurrentSelectedList();
        if (clipboardSelection.isEmpty()) {
            log.warn((Object)"<massEditWorkList> No Documents in worklist for mass edition.");
            return null;
        }
        this.setDocumentsList(clipboardSelection);
        return NAVIGATION_MASS_EDIT;
    }

    @Override
    public boolean getRemoveFromList() {
        return this.removeFromList;
    }

    @Override
    public void setRemoveFromList(boolean remove) {
        this.removeFromList = remove;
    }

    @Destroy
    public void destroy() {
        log.debug((Object)"Removing SEAM component: lockActions");
    }
}

