/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.edit.lock;

import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.Remove;
import javax.faces.application.FacesMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.webapp.edit.lock.LockActions;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="lockActions")
@Scope(value=ScopeType.EVENT)
public class LockActionsBean
implements LockActions {
    private static final long serialVersionUID = -8050964269646803077L;
    private static final Log log = LogFactory.getLog(LockActionsBean.class);
    private static final String EDIT_ACTIONS = "EDIT_ACTIONS";
    @In
    private transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    private Map<String, String> lockDetails;
    private Boolean canLock;
    private Boolean canUnlock;
    private Boolean isLiveEditable;

    @Override
    public Boolean getCanLockDoc(DocumentModel document) {
        if (this.canLock == null) {
            if (document == null) {
                log.warn((Object)"Can't evaluate lock action : currentDocument is null");
                this.canLock = false;
            } else if (document.isProxy()) {
                this.canLock = false;
            } else {
                try {
                    NuxeoPrincipal userName = (NuxeoPrincipal)this.documentManager.getPrincipal();
                    String docLock = this.documentManager.getLock(document.getRef());
                    this.canLock = docLock == null && (userName.isAdministrator() || this.documentManager.hasPermission(document.getRef(), "WriteProperties")) && !document.isVersion();
                }
                catch (Exception e) {
                    log.debug((Object)("evaluation of document lock " + document.getName() + " failed (" + e.getMessage() + ": returning false"));
                    this.canLock = false;
                }
            }
        }
        return this.canLock;
    }

    @Override
    @Factory(value="currentDocumentCanBeLocked", scope=ScopeType.EVENT)
    public Boolean getCanLockCurrentDoc() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.getCanLockDoc(currentDocument);
    }

    protected void resetEventContext() {
        Context evtCtx = Contexts.getEventContext();
        if (evtCtx != null) {
            evtCtx.remove("currentDocumentCanBeLocked");
            evtCtx.remove("currentDocumentLockDetails");
            evtCtx.remove("currentDocumentCanBeUnlocked");
        }
    }

    @Override
    public Boolean getCanUnlockDoc(DocumentModel document) {
        if (this.canUnlock == null) {
            if (document == null) {
                this.canUnlock = false;
            } else {
                try {
                    NuxeoPrincipal userName = (NuxeoPrincipal)this.documentManager.getPrincipal();
                    Map<String, String> lockDetails = this.getLockDetails(document);
                    this.canUnlock = lockDetails.isEmpty() || document.isProxy() ? Boolean.valueOf(false) : Boolean.valueOf((userName.isAdministrator() || this.documentManager.hasPermission(document.getRef(), "Everything") || userName.getName().equals(lockDetails.get("document.locker")) && this.documentManager.hasPermission(document.getRef(), "WriteProperties")) && !document.isVersion());
                }
                catch (Exception e) {
                    log.debug((Object)("evaluation of document lock " + document.getName() + " failed (" + e.getMessage() + ": returning false"));
                    this.canUnlock = false;
                }
            }
        }
        return this.canUnlock;
    }

    @Override
    @Factory(value="currentDocumentCanBeUnlocked", scope=ScopeType.EVENT)
    public Boolean getCanUnlockCurrentDoc() {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.getCanUnlockDoc(currentDocument);
    }

    @Override
    public String lockCurrentDocument() throws ClientException {
        return this.lockDocument(this.navigationContext.getCurrentDocument());
    }

    @Override
    public String lockDocument(DocumentModel document) throws ClientException {
        log.debug((Object)"Lock a document ...");
        this.resetEventContext();
        String message = "document.lock.failed";
        DocumentRef ref = document.getRef();
        if (this.documentManager.hasPermission(ref, "WriteProperties") && this.documentManager.getLock(ref) == null) {
            this.documentManager.setLock(ref, this.getDocumentLockKey());
            this.documentManager.save();
            message = "document.lock";
        }
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get(message), new Object[0]);
        this.resetLockState();
        this.webActions.resetTabList();
        return "document_view";
    }

    @Override
    public String unlockCurrentDocument() throws ClientException {
        return this.unlockDocument(this.navigationContext.getCurrentDocument());
    }

    @Override
    public String unlockDocument(DocumentModel document) throws ClientException {
        String message;
        log.debug((Object)"Unlock a document ...");
        this.resetEventContext();
        Map<String, String> lockDetails = this.getLockDetails(document);
        if (lockDetails == null) {
            message = "document.unlock.done";
        } else {
            NuxeoPrincipal userName = (NuxeoPrincipal)this.documentManager.getPrincipal();
            if (userName.isAdministrator() || this.documentManager.hasPermission(document.getRef(), "Everything") || userName.getName().equals(lockDetails.get("document.locker"))) {
                if (!this.documentManager.hasPermission(document.getRef(), "WriteProperties")) {
                    try {
                        new unrestrictedUnlocker(document.getRef()).runUnrestricted();
                        message = "document.unlock";
                    }
                    catch (Exception e) {
                        throw new ClientException(e.getMessage());
                    }
                } else {
                    this.documentManager.unlock(document.getRef());
                    this.documentManager.save();
                    message = "document.unlock";
                }
            } else {
                message = "document.unlock.not.permitted";
            }
        }
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get(message), new Object[0]);
        this.resetLockState();
        this.webActions.resetTabList();
        return "document_view";
    }

    @Override
    public void lockDocuments(List<DocumentModel> documents) {
    }

    @Override
    public void unlockDocuments(List<DocumentModel> documents) {
    }

    @Override
    public Action getLockOrUnlockAction() {
        log.debug((Object)"Get lock or unlock action ...");
        Action lockOrUnlockAction = null;
        List actionsList = this.webActions.getActionsList(EDIT_ACTIONS);
        if (actionsList != null && !actionsList.isEmpty()) {
            lockOrUnlockAction = (Action)actionsList.get(0);
        }
        return lockOrUnlockAction;
    }

    @Override
    @Factory(value="currentDocumentLockDetails", scope=ScopeType.EVENT)
    public Map<String, String> getCurrentDocLockDetails() throws ClientException {
        Map<String, String> details = null;
        if (this.navigationContext.getCurrentDocument() != null) {
            details = this.getLockDetails(this.navigationContext.getCurrentDocument());
        }
        return details;
    }

    @Override
    public Map<String, String> getLockDetails(DocumentModel document) throws ClientException {
        if (this.lockDetails == null) {
            this.lockDetails = new HashMap<String, String>();
            String documentKey = this.documentManager.getLock(document.getRef());
            if (documentKey == null) {
                return this.lockDetails;
            }
            String[] values = documentKey.split(":");
            this.lockDetails.put("document.locker", values[0]);
            this.lockDetails.put("document.lock.time", values[1]);
        }
        return this.lockDetails;
    }

    private String getDocumentLockKey() {
        StringBuilder result = new StringBuilder();
        result.append(this.documentManager.getPrincipal().getName()).append(':').append(DateFormat.getDateInstance(2).format(new Date()));
        return result.toString();
    }

    @Override
    @Deprecated
    public Boolean isCurrentDocumentLiveEditable() {
        if (this.isLiveEditable == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            try {
                NuxeoPrincipal userName = (NuxeoPrincipal)this.documentManager.getPrincipal();
                String docLock = this.documentManager.getLock(currentDocument.getRef());
                this.isLiveEditable = docLock == null ? Boolean.valueOf((userName.isAdministrator() || this.documentManager.hasPermission(currentDocument.getRef(), "WriteProperties")) && !currentDocument.isVersion()) : Boolean.valueOf((userName.isAdministrator() || userName.getName().equals(this.getLockDetails(currentDocument).get("document.locker")) && this.documentManager.hasPermission(currentDocument.getRef(), "WriteProperties")) && !currentDocument.isVersion());
            }
            catch (Exception e) {
                log.debug((Object)("evaluation of edit on line option for document " + currentDocument.getName() + " failed (" + e.getMessage() + ": returning false"));
                this.isLiveEditable = false;
            }
        }
        return this.isLiveEditable;
    }

    @Override
    public void resetLockState() {
        this.lockDetails = null;
        this.canLock = null;
        this.canUnlock = null;
        this.isLiveEditable = null;
    }

    @Override
    @Destroy
    @Remove
    public void destroy() {
    }

    protected class unrestrictedUnlocker
    extends UnrestrictedSessionRunner {
        private final DocumentRef docRefToUnlock;

        protected unrestrictedUnlocker(DocumentRef docRef) {
            super(LockActionsBean.this.documentManager);
            this.docRefToUnlock = docRef;
        }

        public void run() throws ClientException {
            this.session.unlock(this.docRefToUnlock);
            this.session.save();
        }
    }
}

