/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.helpers;

import java.io.Serializable;
import java.security.Principal;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.impl.CompoundFilter;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.impl.LifeCycleFilter;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.util.RepositoryLocation;
import org.nuxeo.ecm.webapp.dashboard.DashboardNavigationHelper;
import org.nuxeo.ecm.webapp.helpers.ConversationIdGenerator;

@Name(value="startupHelper")
@Scope(value=ScopeType.SESSION)
public class StartupHelper
implements Serializable {
    protected static final String SERVERS_VIEW = "view_servers";
    protected static final String DOMAINS_VIEW = "view_domains";
    protected static final String DOMAIN_TYPE = "Domain";
    private static final long serialVersionUID = 3248972387619873245L;
    private static final Log log = LogFactory.getLog(StartupHelper.class);
    @In(create=true)
    protected transient RepositoryManager repositoryManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    @In
    protected transient Context sessionContext;
    @In(create=true)
    protected DashboardNavigationHelper dashboardNavigationHelper;
    @In(create=true)
    ConversationIdGenerator conversationIdGenerator;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;

    public String initServerAndFindStartupPage() throws ClientException {
        this.setupCurrentUser();
        if (this.repositoryManager.getRepositories().size() > 1) {
            return SERVERS_VIEW;
        }
        if (this.navigationContext.getCurrentServerLocation() == null) {
            RepositoryLocation repLoc = new RepositoryLocation(((Repository)this.repositoryManager.getRepositories().iterator().next()).getName());
            this.navigationContext.setCurrentServerLocation(repLoc);
        }
        return DOMAINS_VIEW;
    }

    @Begin(id="#{conversationIdGenerator.nextMainConversationId}", join=true)
    public String initDomainAndFindStartupPage(String domainTitle, String viewId) {
        try {
            DocumentModel rootDocument;
            String result = this.initServerAndFindStartupPage();
            if (!DOMAINS_VIEW.equals(result)) {
                return result;
            }
            if (this.documentManager == null) {
                this.documentManager = this.navigationContext.getOrCreateDocumentManager();
            }
            if (!this.documentManager.hasPermission((rootDocument = this.documentManager.getRootDocument()).getRef(), "ReadChildren")) {
                return this.dashboardNavigationHelper.navigateToDashboard();
            }
            FacetFilter facetFilter = new FacetFilter("HiddenInNavigation", false);
            LifeCycleFilter lcFilter = new LifeCycleFilter("deleted", false);
            CompoundFilter complexFilter = new CompoundFilter(new Filter[]{facetFilter, lcFilter});
            DocumentModelList domains = this.documentManager.getChildren(rootDocument.getRef(), null, "Read", (Filter)complexFilter, null);
            if (domains.size() == 1) {
                return this.navigationContext.navigateToDocument((DocumentModel)domains.get(0), viewId);
            }
            this.navigationContext.navigateToDocument(rootDocument);
            return DOMAINS_VIEW;
        }
        catch (ClientException e) {
            log.error((Object)("error while initializing the Seam context with a CoreSession instance: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public void setupCurrentUser() {
        Principal currentUser = FacesContext.getCurrentInstance().getExternalContext().getUserPrincipal();
        this.sessionContext.set("currentUser", (Object)currentUser);
    }
}

