/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.navigation;

import java.util.ArrayList;
import java.util.List;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.navigation.Pages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.pathelements.ArchivedVersionsPathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.DocumentPathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.PathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.TextPathElement;
import org.nuxeo.ecm.platform.ui.web.pathelements.VersionDocumentPathElement;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.webapp.navigation.BreadcrumbActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="breadcrumbActions")
@Scope(value=ScopeType.STATELESS)
@Install(precedence=10)
public class BreadcrumbActionsBean
implements BreadcrumbActions {
    private static final Log log = LogFactory.getLog(BreadcrumbActionsBean.class);
    @In(create=true)
    NavigationContext navigationContext;
    @In(create=true, required=false)
    private CoreSession documentManager;
    private static final String VIEW_DOMAIN_OUTCOME = "view_domains";
    private static final String BREADCRUMB_PREFIX = "breadcrumb";
    private static final String PATH_SHORTCUT = "....";
    protected static int MIN_PATH_SEGMENTS_LEN = 4;
    protected static int MAX_PATH_CHAR_LEN = 80;

    @Override
    public String navigateToParent() throws ClientException {
        String outcome;
        List<PathElement> documentsFormingPath = this.getBackendPath();
        int nbDocInList = documentsFormingPath.size();
        if (nbDocInList >= 0 && documentsFormingPath.get(0).getName().equals(PATH_SHORTCUT)) {
            documentsFormingPath.remove(0);
        }
        if ((nbDocInList = documentsFormingPath.size()) == 0) {
            return "view_servers";
        }
        if (nbDocInList > 1) {
            PathElement parentPathElement = documentsFormingPath.get(nbDocInList - 2);
            outcome = this.navigateToPathElement(parentPathElement);
        } else {
            PathElement pathElement = documentsFormingPath.get(0);
            if (pathElement instanceof TextPathElement) {
                DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
                if (currentDocument == null) {
                    return "view_servers";
                }
                return this.navigationContext.navigateToDocument(currentDocument);
            }
            DocumentPathElement currentPathELement = (DocumentPathElement)pathElement;
            DocumentModel doc = currentPathELement.getDocumentModel();
            outcome = this.documentManager.hasPermission(doc.getParentRef(), "Read") ? this.navigationContext.navigateToRef(doc.getParentRef()) : this.navigateToPathElement((PathElement)currentPathELement);
            if (this.navigationContext.getCurrentDocument().getType().equals("CoreRoot")) {
                outcome = VIEW_DOMAIN_OUTCOME;
            }
        }
        return outcome;
    }

    protected String navigateToPathElement(PathElement pathElement) throws ClientException {
        String elementType = pathElement.getType();
        if (elementType == "DocumentPathElement") {
            DocumentPathElement docPathElement = (DocumentPathElement)pathElement;
            DocumentModel currentDoc = docPathElement.getDocumentModel();
            return this.navigationContext.navigateToDocument(currentDoc);
        }
        if (elementType == "ArchivedVersionsPathElement") {
            ArchivedVersionsPathElement docPathElement = (ArchivedVersionsPathElement)pathElement;
            DocumentModel currentDoc = docPathElement.getDocumentModel();
            return this.navigationContext.navigateToDocument(currentDoc, "TAB_CONTENT_HISTORY");
        }
        if (elementType == "VersionDocumentPathElement") {
            VersionDocumentPathElement element = (VersionDocumentPathElement)pathElement;
            DocumentModel currentDoc = element.getDocumentModel();
            return this.navigationContext.navigateToDocument(currentDoc);
        }
        return null;
    }

    @Override
    @Factory(value="backendPath", scope=ScopeType.EVENT)
    public List<PathElement> getBackendPath() throws ClientException {
        String viewId = FacesContext.getCurrentInstance().getViewRoot().getViewId();
        String viewIdLabel = Pages.instance().getPage(viewId).getDescription();
        if (viewIdLabel != null && viewIdLabel.startsWith(BREADCRUMB_PREFIX)) {
            return this.makeBackendPathFromLabel(viewIdLabel.substring(BREADCRUMB_PREFIX.length() + 1));
        }
        return this.shrinkPathIfNeeded(this.navigationContext.getCurrentPathList());
    }

    protected List<PathElement> shrinkPathIfNeeded(List<PathElement> paths) {
        if (paths == null || paths.size() <= MIN_PATH_SEGMENTS_LEN) {
            return paths;
        }
        StringBuffer sb = new StringBuffer();
        for (PathElement pe : paths) {
            sb.append(pe.getName());
        }
        String completePath = sb.toString();
        if (completePath.length() <= MAX_PATH_CHAR_LEN) {
            return paths;
        }
        sb = new StringBuffer();
        ArrayList<PathElement> shrinkedPath = new ArrayList<PathElement>();
        for (int i = paths.size() - 1; i >= 0; --i) {
            PathElement pe = paths.get(i);
            sb.append(pe.getName());
            if (sb.length() >= MAX_PATH_CHAR_LEN) break;
            shrinkedPath.add(0, pe);
        }
        shrinkedPath.add(0, (PathElement)new TextPathElement(PATH_SHORTCUT));
        return shrinkedPath;
    }

    private List<PathElement> makeBackendPathFromLabel(String label) {
        ArrayList<PathElement> pathElements = new ArrayList<PathElement>();
        FacesContext context = FacesContext.getCurrentInstance();
        TextPathElement pathLabel = new TextPathElement(ComponentUtils.translate((FacesContext)context, (String)label, null));
        pathElements.add((PathElement)pathLabel);
        return pathElements;
    }
}

