/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.search;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.types.FieldWidget;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelListener;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelRowEvent;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.clipboard.ClipboardActions;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;
import org.nuxeo.ecm.webapp.search.SearchColumns;
import org.nuxeo.ecm.webapp.search.SearchResults;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="searchResults")
@Scope(value=ScopeType.CONVERSATION)
public class SearchResultsBean
extends InputController
implements SearchResults,
Serializable {
    private static final long serialVersionUID = 7823660685121811606L;
    private static final Log log = LogFactory.getLog(SearchResultsBean.class);
    public static final String SEARCH_DOCUMENT_LIST = "SEARCH_DOCUMENT_LIST";
    @In(required=false, create=true)
    protected transient SearchColumns searchColumns;
    @In(required=false, create=true)
    protected transient DocumentsListsManager documentsListsManager;
    protected String providerName;
    @RequestParameter(value="providerName")
    protected String newProviderName;
    @RequestParameter(value="sortColumn")
    protected String newSortColumn;
    @In(required=false, create=true)
    protected transient ResultsProvidersCache resultsProvidersCache;
    @In(create=true)
    protected transient ClipboardActions clipboardActions;
    protected transient PagedDocumentsProvider provider;

    public void reset() {
        this.provider = null;
    }

    @Override
    public void init() {
        log.debug((Object)"Initializing...");
    }

    @Override
    public void destroy() {
        log.debug((Object)"Destroy...");
    }

    @Override
    public String repeatSearch() throws ClientException {
        if (this.newProviderName == null) {
            throw new ClientException("providerName not set");
        }
        String sortColumn = null;
        boolean sortAscending = true;
        SortInfo sortInfo = this.getProvider(this.newProviderName).getSortInfo();
        if (sortInfo != null) {
            sortColumn = sortInfo.getSortColumn();
            sortAscending = sortInfo.getSortAscending();
        }
        if (StringUtils.equals((String)sortColumn, (String)this.newSortColumn)) {
            sortAscending = !sortAscending;
        } else {
            sortColumn = this.newSortColumn;
            sortAscending = true;
        }
        sortInfo = new SortInfo(sortColumn, sortAscending);
        this.resultsProvidersCache.invalidate(this.providerName);
        this.provider = this.resultsProvidersCache.get(this.providerName, sortInfo);
        return null;
    }

    public PagedDocumentsProvider getProvider() throws ClientException {
        if (this.providerName == null) {
            throw new ClientException("No provider name has been specified yet");
        }
        return this.getProvider(this.providerName);
    }

    @Override
    public PagedDocumentsProvider getProvider(String providerName) throws ClientException {
        this.provider = this.resultsProvidersCache.get(providerName);
        if (this.provider == null) {
            throw new ClientException("Unknown or unbuildable results provider: " + providerName);
        }
        return this.provider;
    }

    @Override
    public String getSortColumn() throws ClientException {
        SortInfo sortInfo = this.getProvider().getSortInfo();
        return sortInfo == null ? null : sortInfo.getSortColumn();
    }

    @Override
    public boolean isSortAscending() throws ClientException {
        SortInfo sortInfo = this.getProvider().getSortInfo();
        return sortInfo == null ? true : sortInfo.getSortAscending();
    }

    public List<DocumentModel> getResultDocuments(String providerName) throws ClientException {
        return this.getProvider(providerName).getCurrentPage();
    }

    @Override
    @Factory(value="searchSelectModel_advanced", scope=ScopeType.EVENT)
    public SelectDataModel getResultsSelectModelAdvanced() throws ClientException {
        return this.getResultsSelectModel("ADVANCED_SEARCH");
    }

    @Override
    @Factory(value="searchSelectModel_nxql", scope=ScopeType.EVENT)
    public SelectDataModel getResultsSelectModelNxql() throws ClientException {
        return this.getResultsSelectModel("SEARCH_BEAN_NXQL_PROVIDER");
    }

    @Override
    @Factory(value="searchSelectModel_simple", scope=ScopeType.EVENT)
    public SelectDataModel getResultsSelectModelSimple() throws ClientException {
        return this.getResultsSelectModel("SIMPLE_SEARCH");
    }

    @Observer(value={"documentChildrenChanged"}, create=false)
    @BypassInterceptors
    public void refreshSelectModels() {
        Context context = Contexts.getEventContext();
        context.remove("searchSelectModel_simple");
        context.remove("searchSelectModel_nxql");
        context.remove("searchSelectModel_advanced");
    }

    @Override
    public SelectDataModel getResultsSelectModel(String providerName) throws ClientException {
        if (providerName == null) {
            throw new ClientException("providerName has not been set yet");
        }
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        SelectDataModelImpl model = new SelectDataModelImpl(SEARCH_DOCUMENT_LIST, this.getResultDocuments(providerName), selectedDocuments);
        model.addSelectModelListener((SelectDataModelListener)this);
        return model;
    }

    @Override
    @WebRemote
    public String processSelectRow(String selectedDocRef, String providerName, Boolean selection) throws ClientException {
        DocumentModel data = null;
        List<DocumentModel> currentDocs = this.getResultDocuments(providerName);
        for (DocumentModel d : currentDocs) {
            DocumentRef docRef = d.getRef();
            if (docRef == null) {
                log.error((Object)("null DocumentRef for doc: " + d));
                continue;
            }
            if (!docRef.reference().equals(selectedDocRef)) continue;
            data = d;
            break;
        }
        if (data == null) {
            return "ERROR : DataNotFound";
        }
        if (selection.booleanValue()) {
            this.documentsListsManager.addToWorkingList("CURRENT_SELECTION", data);
        } else {
            this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION", data);
        }
        return this.computeSelectionActions();
    }

    private String computeSelectionActions() {
        List availableActions = this.clipboardActions.getActionsForSelection();
        ArrayList<String> availableActionIds = new ArrayList<String>();
        for (Action a : availableActions) {
            if (!a.getAvailable()) continue;
            availableActionIds.add(a.getId());
        }
        String res = "";
        if (!availableActionIds.isEmpty()) {
            res = StringUtils.join((Object[])availableActionIds.toArray(), (String)"|");
        }
        return res;
    }

    public void processSelectRowEvent(SelectDataModelRowEvent event) {
        Boolean selection = event.getSelected();
        DocumentModel data = (DocumentModel)event.getRowData();
        if (selection.booleanValue()) {
            this.documentsListsManager.addToWorkingList("CURRENT_SELECTION", data);
        } else {
            this.documentsListsManager.removeFromWorkingList("CURRENT_SELECTION", data);
        }
    }

    @Override
    public boolean isSortable() throws ClientException {
        return this.getProvider().isSortable();
    }

    @Override
    public String downloadCSV() throws ClientException {
        try {
            if (this.newProviderName == null) {
                throw new ClientException("providerName not set");
            }
            PagedDocumentsProvider provider = this.getProvider(this.newProviderName);
            HttpServletResponse response = (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse();
            response.setContentType("text/csv");
            response.setHeader("Content-Disposition", "attachment; filename=\"search_results.csv\"");
            char separator = Framework.getProperty((String)"org.nuxeo.ecm.webapp.search.csv.separator", (String)",").charAt(0);
            char quotechar = Framework.getProperty((String)"org.nuxeo.ecm.webapp.search.csv.quotechar", (String)"\"").charAt(0);
            String endOfLine = Framework.getProperty((String)"org.nuxeo.ecm.webapp.search.csv.endofline", (String)"\n");
            CSVWriter writer = new CSVWriter((Writer)response.getWriter(), separator, quotechar, endOfLine);
            List<FieldWidget> widgetList = this.searchColumns.getResultColumns();
            Locale locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
            DateFormat df = DateFormat.getDateInstance(3, locale);
            String[] columnNames = new String[widgetList.size()];
            int i = 0;
            for (FieldWidget widget : widgetList) {
                String columnName = (String)this.resourcesAccessor.getMessages().get(widget.getLabel());
                columnNames[i++] = columnName;
            }
            writer.writeNext(columnNames);
            int currentPage = provider.getCurrentPageIndex();
            int pageCount = provider.getNumberOfPages();
            for (int page = 0; page < pageCount; ++page) {
                DocumentModelList docModelList = provider.getPage(page);
                for (DocumentModel docModel : docModelList) {
                    String[] columns = new String[widgetList.size()];
                    i = 0;
                    for (FieldWidget widget : widgetList) {
                        String stringValue;
                        String fieldSchema = widget.getSchemaName();
                        String fieldName = widget.getFieldName();
                        Object value = docModel.getProperty(fieldSchema, fieldName);
                        value = fieldSchema.equals("dublincore") && fieldName.equals("title") ? DocumentModelFunctions.titleOrId((DocumentModel)docModel) : (fieldSchema.equals("ecm") && fieldName.equals("primaryType") ? docModel.getType() : (fieldSchema.equals("ecm") && fieldName.equals("currentLifeCycleState") ? docModel.getCurrentLifeCycleState() : docModel.getProperty(fieldSchema, fieldName)));
                        if (value == null) {
                            stringValue = "";
                        } else if (value instanceof GregorianCalendar) {
                            GregorianCalendar gValue = (GregorianCalendar)value;
                            stringValue = df.format(gValue.getTime());
                        } else {
                            stringValue = String.valueOf(value);
                        }
                        columns[i++] = stringValue;
                    }
                    writer.writeNext(columns);
                }
            }
            writer.close();
            response.flushBuffer();
            FacesContext.getCurrentInstance().responseComplete();
            provider.getPage(currentPage);
        }
        catch (IOException e) {
            throw new ClientException("download csv failed", (Throwable)e);
        }
        return null;
    }
}

