/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.Labeler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityData
implements Serializable {
    protected static final Labeler labeler = new Labeler("label.security.permission");
    private static final long serialVersionUID = -7958330304227141087L;
    private static final Log log = LogFactory.getLog(SecurityData.class);
    protected Map<String, List<String>> currentDocGrant = new HashMap<String, List<String>>();
    protected Map<String, List<String>> currentDocDeny = new HashMap<String, List<String>>();
    protected Map<String, List<String>> parentDocsGrant = new HashMap<String, List<String>>();
    protected Map<String, List<String>> parentDocsDeny = new HashMap<String, List<String>>();
    protected final List<String> currentDocumentUsers = new ArrayList<String>();
    protected final List<String> parentDocumentsUsers = new ArrayList<String>();
    protected String documentType = "";
    protected boolean needSave = false;

    public void setNeedSave(boolean needSave) {
        this.needSave = needSave;
    }

    public boolean getNeedSave() {
        return this.needSave;
    }

    public Map<String, List<String>> getCurrentDocDeny() {
        return this.currentDocDeny;
    }

    public void setCurrentDocDeny(Map<String, List<String>> deny) {
        this.currentDocDeny = deny;
    }

    public Map<String, List<String>> getCurrentDocGrant() {
        return this.currentDocGrant;
    }

    public void setCurrentDocGrant(Map<String, List<String>> grant) {
        this.currentDocGrant = grant;
    }

    public Map<String, List<String>> getParentDocsDenyLabels() {
        return this.buildLabelMap(this.parentDocsDeny);
    }

    public Map<String, List<String>> getParentDocsDeny() {
        return this.parentDocsDeny;
    }

    public void setParentDocsDeny(Map<String, List<String>> parentDocsDeny) {
        this.parentDocsDeny = parentDocsDeny;
    }

    public Map<String, List<String>> getParentDocsGrant() {
        return this.parentDocsGrant;
    }

    public Map<String, List<String>> getParentDocsGrantLabels() {
        return this.buildLabelMap(this.parentDocsGrant);
    }

    public void setParentDocsGrant(Map<String, List<String>> parentDocsGrant) {
        this.parentDocsGrant = parentDocsGrant;
    }

    public List<String> getCurrentDocumentUsers() {
        return this.currentDocumentUsers;
    }

    public List<String> getParentDocumentsUsers() {
        return this.parentDocumentsUsers;
    }

    protected Map<String, List<String>> buildLabelMap(Map<String, List<String>> permissions) {
        HashMap<String, List<String>> labelMap = new HashMap<String, List<String>>();
        for (String user : permissions.keySet()) {
            ArrayList<String> labels = new ArrayList<String>();
            for (String perm : permissions.get(user)) {
                labels.add(labeler.makeLabel(perm));
            }
            labelMap.put(user, labels);
        }
        return labelMap;
    }

    public void rebuildUserLists() {
        ArrayList<String> users = new ArrayList<String>();
        users.addAll(this.currentDocGrant.keySet());
        for (String user : this.currentDocDeny.keySet()) {
            if (users.contains(user)) continue;
            users.add(user);
        }
        this.currentDocumentUsers.clear();
        this.currentDocumentUsers.addAll(users);
        users.clear();
        users.addAll(this.parentDocsGrant.keySet());
        for (String user : this.parentDocsDeny.keySet()) {
            if (users.contains(user)) continue;
            users.add(user);
        }
        this.parentDocumentsUsers.clear();
        this.parentDocumentsUsers.addAll(users);
    }

    public void addModifiablePrivilege(String principalName, String permissionName, boolean grant) {
        if (null == principalName || null == permissionName) {
            log.error((Object)"Null params received, returning...");
            return;
        }
        this.needSave = true;
        if (grant) {
            if (null != this.currentDocGrant.get(principalName)) {
                boolean shouldAddPermission = true;
                for (String permission : this.currentDocGrant.get(principalName)) {
                    if (!permission.equals(permissionName)) continue;
                    shouldAddPermission = false;
                    break;
                }
                if (shouldAddPermission) {
                    this.currentDocGrant.get(principalName).add(permissionName);
                }
            } else {
                ArrayList<String> permissions = new ArrayList<String>();
                permissions.add(permissionName);
                this.currentDocGrant.put(principalName, permissions);
            }
        } else if (null != this.currentDocDeny.get(principalName)) {
            boolean shouldAddPermission = true;
            for (String permission : this.currentDocDeny.get(principalName)) {
                if (!permission.equals(permissionName)) continue;
                shouldAddPermission = false;
                break;
            }
            if (shouldAddPermission) {
                this.currentDocDeny.get(principalName).add(permissionName);
            }
        } else {
            ArrayList<String> permissions = new ArrayList<String>();
            permissions.add(permissionName);
            this.currentDocDeny.put(principalName, permissions);
        }
        this.rebuildUserLists();
    }

    public boolean removeModifiablePrivilege(String principalName, String permissionName, boolean grant) {
        if (null == principalName || null == permissionName) {
            log.error((Object)"Null params received, returning...");
            return false;
        }
        this.needSave = true;
        boolean removed = false;
        if (grant) {
            if (null != this.currentDocGrant.get(principalName)) {
                Iterator<String> permissionIterator = this.currentDocGrant.get(principalName).iterator();
                while (permissionIterator.hasNext()) {
                    if (!permissionIterator.next().equals(permissionName)) continue;
                    permissionIterator.remove();
                    removed = true;
                    break;
                }
            }
        } else if (null != this.currentDocDeny.get(principalName)) {
            Iterator<String> permissionIterator = this.currentDocDeny.get(principalName).iterator();
            while (permissionIterator.hasNext()) {
                if (!permissionIterator.next().equals(permissionName)) continue;
                permissionIterator.remove();
                removed = true;
                break;
            }
        }
        this.rebuildUserLists();
        return removed;
    }

    public void removeModifiablePrivilege(String principalName) {
        if (null == principalName) {
            log.error((Object)"Null principal received, returning...");
            return;
        }
        this.currentDocGrant.remove(principalName);
        this.currentDocDeny.remove(principalName);
        this.needSave = true;
        this.rebuildUserLists();
    }

    public void addUnModifiablePrivilege(String principalName, String permissionName, boolean grant) {
        if (null == principalName || null == permissionName) {
            log.error((Object)"Null params received, returning...");
            return;
        }
        if (grant) {
            if (null != this.parentDocsGrant.get(principalName)) {
                boolean shouldAddPermission = true;
                for (String permission : this.parentDocsGrant.get(principalName)) {
                    if (!permission.equals(permissionName)) continue;
                    shouldAddPermission = false;
                    break;
                }
                if (shouldAddPermission) {
                    this.parentDocsGrant.get(principalName).add(permissionName);
                }
            } else {
                ArrayList<String> permissions = new ArrayList<String>();
                permissions.add(permissionName);
                this.parentDocsGrant.put(principalName, permissions);
            }
        } else if (null != this.parentDocsDeny.get(principalName)) {
            boolean shouldAddPermission = true;
            for (String permission : this.parentDocsDeny.get(principalName)) {
                if (!permission.equals(permissionName)) continue;
                shouldAddPermission = false;
                break;
            }
            if (shouldAddPermission) {
                this.parentDocsDeny.get(principalName).add(permissionName);
            }
        } else {
            ArrayList<String> permissions = new ArrayList<String>();
            permissions.add(permissionName);
            this.parentDocsDeny.put(principalName, permissions);
        }
        this.rebuildUserLists();
    }

    public void clear() {
        this.currentDocDeny.clear();
        this.currentDocGrant.clear();
        this.parentDocsDeny.clear();
        this.parentDocsGrant.clear();
        this.currentDocumentUsers.clear();
        this.parentDocumentsUsers.clear();
        log.debug((Object)"Cleared data...");
        this.needSave = false;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }
}

