/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.table.model;

import java.util.Collections;
import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.webapp.table.cell.AbstractTableCell;
import org.nuxeo.ecm.webapp.table.comparator.DefaultCellComparator;
import org.nuxeo.ecm.webapp.table.header.TableColHeader;
import org.nuxeo.ecm.webapp.table.row.TableRow;
import org.nuxeo.ecm.webapp.table.sort.SortableTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class GenericTableModel
extends SortableTableModel {
    private static final long serialVersionUID = -2921106396128184530L;
    private static final Log log = LogFactory.getLog(GenericTableModel.class);
    protected DataModel data;
    protected DataModel columnHeaders;

    protected GenericTableModel() {
    }

    public GenericTableModel(List<TableColHeader> columnHeaders, List<TableRow> data) throws ClientException {
        this.setData((DataModel)new ListDataModel(data));
        this.setColumnHeaders((DataModel)new ListDataModel(columnHeaders));
        this.verifyHeadersRowsConsistency(columnHeaders, data);
        log.debug((Object)"Constructed...");
    }

    protected void verifyHeadersConsistency(List<TableColHeader> columnHeaders) throws ClientException {
        if (null == columnHeaders) {
            throw new ClientException("Null param received.");
        }
        if (columnHeaders.size() < 1) {
            throw new ClientException("The table should contain at least 1 header. At the moment it contains " + columnHeaders.size() + ".");
        }
    }

    protected void verifyHeadersRowsConsistency(List<TableColHeader> columnHeaders, List<TableRow> data) throws ClientException {
        this.verifyHeadersConsistency(columnHeaders);
        this.verifyRowsConsistency(data);
    }

    protected void verifyRowsConsistency(List<TableRow> data) throws ClientException {
        if (null == data) {
            throw new ClientException("Null cells data.");
        }
        for (TableRow row : data) {
            this.verifyRowConsistency(row);
        }
    }

    public void verifyRowConsistency(TableRow row) throws ClientException {
        if (null == row) {
            throw new ClientException("Null row detected.");
        }
        int noHeaders = this.columnHeaders.getRowCount();
        if (row.getCells().size() != noHeaders) {
            throw new ClientException("The row size does not match the headers size.");
        }
    }

    public DataModel getColumnHeaders() {
        return this.columnHeaders;
    }

    public void setColumnHeaders(DataModel columnHeaders) {
        this.columnHeaders = columnHeaders;
    }

    public DataModel getData() {
        return this.data;
    }

    public void setData(DataModel data) {
        this.data = data;
    }

    public Object getCurrentCellDisplayedValue() {
        AbstractTableCell cell = (AbstractTableCell)this.getCurrentCell();
        if (null != cell) {
            return cell.getDisplayedValue();
        }
        log.error((Object)"No current cell.");
        return null;
    }

    public Object getCurrentCell() {
        if (this.data.isRowAvailable() && this.columnHeaders.isRowAvailable()) {
            int columnIndex = this.columnHeaders.getRowIndex();
            TableRow row = (TableRow)this.data.getRowData();
            AbstractTableCell cell = row.getCells().get(columnIndex);
            if (log.isDebugEnabled()) {
                log.debug((Object)("cell: " + cell));
            }
            return cell;
        }
        return null;
    }

    public void setCurrentCellDisplayedValue(Object value) {
        AbstractTableCell cell;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Attempting to set: " + value));
        }
        if (null != (cell = (AbstractTableCell)this.getCurrentCell())) {
            cell.setDisplayedValue(value);
        } else {
            log.error((Object)"No current cell.");
        }
    }

    public void addRows(List<TableRow> newRows) throws ClientException {
        this.verifyRowsConsistency(newRows);
        ((List)this.getData().getWrappedData()).addAll(newRows);
    }

    public void addRow(TableRow newRow) throws ClientException {
        this.verifyRowConsistency(newRow);
        ((List)this.getData().getWrappedData()).add(newRow);
    }

    @Override
    protected boolean isDefaultAscending(String sortColumn) {
        return true;
    }

    @Override
    protected void sort(String column, boolean ascending) {
        if (column != null) {
            int columnIndex = this.getColumnIndex(column);
            if (0 <= columnIndex) {
                Collections.sort((List)this.data.getWrappedData(), new DefaultCellComparator(columnIndex, this.isAscending()));
            }
        } else {
            log.error((Object)"Null column received");
        }
    }

    protected int getColumnIndex(String columnNameLabel) {
        int columnIndex = -1;
        List headers = (List)this.columnHeaders.getWrappedData();
        for (int i = 0; i < headers.size() && columnIndex == -1; ++i) {
            TableColHeader header = (TableColHeader)headers.get(i);
            if (!header.getLabel().equals(columnNameLabel)) continue;
            columnIndex = i;
            break;
        }
        return columnIndex;
    }
}

