/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.jsf;

import javax.faces.context.FacesContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class URLUtils {
    private static final Log log = LogFactory.getLog(URLUtils.class);
    private static final String X_FORWARDED_HOST = "x-forwarded-host";
    private static final String VH_HEADER = "nuxeo-virtual-host";

    private URLUtils() {
    }

    public static String getServerURL() {
        return URLUtils.getServerURL(null);
    }

    public static String getServerURL(ServletRequest request) {
        String baseURL = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null || request != null) {
            StringBuilder sbaseURL = new StringBuilder();
            if (request == null) {
                request = (ServletRequest)facesContext.getExternalContext().getRequest();
            }
            if (request instanceof HttpServletRequest) {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                String serverName = httpRequest.getServerName();
                int serverPort = httpRequest.getServerPort();
                String nuxeoVH = httpRequest.getHeader(VH_HEADER);
                if (nuxeoVH != null && nuxeoVH.contains("http")) {
                    return nuxeoVH;
                }
                String forwardedHost = httpRequest.getHeader(X_FORWARDED_HOST);
                if (forwardedHost != null) {
                    if (forwardedHost.contains(":")) {
                        serverName = forwardedHost.split(":")[0];
                        serverPort = Integer.valueOf(forwardedHost.split(":")[1]);
                    } else {
                        serverPort = 80;
                        serverName = forwardedHost;
                    }
                }
                String protocol = httpRequest.getScheme();
                sbaseURL.append(protocol);
                sbaseURL.append("://");
                sbaseURL.append(serverName);
                if (serverPort != 0 && ("http".equals(protocol) && serverPort != 80 || "https".equals(protocol) && serverPort != 443)) {
                    sbaseURL.append(':');
                    sbaseURL.append(serverPort);
                }
                sbaseURL.append('/');
                baseURL = sbaseURL.toString();
            }
        }
        if (baseURL == null) {
            log.error((Object)"Could not retrieve base url correctly");
        }
        return baseURL;
    }

    public static String getWebAppName() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null) {
            String baseURL = facesContext.getExternalContext().getRequestContextPath();
            baseURL = baseURL.replace("/", "");
            return baseURL;
        }
        return "nuxeo";
    }

    public static String getBaseURL() {
        String baseURL = null;
        String serverUrl = URLUtils.getServerURL();
        if (serverUrl != null) {
            baseURL = serverUrl + URLUtils.getWebAppName() + '/';
        }
        if (baseURL == null) {
            log.error((Object)"Could not retrieve base url correctly");
        }
        return baseURL;
    }

    public static String getBaseURL(ServletRequest request) {
        String baseURL = null;
        String serverUrl = URLUtils.getServerURL(request);
        if (serverUrl != null) {
            baseURL = serverUrl + URLUtils.getWebAppName() + '/';
        }
        if (baseURL == null) {
            log.error((Object)"Could not retrieve base url correctly");
        }
        return baseURL;
    }
}

