/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.impl.CompoundFilter;
import org.nuxeo.ecm.core.api.impl.FacetFilter;
import org.nuxeo.ecm.core.api.impl.LifeCycleFilter;
import org.nuxeo.ecm.core.api.tree.DefaultDocumentTreeSorter;
import org.nuxeo.ecm.platform.publisher.api.AbstractPublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.impl.core.VirtualCoreFolderPublicationNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreFolderPublicationNode
extends AbstractPublicationNode
implements PublicationNode {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CoreFolderPublicationNode.class);
    private static final String DEFAULT_SORT_PROP_NAME = "dc:title";
    protected DocumentModel folder;
    protected PublicationNode parent;
    protected String treeConfigName;
    protected PublishedDocumentFactory factory;
    protected String sid;

    public CoreFolderPublicationNode(DocumentModel doc, PublicationTree tree, PublishedDocumentFactory factory) throws ClientException {
        this.folder = doc;
        this.treeConfigName = tree.getConfigName();
        this.factory = factory;
        this.sid = tree.getSessionId();
    }

    public CoreFolderPublicationNode(DocumentModel doc, PublicationTree tree, PublicationNode parent, PublishedDocumentFactory factory) throws ClientException {
        this.folder = doc;
        this.treeConfigName = tree.getConfigName();
        this.parent = parent;
        this.factory = factory;
        this.sid = tree.getSessionId();
    }

    public CoreFolderPublicationNode(DocumentModel doc, String treeConfigName, String sid, PublicationNode parent, PublishedDocumentFactory factory) throws ClientException {
        this.folder = doc;
        this.treeConfigName = treeConfigName;
        this.parent = parent;
        this.factory = factory;
        this.sid = sid;
    }

    public CoreFolderPublicationNode(DocumentModel doc, String treeConfigName, String sid, PublishedDocumentFactory factory) throws ClientException {
        this.folder = doc;
        this.treeConfigName = treeConfigName;
        this.factory = factory;
        this.sid = sid;
    }

    protected CoreSession getCoreSession() {
        return CoreInstance.getInstance().getSession(this.folder.getSessionId());
    }

    public List<PublishedDocument> getChildrenDocuments() throws ClientException {
        DefaultDocumentTreeSorter sorter = new DefaultDocumentTreeSorter();
        sorter.setSortPropertyPath(DEFAULT_SORT_PROP_NAME);
        FacetFilter facetFilter = new FacetFilter(null, Arrays.asList("Folderish", "HiddenInNavigation"));
        LifeCycleFilter lfFilter = new LifeCycleFilter("deleted", false);
        DocumentModelList children = this.getCoreSession().getChildren(this.folder.getRef(), null, null, (Filter)new CompoundFilter(new Filter[]{facetFilter, lfFilter}), (Sorter)sorter);
        ArrayList<PublishedDocument> childrenDocs = new ArrayList<PublishedDocument>();
        for (DocumentModel child : children) {
            try {
                childrenDocs.add(this.factory.wrapDocumentModel(child));
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return childrenDocs;
    }

    public List<PublicationNode> getChildrenNodes() throws ClientException {
        DefaultDocumentTreeSorter sorter = new DefaultDocumentTreeSorter();
        sorter.setSortPropertyPath(DEFAULT_SORT_PROP_NAME);
        FacetFilter facetFilter = new FacetFilter(Arrays.asList("Folderish"), Arrays.asList("HiddenInNavigation"));
        LifeCycleFilter lfFilter = new LifeCycleFilter("deleted", false);
        DocumentModelList children = this.getCoreSession().getChildren(this.folder.getRef(), null, null, (Filter)new CompoundFilter(new Filter[]{facetFilter, lfFilter}), (Sorter)sorter);
        ArrayList<PublicationNode> childrenNodes = new ArrayList<PublicationNode>();
        for (DocumentModel child : children) {
            childrenNodes.add(new CoreFolderPublicationNode(child, this.treeConfigName, this.sid, this, this.factory));
        }
        return childrenNodes;
    }

    public String getTitle() throws ClientException {
        return this.folder.getTitle();
    }

    public String getName() throws ClientException {
        return this.folder.getName();
    }

    public PublicationNode getParent() {
        if (this.parent == null) {
            DocumentRef docRef = this.folder.getParentRef();
            try {
                this.parent = this.getCoreSession().hasPermission(docRef, "Read") ? new CoreFolderPublicationNode(this.getCoreSession().getDocument(this.folder.getParentRef()), this.treeConfigName, this.sid, this.factory) : new VirtualCoreFolderPublicationNode(this.getCoreSession().getSessionId(), docRef.toString(), this.treeConfigName, this.sid, this.factory);
            }
            catch (Exception e) {
                log.error((Object)"Error while retrieving parent: ", (Throwable)e);
            }
        }
        return this.parent;
    }

    public String getPath() {
        return this.folder.getPathAsString();
    }

    public String getTreeConfigName() {
        return this.treeConfigName;
    }

    public DocumentRef getTargetDocumentRef() {
        return this.folder.getRef();
    }

    public DocumentModel getTargetDocumentModel() {
        return this.folder;
    }

    public String getSessionId() {
        return this.sid;
    }
}

