/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocumentFactory;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionsFinder;
import org.nuxeo.ecm.platform.publisher.helper.RootSectionsFinderHelper;
import org.nuxeo.ecm.platform.publisher.impl.core.CoreFolderPublicationNode;
import org.nuxeo.ecm.platform.publisher.impl.core.SectionPublicationTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootSectionsPublicationTree
extends SectionPublicationTree {
    protected DocumentModel currentDocument;
    protected RootSectionsFinder rootFinder;
    protected boolean useRootSections = true;

    @Override
    public void initTree(String sid, CoreSession coreSession, Map<String, String> parameters, PublishedDocumentFactory factory, String configName, String title) throws ClientException {
        super.initTree(sid, coreSession, parameters, factory, configName, title);
        this.rootFinder = RootSectionsFinderHelper.getRootSectionsFinder((CoreSession)coreSession);
    }

    public List<PublicationNode> getChildrenNodes() throws ClientException {
        if (this.currentDocument != null && this.useRootSections) {
            DocumentModelList rootSections = this.rootFinder.getAccessibleSectionRoots(this.currentDocument);
            if (rootSections.isEmpty()) {
                this.useRootSections = false;
                return super.getChildrenNodes();
            }
            ArrayList<PublicationNode> publicationNodes = new ArrayList<PublicationNode>();
            for (DocumentModel rootSection : rootSections) {
                if (!this.isPublicationNode(rootSection)) continue;
                publicationNodes.add(new CoreFolderPublicationNode(rootSection, this.getConfigName(), this.sid, (CoreFolderPublicationNode)this.rootNode, this.factory));
            }
            return publicationNodes;
        }
        return super.getChildrenNodes();
    }

    public void setCurrentDocument(DocumentModel currentDocument) {
        this.currentDocument = currentDocument;
        this.rootFinder.reset();
        this.useRootSections = true;
    }

    @Override
    public PublicationNode getNodeByPath(String path) throws ClientException {
        if (!this.useRootSections) {
            return super.getNodeByPath(path);
        }
        if (path.equals(this.rootPath)) {
            return this;
        }
        List<PublicationNode> children = this.getChildrenNodes();
        for (PublicationNode child : children) {
            if (!child.getPath().equals(path)) continue;
            return child;
        }
        return super.getNodeByPath(path);
    }
}

