/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.impl.localfs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.publisher.api.AbstractPublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.impl.localfs.FSPublishedDocument;
import org.nuxeo.ecm.platform.publisher.impl.localfs.NotFSPublishedDocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSPublicationNode
extends AbstractPublicationNode
implements PublicationNode {
    private static final long serialVersionUID = 1L;
    protected File folder;
    protected String sid;

    public FSPublicationNode(String path, String treeName, String sid) {
        this(new File(path), treeName, sid);
    }

    public FSPublicationNode(File folder, String treeName, String sid) {
        if (!folder.exists()) {
            throw new IllegalArgumentException("Root publication folder does not exist");
        }
        this.folder = folder;
        this.treeName = treeName;
        this.sid = sid;
    }

    public List<PublishedDocument> getChildrenDocuments() throws ClientException {
        ArrayList<PublishedDocument> childrenDocs = new ArrayList<PublishedDocument>();
        List<File> children = Arrays.asList(this.folder.listFiles());
        Collections.sort(children);
        for (File child : children) {
            if (child.isDirectory()) continue;
            try {
                childrenDocs.add(new FSPublishedDocument(child));
            }
            catch (NotFSPublishedDocumentException e) {
                throw new ClientException("Error whild creating PublishedDocument from file", (Throwable)e);
            }
        }
        return childrenDocs;
    }

    public List<PublicationNode> getChildrenNodes() throws ClientException {
        ArrayList<PublicationNode> childrenNodes = new ArrayList<PublicationNode>();
        List<File> children = Arrays.asList(this.folder.listFiles());
        Collections.sort(children);
        for (File child : children) {
            if (!child.isDirectory()) continue;
            childrenNodes.add(new FSPublicationNode(child, this.getTreeConfigName(), this.sid));
        }
        return childrenNodes;
    }

    public String getName() throws ClientException {
        return this.folder.getName();
    }

    public PublicationNode getParent() {
        String parentPath = new Path(this.getPath()).removeLastSegments(1).toString();
        File parentFolder = new File(parentPath);
        return new FSPublicationNode(parentFolder, this.getTreeConfigName(), this.sid);
    }

    public String getPath() {
        return this.folder.getAbsolutePath();
    }

    public String getTitle() throws ClientException {
        return this.getName();
    }

    public String getSessionId() {
        return this.sid;
    }
}

