/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.client;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.RemotePublicationTreeManager;
import org.nuxeo.ecm.platform.publisher.impl.service.AbstractRemotableNode;
import org.nuxeo.ecm.platform.publisher.impl.service.ProxyNode;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.basic.BasicPublicationNode;

public class ClientRemotePublicationNode
extends AbstractRemotableNode {
    private static final long serialVersionUID = 1L;
    protected String targetTreeName = null;
    protected String name;
    protected String serverSessionId = null;
    protected String path;
    protected String nodeType;
    protected String nodeTitle;
    protected String treeName;

    public ClientRemotePublicationNode(String treeConfigName, String sid, PublicationNode node, String serverSessionId, RemotePublicationTreeManager service, String targetTreeName) throws ClientException {
        this.serverSessionId = serverSessionId;
        this.sessionId = sid;
        this.service = service;
        this.path = node.getPath();
        this.nodeType = node.getNodeType();
        this.nodeTitle = node.getTitle();
        this.treeName = treeConfigName;
        this.targetTreeName = targetTreeName;
        this.name = node.getName();
    }

    protected PublicationNode switchToServerNode(PublicationNode node) throws ClientException {
        if (node instanceof ClientRemotePublicationNode) {
            ClientRemotePublicationNode cNode = (ClientRemotePublicationNode)node;
            return new BasicPublicationNode(cNode.getNodeType(), cNode.getPath(), cNode.getTitle(), cNode.getUnwrappedTreeName(), this.serverSessionId);
        }
        if (node instanceof ProxyNode) {
            ProxyNode rNode = (ProxyNode)node;
            return new BasicPublicationNode(rNode.getNodeType(), rNode.getPath(), rNode.getTitle(), this.getTargetTreeName(), this.serverSessionId);
        }
        return node;
    }

    protected PublicationNode switchToClientNode(PublicationNode node) throws ClientException {
        return new ClientRemotePublicationNode(this.treeName, this.sessionId, node, this.serverSessionId, this.service, this.getTargetTreeName());
    }

    protected String getServerTreeSessionId() {
        return this.serverSessionId;
    }

    protected RemotePublicationTreeManager getPublisher() throws ClientException {
        return this.service;
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getType() {
        return this.getClass().getSimpleName();
    }

    public String getPath() {
        return this.path;
    }

    public String getTitle() {
        return this.nodeTitle;
    }

    public String getName() {
        return this.name;
    }

    public String getTreeConfigName() {
        return this.treeName;
    }

    protected String getTargetTreeName() {
        return this.targetTreeName;
    }

    public String getUnwrappedTreeName() {
        return this.getTargetTreeName();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getRemoteSessionId() {
        return this.serverSessionId;
    }
}

