/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.restHandler;

import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.api.RemotePublicationTreeManager;
import org.nuxeo.ecm.platform.publisher.remoting.restHandler.RemotePubMessageReader;
import org.nuxeo.ecm.platform.publisher.remoting.restHandler.RemotePubMessageWriter;
import org.nuxeo.ecm.platform.publisher.remoting.restHandler.RemotePubParam;
import org.nuxeo.ecm.platform.publisher.remoting.restHandler.RemotePubResult;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@Produces(value={"nuxeo/remotepub;charset=UTF-8"})
public class RestPublishingHandler
extends DefaultObject {
    protected RemotePublicationTreeManager getPublisher() {
        return (RemotePublicationTreeManager)Framework.getLocalService(RemotePublicationTreeManager.class);
    }

    @POST
    @Path(value="getChildrenDocuments")
    public RemotePubResult getChildrenDocuments(RemotePubParam param) throws ClientException {
        return new RemotePubResult(this.getPublisher().getChildrenDocuments(param.getAsNode()));
    }

    @POST
    @Path(value="getChildrenNodes")
    public RemotePubResult getChildrenNodes(RemotePubParam param) throws ClientException {
        return new RemotePubResult(this.getPublisher().getChildrenNodes(param.getAsNode()));
    }

    @POST
    @Path(value="getParent")
    public RemotePubResult getParent(RemotePubParam param) throws ClientException {
        return new RemotePubResult(this.getPublisher().getParent(param.getAsNode()));
    }

    @POST
    @Path(value="getNodeByPath")
    public RemotePubResult getNodeByPath(RemotePubParam param) throws ClientException {
        return new RemotePubResult(this.getPublisher().getNodeByPath((String)param.getParams().get(0), (String)param.getParams().get(1)));
    }

    @POST
    @Path(value="getExistingPublishedDocument")
    public RemotePubResult getExistingPublishedDocument(RemotePubParam param) throws ClientException {
        return new RemotePubResult(this.getPublisher().getExistingPublishedDocument((String)param.getParams().get(0), (DocumentLocation)param.getParams().get(1)));
    }

    @POST
    @Path(value="getPublishedDocumentInNode")
    public RemotePubResult getPublishedDocumentInNode(RemotePubParam param) throws ClientException {
        return new RemotePubResult(this.getPublisher().getPublishedDocumentInNode(param.getAsNode()));
    }

    @POST
    @Path(value="publish")
    public RemotePubResult publish(RemotePubParam param) throws ClientException {
        RemotePubResult result = param.getParams().size() == 2 ? new RemotePubResult(this.getPublisher().publish((DocumentModel)param.getParams().get(0), (PublicationNode)param.getParams().get(1))) : new RemotePubResult(this.getPublisher().publish((DocumentModel)param.getParams().get(0), (PublicationNode)param.getParams().get(1), (Map)param.getParams().get(2)));
        return result;
    }

    @POST
    @Path(value="unpublish")
    public void unpublish(RemotePubParam param) throws ClientException {
        Object object = param.getParams().get(1);
        if (object instanceof PublicationNode) {
            this.getPublisher().unpublish((DocumentModel)param.getParams().get(0), (PublicationNode)object);
        } else if (object instanceof PublishedDocument) {
            this.getPublisher().unpublish((String)param.getParams().get(0), (PublishedDocument)object);
        }
    }

    @POST
    @Path(value="initRemoteSession")
    public RemotePubResult initRemoteSession(RemotePubParam param) throws Exception {
        return new RemotePubResult(this.getPublisher().initRemoteSession((String)param.getParams().get(0), (Map)param.getParams().get(1)));
    }

    @POST
    @Path(value="release")
    public void release(RemotePubParam param) {
        this.getPublisher().release((String)param.getParams().get(0));
    }

    @GET
    @Path(value="release/{sid}")
    public void release(@PathParam(value="sid") String sid) {
        this.getPublisher().release(sid);
    }

    @GET
    @Path(value="ping")
    public String ping() {
        return "pong";
    }

    @GET
    @Path(value="superPing")
    public RemotePubResult superPing() {
        return new RemotePubResult("pong");
    }

    static {
        WebEngine we = (WebEngine)Framework.getLocalService(WebEngine.class);
        we.getRegistry().addMessageBodyWriter((MessageBodyWriter)new RemotePubMessageWriter());
        we.getRegistry().addMessageBodyReader((MessageBodyReader)new RemotePubMessageReader());
    }
}

