/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.remoting.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.publisher.api.PublicationNode;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.impl.core.SectionPublicationTree;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.ExtendedDocumentLocation;
import org.nuxeo.ecm.platform.publisher.remoting.marshaling.basic.BasicPublishedDocument;
import org.nuxeo.ecm.platform.publisher.remoting.server.ExternalCorePublishedDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreTreeWithExternalDocs
extends SectionPublicationTree
implements PublicationTree {
    private static final long serialVersionUID = 1L;

    @Override
    public List<PublishedDocument> getExistingPublishedDocument(DocumentLocation docLoc) throws ClientException {
        ArrayList<PublishedDocument> publishedDocs = new ArrayList<PublishedDocument>();
        if (docLoc instanceof ExtendedDocumentLocation) {
            ExtendedDocumentLocation xDocLoc = (ExtendedDocumentLocation)docLoc;
            String xsrv = xDocLoc.getOriginalServer();
            String source = xDocLoc.toString();
            List<DocumentModel> foundDocs = this.findDocumentsCommingFromExternalRef(this.treeRoot, source);
            for (DocumentModel doc : foundDocs) {
                publishedDocs.add(this.factory.wrapDocumentModel(doc));
            }
        } else if (this.getCoreSession().getRepositoryName().equals(docLoc.getServerName())) {
            publishedDocs.addAll(super.getExistingPublishedDocument(docLoc));
        }
        return publishedDocs;
    }

    protected List<DocumentModel> findDocumentsCommingFromExternalRef(DocumentModel root, String extRef) throws ClientException {
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
        for (DocumentModel child : this.getCoreSession().getChildren(root.getRef())) {
            if (child.isFolder()) {
                docs.addAll(this.findDocumentsCommingFromExternalRef(child, extRef));
                continue;
            }
            if (!extRef.equals(child.getProperty("dublincore", "source"))) continue;
            docs.add(child);
        }
        return docs;
    }

    @Override
    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        ExternalCorePublishedDocument publishedDocument = (ExternalCorePublishedDocument)this.factory.publishDocument(doc, targetNode);
        return publishedDocument;
    }

    @Override
    public PublishedDocument publish(DocumentModel doc, PublicationNode targetNode, Map<String, String> params) throws ClientException {
        ExternalCorePublishedDocument publishedDocument = (ExternalCorePublishedDocument)this.factory.publishDocument(doc, targetNode, params);
        return publishedDocument;
    }

    @Override
    public void unpublish(PublishedDocument publishedDocument) throws ClientException {
        if (publishedDocument instanceof BasicPublishedDocument || publishedDocument instanceof ExternalCorePublishedDocument) {
            String source = publishedDocument.getSourceRepositoryName() + "@" + publishedDocument.getSourceServer() + ":" + publishedDocument.getSourceDocumentRef();
            List<DocumentModel> foundDocs = this.findDocumentsCommingFromExternalRef(this.treeRoot, source);
            for (DocumentModel doc : foundDocs) {
                if (!doc.getPathAsString().equals(publishedDocument.getPath())) continue;
                this.getCoreSession().removeDocument(doc.getRef());
                this.getCoreSession().save();
                break;
            }
        } else {
            super.unpublish(publishedDocument);
        }
    }

    @Override
    public void unpublish(DocumentModel doc, PublicationNode targetNode) throws ClientException {
        PublicationNode realPublciationNode = this.getNodeByPath(targetNode.getPath());
        List publishedDocuments = this.getPublishedDocumentInNode(realPublciationNode);
        String source = (String)doc.getProperty("dublincore", "source");
        for (PublishedDocument publishedDocument : publishedDocuments) {
            String publishedDocumentSource = publishedDocument.getSourceRepositoryName() + "@" + publishedDocument.getSourceServer() + ":" + publishedDocument.getSourceDocumentRef();
            if (!source.equals(publishedDocumentSource)) continue;
            this.getCoreSession().removeDocument((DocumentRef)new PathRef(publishedDocument.getPath()));
            break;
        }
    }

    @Override
    public PublishedDocument wrapToPublishedDocument(DocumentModel documentModel) throws ClientException {
        return new ExternalCorePublishedDocument(documentModel);
    }
}

