/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.publisher.rules;

import java.util.Arrays;
import java.util.HashSet;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.publisher.rules.AbstractNuxeoCoreValidatorsRule;
import org.nuxeo.ecm.platform.publisher.rules.PublishingValidatorException;

public class DefaultValidatorsRule
extends AbstractNuxeoCoreValidatorsRule {
    private static final long serialVersionUID = 1L;

    public String[] computesValidatorsFor(DocumentModel dm) throws PublishingValidatorException {
        ACP acp;
        try {
            this.login();
            this.initializeCoreSession(dm.getRepositoryName());
        }
        catch (Exception e) {
            throw new PublishingValidatorException((Throwable)e);
        }
        try {
            acp = this.session.getACP(dm.getRef());
        }
        catch (ClientException ce) {
            throw new PublishingValidatorException((Throwable)ce);
        }
        HashSet<String> requiredPermissions = new HashSet<String>();
        requiredPermissions.addAll(Arrays.asList(this.session.getPermissionsToCheck("Write")));
        String[] reviewers = acp.listUsernamesForAnyPermission(requiredPermissions);
        try {
            this.closeCoreSession();
            this.logout();
        }
        catch (Exception e) {
            throw new PublishingValidatorException((Throwable)e);
        }
        return reviewers;
    }
}

