/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.persistence;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.nuxeo.ecm.core.persistence.EntityManagerFactoryProvider;
import org.nuxeo.ecm.core.persistence.HibernateConfiguration;
import org.nuxeo.ecm.core.persistence.HibernateConfigurator;
import org.nuxeo.ecm.core.persistence.PersistenceError;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class PersistenceComponent
extends DefaultComponent
implements HibernateConfigurator,
PersistenceProviderFactory {
    protected final Map<String, HibernateConfiguration> registry = new HashMap<String, HibernateConfiguration>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if ("hibernate".equals(extensionPoint)) {
            this.registerHibernateContribution((HibernateConfiguration)contribution, contributor.getName());
        }
    }

    protected void registerHibernateContribution(HibernateConfiguration contribution, ComponentName contributorName) {
        if (contribution.name == null) {
            throw new PersistenceError(contributorName + " should set the 'name' attribute of hibernate configurations");
        }
        if (contribution.hibernateProperties != null) {
            this.doPatchForTests(contribution.hibernateProperties);
        }
        if (!this.registry.containsKey(contribution.name)) {
            this.registry.put(contribution.name, contribution);
        } else {
            this.registry.get(contribution.name).merge(contribution);
        }
    }

    protected void doPatchForTests(Properties hibernateProperties) {
        String url = hibernateProperties.getProperty("hibernate.connection.url");
        if (url != null) {
            url = Framework.expandVars((String)url);
            hibernateProperties.put("hibernate.connection.url", url);
        }
    }

    public PersistenceProvider newProvider(String name) {
        EntityManagerFactoryProvider emfProvider = this.registry.get(name);
        if (emfProvider == null) {
            throw new PersistenceError("no hibernate configuration identified by '" + name + "' is available");
        }
        return new PersistenceProvider(emfProvider);
    }

    public HibernateConfiguration getHibernateConfiguration(String name) {
        HibernateConfiguration config = this.registry.get(name);
        if (config == null) {
            throw new PersistenceError("no hibernate configuration identified by '" + name + "' is available");
        }
        return config;
    }
}

