/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.webengine.ResourceBinding;
import org.nuxeo.ecm.webengine.ResourceRegistry;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.rendering.RenderingExtensionDescriptor;
import org.nuxeo.ecm.webengine.security.GuardDescriptor;
import org.nuxeo.ecm.webengine.security.PermissionService;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.annotations.loader.BundleAnnotationsLoader;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.RuntimeContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebEngineComponent
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName(WebEngineComponent.class.getName());
    public static final String RENDERING_EXTENSION_XP = "rendering-extension";
    public static final String RESOURCE_BINDING_XP = "resource";
    public static final String GUARD_XP = "guard";
    public static final String FORM_XP = "form";
    private static final Log log = LogFactory.getLog(WebEngineComponent.class);
    protected final Set<String> deployedBundles = new HashSet<String>();
    private WebEngine engine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        Bundle bundle = context.getRuntimeContext().getBundle();
        bundle.getBundleContext().addBundleListener((BundleListener)BundleAnnotationsLoader.getInstance());
        BundleAnnotationsLoader.getInstance().loadAnnotationsFromDeployedBundles(bundle);
        String webDir = Framework.getProperty((String)"org.nuxeo.ecm.web.root");
        File root = null;
        root = webDir != null ? new File(webDir) : new File(Framework.getRuntime().getHome(), "web");
        root = root.getCanonicalFile();
        log.info((Object)("Using web root: " + root));
        ResourceRegistry registry = (ResourceRegistry)Framework.getLocalService(ResourceRegistry.class);
        if (registry == null) {
            throw new Error("Could not find a server implementation");
        }
        this.engine = new WebEngine(registry, new File(root, "root.war"));
        final RuntimeContext ctx = context.getRuntimeContext();
        BundleContext bc = bundle.getBundleContext();
        bundle.getBundleContext().addBundleListener((BundleListener)new SynchronousBundleListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void bundleChanged(BundleEvent event) {
                try {
                    switch (event.getType()) {
                        case 2: {
                            Set<String> set = WebEngineComponent.this.deployedBundles;
                            synchronized (set) {
                                WebEngineComponent.this.deployModules(ctx, event.getBundle());
                                break;
                            }
                        }
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Failed to deploy web modules in bundle: " + event.getBundle().getSymbolicName()));
                }
            }
        });
        Set<String> set = this.deployedBundles;
        synchronized (set) {
            for (Bundle b : bc.getBundles()) {
                if (b.getState() != 32) continue;
                this.deployModules(ctx, b);
            }
        }
        this.engine.start();
    }

    protected void deployModules(RuntimeContext ctx, Bundle b) throws IOException {
        String id = b.getSymbolicName();
        if (this.deployedBundles.contains(id)) {
            return;
        }
        URL url = b.getEntry("module.xml");
        if (url == null) {
            return;
        }
        File bf = ctx.getRuntime().getBundleFile(b);
        if (bf == null) {
            log.warn((Object)("Bundle type not supported - cannot be resolved to a file. Bundle: " + b.getSymbolicName()));
            return;
        }
        this.deployedBundles.add(id);
        this.deployModule(id, bf, url);
    }

    protected void deployModule(String bundleId, File bundleFile, URL moduleConfig) throws IOException {
        if (this.checkHasNuxeoService(bundleId)) {
            throw new WebException("This webengine module should not define a Nuxeo Service, please split up.");
        }
        if (bundleFile.isDirectory()) {
            File cfg = new File(bundleFile, "module.xml");
            this.engine.registerModule(cfg);
        } else {
            File moduleRoot = new File(this.engine.getRootDirectory(), "modules/" + bundleId);
            File cfg = new File(moduleRoot, "module.xml");
            if (moduleRoot.exists()) {
                if (bundleFile.lastModified() < moduleRoot.lastModified()) {
                    this.engine.registerModule(cfg);
                    return;
                }
                moduleRoot.delete();
            }
            moduleRoot.mkdirs();
            ZipUtils.unzip((File)bundleFile, (File)moduleRoot);
            this.engine.registerModule(cfg);
        }
        log.info((Object)("Deployed web module found in bundle: " + bundleId));
    }

    protected boolean checkHasNuxeoService(String bundleId) {
        ComponentManager cpManager = Framework.getRuntime().getComponentManager();
        RegistrationInfo regInfo = cpManager.getRegistrationInfo(new ComponentName(bundleId));
        if (null == regInfo) {
            return false;
        }
        String[] serviceNames = regInfo.getProvidedServiceNames();
        return serviceNames != null && serviceNames.length != 0;
    }

    public void deactivate(ComponentContext context) throws Exception {
        context.getRuntimeContext().getBundle().getBundleContext().removeBundleListener((BundleListener)BundleAnnotationsLoader.getInstance());
        this.engine.stop();
        this.engine = null;
        super.deactivate(context);
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (GUARD_XP.equals(extensionPoint)) {
            GuardDescriptor gd = (GuardDescriptor)contribution;
            PermissionService.getInstance().registerGuard(gd.getId(), gd.getGuard());
        } else if (RESOURCE_BINDING_XP.equals(extensionPoint)) {
            this.engine.addResourceBinding((ResourceBinding)contribution);
        } else if (extensionPoint.equals(RENDERING_EXTENSION_XP)) {
            RenderingExtensionDescriptor fed = (RenderingExtensionDescriptor)contribution;
            try {
                this.engine.registerRenderingExtension(fed.name, fed.newInstance());
            }
            catch (Exception e) {
                throw new RuntimeServiceException("Deployment Error. Failed to contribute freemarker template extension: " + fed.name);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (GUARD_XP.equals(extensionPoint)) {
            GuardDescriptor gd = (GuardDescriptor)contribution;
            PermissionService.getInstance().unregisterGuard(gd.getId());
        } else if (RESOURCE_BINDING_XP.equals(extensionPoint)) {
            this.engine.removeResourceBinding((ResourceBinding)contribution);
        } else if (extensionPoint.equals(RENDERING_EXTENSION_XP)) {
            RenderingExtensionDescriptor fed = (RenderingExtensionDescriptor)contribution;
            this.engine.unregisterRenderingExtension(fed.name);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == WebEngine.class) {
            return adapter.cast(this.engine);
        }
        return null;
    }
}

