/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.debug;

import java.io.File;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.debug.FileEntry;
import org.nuxeo.ecm.webengine.model.impl.ModuleConfiguration;
import org.nuxeo.ecm.webengine.model.impl.ModuleImpl;
import org.nuxeo.ecm.webengine.model.impl.ModuleManager;
import org.nuxeo.runtime.api.Framework;

public class ReloadManager {
    private static final Log log = LogFactory.getLog(ReloadManager.class);
    protected final WebEngine engine;
    protected final FileEntry deploy;
    private final Timer timer = new Timer("ReloadManager");

    public ReloadManager(WebEngine engine) {
        this.engine = engine;
        this.deploy = new FileEntry(engine.getDeploymentDirectory());
    }

    public void start() {
        String interval = Framework.getProperty((String)"org.nuxeo.ecm.webengine.reloadInterval", (String)"2000");
        this.start(4000, Integer.parseInt(interval));
    }

    public void start(int startAfter, int interval) {
        this.timer.scheduleAtFixedRate((TimerTask)new Task(), startAfter, (long)interval);
    }

    public void stop() {
        this.timer.cancel();
        this.timer.purge();
    }

    private class Task
    extends TimerTask {
        private Task() {
        }

        public void run() {
            ModuleConfiguration[] modules;
            for (ModuleConfiguration mc : modules = ReloadManager.this.engine.getModuleManager().getModules()) {
                if (!mc.isLoaded()) continue;
                ModuleImpl module = (ModuleImpl)mc.get();
                module.getTracker().run();
            }
            if (ReloadManager.this.deploy.check()) {
                ModuleManager mgr = ReloadManager.this.engine.getModuleManager();
                ModuleConfiguration[] ar = mgr.getModules();
                HashSet<File> set = new HashSet<File>();
                for (ModuleConfiguration mc : ar) {
                    set.add(mc.file);
                }
                File root = ReloadManager.this.engine.getDeploymentDirectory();
                if (root.isDirectory()) {
                    for (File file : root.listFiles()) {
                        File f;
                        if (!file.isDirectory() || !(f = new File(file, "module.xml")).isFile() || set.remove(f)) continue;
                        try {
                            log.info((Object)("auto-deploying module: " + f));
                            mgr.loadModule(f);
                        }
                        catch (Exception e) {
                            log.error((Object)("Failed to load module: " + f), (Throwable)e);
                        }
                    }
                }
                String rootPath = root.getAbsolutePath();
                for (File f : set) {
                    ModuleConfiguration mc;
                    if (!f.getAbsolutePath().startsWith(rootPath) || (mc = mgr.getModuleByConfigFile(f)) == null) continue;
                    log.info((Object)("auto-undeploying module: " + mc.name));
                    mgr.unregisterModule(mc.name);
                }
            }
        }
    }
}

