/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.forms.validation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.nuxeo.ecm.webengine.forms.validation.CompositeValidator;
import org.nuxeo.ecm.webengine.forms.validation.EnumerationValidator;
import org.nuxeo.ecm.webengine.forms.validation.ExactLengthValidator;
import org.nuxeo.ecm.webengine.forms.validation.LengthValidator;
import org.nuxeo.ecm.webengine.forms.validation.RangeValidator;
import org.nuxeo.ecm.webengine.forms.validation.RegexValidator;
import org.nuxeo.ecm.webengine.forms.validation.TypeConvertor;
import org.nuxeo.ecm.webengine.forms.validation.ValidationException;
import org.nuxeo.ecm.webengine.forms.validation.annotations.Enumeration;
import org.nuxeo.ecm.webengine.forms.validation.annotations.FieldValidator;
import org.nuxeo.ecm.webengine.forms.validation.annotations.FormValidator;
import org.nuxeo.ecm.webengine.forms.validation.annotations.Length;
import org.nuxeo.ecm.webengine.forms.validation.annotations.NotNull;
import org.nuxeo.ecm.webengine.forms.validation.annotations.Range;
import org.nuxeo.ecm.webengine.forms.validation.annotations.Regex;
import org.nuxeo.ecm.webengine.forms.validation.annotations.Required;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormDescriptor {
    protected org.nuxeo.ecm.webengine.forms.validation.FormValidator validator;
    protected Map<String, Field> fields = new HashMap<String, Field>();
    protected HashSet<String> requiredFields = new HashSet();

    public FormDescriptor(Class<?> type) throws Exception {
        Method[] methods = type.getMethods();
        int mod = type.getModifiers();
        if (!Modifier.isInterface(mod)) {
            throw new IllegalArgumentException("Form type is not an interface");
        }
        for (Method m : methods) {
            String name = m.getName();
            if (!name.startsWith("get")) continue;
            name = FormDescriptor.getFieldName(name, name.length());
            Field field = new Field(m, name);
            if (field.required) {
                this.requiredFields.add(field.name);
            }
            this.fields.put(name, field);
        }
        FormValidator fv = type.getAnnotation(FormValidator.class);
        if (fv != null) {
            this.validator = fv.value().newInstance();
        }
    }

    static String getFieldName(String key, int len) {
        if (len == 4) {
            return "" + Character.toLowerCase(key.charAt(3));
        }
        return Character.toLowerCase(key.charAt(3)) + key.substring(4);
    }

    static class Field {
        CompositeValidator validator = new CompositeValidator();
        String name;
        Method m;
        boolean isArray;
        boolean required;
        boolean notnull;
        String defaultValue;
        TypeConvertor<?> convertor;

        Field(Method m, String name) throws Exception {
            FieldValidator custom;
            Range range;
            Length length;
            Regex regex;
            NotNull nn = m.getAnnotation(NotNull.class);
            if (nn != null) {
                String dv = nn.value();
                if (dv.length() > 0) {
                    this.defaultValue = dv;
                } else {
                    this.notnull = true;
                }
            }
            this.required = m.isAnnotationPresent(Required.class);
            Enumeration aenum = m.getAnnotation(Enumeration.class);
            if (aenum != null) {
                this.validator.add(new EnumerationValidator(aenum.value()));
            }
            if ((regex = m.getAnnotation(Regex.class)) != null) {
                this.validator.add(new RegexValidator(regex.value()));
            }
            if ((length = m.getAnnotation(Length.class)) != null) {
                if (length.value() > -1) {
                    this.validator.add(new ExactLengthValidator(length.value()));
                } else {
                    this.validator.add(new LengthValidator(length.min(), length.max()));
                }
            }
            if ((range = m.getAnnotation(Range.class)) != null) {
                this.validator.add(new RangeValidator(range.min(), range.max(), range.negate()));
            }
            if ((custom = m.getAnnotation(FieldValidator.class)) != null) {
                this.validator.add((org.nuxeo.ecm.webengine.forms.validation.FieldValidator)((Object)custom.value().newInstance()));
            }
            Class<?> rtype = m.getReturnType();
            this.isArray = rtype.isArray();
            if (this.isArray) {
                rtype = rtype.getComponentType();
            }
            this.convertor = TypeConvertor.getConvertor(rtype);
            this.m = m;
            this.name = name;
        }

        Object validate(String value) throws ValidationException {
            if (value == null || value.length() == 0) {
                value = null;
                if (this.notnull) {
                    throw new ValidationException();
                }
                if (this.defaultValue != null) {
                    value = this.defaultValue;
                }
            }
            String obj = value;
            if (this.convertor != null) {
                obj = this.convertor.convert(value);
            }
            if (this.validator != null) {
                this.validator.validate(value, obj);
            }
            return obj;
        }

        Object[] validateArray(String[] values) throws ValidationException {
            ArrayList<Object> result = new ArrayList<Object>();
            for (String value : values) {
                result.add(this.validate(value));
            }
            if (this.convertor != null) {
                return result.toArray(this.convertor.newArray(values.length));
            }
            return result.toArray(new String[values.length]);
        }
    }
}

