/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.loader;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.loader.store.ResourceStore;
import org.nuxeo.ecm.webengine.loader.store.ResourceStoreClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReloadingClassLoader
extends ClassLoader {
    private final Log log = LogFactory.getLog(ReloadingClassLoader.class);
    private final ClassLoader parent;
    private final List<ResourceStore> stores;
    private ResourceStoreClassLoader delegate;

    public ReloadingClassLoader(ClassLoader pParent) {
        super(pParent);
        this.parent = pParent;
        this.stores = new ArrayList<ResourceStore>();
        this.delegate = new ResourceStoreClassLoader(this.parent, new ResourceStore[0]);
    }

    public synchronized void addResourceStore(ResourceStore store) {
        this.stores.add(store);
        this.reload();
    }

    public synchronized boolean removeResourceStore(ResourceStore store) {
        boolean ret = this.stores.remove(store);
        if (ret) {
            this.delegate = new ResourceStoreClassLoader(this.parent, this.stores.toArray(new ResourceStore[this.stores.size()]));
            return true;
        }
        return false;
    }

    public void reload() {
        this.delegate = new ResourceStoreClassLoader(this.parent, this.stores.toArray(new ResourceStore[this.stores.size()]));
    }

    @Override
    public void clearAssertionStatus() {
        this.delegate.clearAssertionStatus();
    }

    @Override
    public URL getResource(String name) {
        return this.delegate.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.delegate.getResourceAsStream(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.delegate.loadClass(name);
    }

    @Override
    public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.delegate.loadClass(name, resolve);
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        this.delegate.setClassAssertionStatus(className, enabled);
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        this.delegate.setDefaultAssertionStatus(enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.delegate.setPackageAssertionStatus(packageName, enabled);
    }
}

